/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.parser;

import java.io.IOException;
import java.util.Map;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CommonRpcParser;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmInterface;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetParamsetDescriptionParser
extends CommonRpcParser<Object[], Void> {
    private final Logger logger = LoggerFactory.getLogger(GetParamsetDescriptionParser.class);
    private HmParamsetType paramsetType;
    private HmChannel channel;
    private boolean isHmIpDevice;

    public GetParamsetDescriptionParser(HmChannel channel, HmParamsetType paramsetType) {
        this.channel = channel;
        this.paramsetType = paramsetType;
        this.isHmIpDevice = channel.getDevice().getHmInterface() == HmInterface.HMIP;
    }

    @Override
    public Void parse(Object[] message) throws IOException {
        if (!(message[0] instanceof Map)) {
            this.logger.debug("Unexpected datatype '{}',  ignoring message", message[0].getClass());
            return null;
        }
        Map dpNames = (Map)message[0];
        for (String datapointName : dpNames.keySet()) {
            Map dpMeta = (Map)dpNames.get(datapointName);
            HmDatapoint dp = this.assembleDatapoint(datapointName, this.toString(dpMeta.get("UNIT")), this.toString(dpMeta.get("TYPE")), this.toOptionList(dpMeta.get("VALUE_LIST")), dpMeta.get("MIN"), dpMeta.get("MAX"), this.toInteger(dpMeta.get("OPERATIONS")), dpMeta.get("DEFAULT"), this.paramsetType, this.isHmIpDevice);
            this.channel.addDatapoint(dp);
        }
        return null;
    }
}

