/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.smarthome.binding.homematic.internal.common.HomematicConfig;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.BinRpcMessage;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.RpcRequest;
import org.eclipse.smarthome.binding.homematic.internal.communicator.server.BinRpcResponseHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.server.RpcEventListener;
import org.eclipse.smarthome.binding.homematic.internal.communicator.server.RpcResponseHandler;
import org.eclipse.smarthome.core.common.ThreadPoolManager;

public class BinRpcNetworkService
implements Runnable {
    private static final byte[] BIN_EMPTY_STRING;
    private static final byte[] BIN_EMPTY_ARRAY;
    private static final byte[] BIN_EMPTY_EVENT_LIST;
    private static final String RPC_POOL_NAME = "homematicRpc";
    private ServerSocket serverSocket;
    private boolean accept = true;
    private HomematicConfig config;
    private RpcResponseHandler<byte[]> rpcResponseHandler;

    static {
        byte[] byArray = new byte[16];
        byArray[0] = 66;
        byArray[1] = 105;
        byArray[2] = 110;
        byArray[3] = 1;
        byArray[7] = 8;
        byArray[11] = 3;
        BIN_EMPTY_STRING = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[0] = 66;
        byArray2[1] = 105;
        byArray2[2] = 110;
        byArray2[3] = 1;
        byArray2[7] = 8;
        byArray2[10] = 1;
        BIN_EMPTY_ARRAY = byArray2;
        byte[] byArray3 = new byte[29];
        byArray3[0] = 66;
        byArray3[1] = 105;
        byArray3[2] = 110;
        byArray3[3] = 1;
        byArray3[7] = 21;
        byArray3[10] = 1;
        byArray3[15] = 1;
        byArray3[19] = 3;
        byArray3[23] = 5;
        byArray3[24] = 101;
        byArray3[25] = 118;
        byArray3[26] = 101;
        byArray3[27] = 110;
        byArray3[28] = 116;
        BIN_EMPTY_EVENT_LIST = byArray3;
    }

    public BinRpcNetworkService(RpcEventListener listener, final HomematicConfig config) throws IOException {
        this.config = config;
        this.serverSocket = new ServerSocket();
        this.serverSocket.setReuseAddress(true);
        this.serverSocket.bind(new InetSocketAddress(config.getCallbackHost(), config.getBinCallbackPort()));
        this.rpcResponseHandler = new RpcResponseHandler<byte[]>(listener){

            @Override
            protected byte[] getEmptyStringResult() {
                return BIN_EMPTY_STRING;
            }

            @Override
            protected byte[] getEmptyEventListResult() {
                return BIN_EMPTY_EVENT_LIST;
            }

            @Override
            protected byte[] getEmptyArrayResult() {
                return BIN_EMPTY_ARRAY;
            }

            @Override
            protected RpcRequest<byte[]> createRpcRequest() {
                return new BinRpcMessage(null, BinRpcMessage.TYPE.RESPONSE, config.getEncoding());
            }
        };
    }

    @Override
    public void run() {
        while (this.accept) {
            try {
                Socket cs = this.serverSocket.accept();
                BinRpcResponseHandler rpcHandler = new BinRpcResponseHandler(cs, this.rpcResponseHandler, this.config);
                ThreadPoolManager.getPool((String)RPC_POOL_NAME).execute(rpcHandler);
            }
            catch (IOException iOException) {}
        }
    }

    public void shutdown() {
        this.accept = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {}
    }
}

