/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.server;

import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import org.eclipse.smarthome.binding.homematic.internal.common.HomematicConfig;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.BinRpcMessage;
import org.eclipse.smarthome.binding.homematic.internal.communicator.server.RpcResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinRpcResponseHandler
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(BinRpcResponseHandler.class);
    private Socket socket;
    private RpcResponseHandler<byte[]> rpcResponseHandler;
    private HomematicConfig config;
    private long created;

    public BinRpcResponseHandler(Socket socket, RpcResponseHandler<byte[]> rpcResponseHandler, HomematicConfig config) {
        this.socket = socket;
        this.rpcResponseHandler = rpcResponseHandler;
        this.config = config;
        this.created = System.currentTimeMillis();
    }

    @Override
    public void run() {
        block15: {
            try {
                boolean isMaxAliveReached;
                do {
                    BinRpcMessage message = new BinRpcMessage(this.socket.getInputStream(), true, this.config.getEncoding());
                    this.logger.trace("Event BinRpcMessage: {}", (Object)message);
                    byte[] returnValue = this.rpcResponseHandler.handleMethodCall(message.getMethodName(), message.getResponseData());
                    if (returnValue == null) continue;
                    this.socket.getOutputStream().write(returnValue);
                } while (!(isMaxAliveReached = System.currentTimeMillis() - this.created > (long)(this.config.getSocketMaxAlive() * 1000)));
            }
            catch (EOFException eOFException) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
                break block15;
            }
            catch (Exception e) {
                try {
                    this.logger.warn("{}", (Object)e.getMessage(), (Object)e);
                }
                catch (Throwable throwable) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
                break block15;
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }
}

