/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.virtual;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.AbstractVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatteryTypeVirtualDatapointHandler
extends AbstractVirtualDatapointHandler {
    private final Logger logger = LoggerFactory.getLogger(BatteryTypeVirtualDatapointHandler.class);
    private static final Properties batteries = new Properties();

    public BatteryTypeVirtualDatapointHandler() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream stream = bundle.getResource("homematic/batteries.properties").openStream();){
                batteries.load(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | IllegalStateException e) {
            this.logger.warn("The resource homematic/batteries.properties could not be loaded! Battery types not available", (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "BATTERY_TYPE";
    }

    @Override
    public void initialize(HmDevice device) {
        String batteryType = batteries.getProperty(device.getType());
        if (batteryType != null) {
            this.addDatapoint(device, 0, this.getName(), HmValueType.STRING, batteryType, true);
        }
    }
}

