/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.virtual;

import java.io.IOException;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.AbstractVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.VirtualGateway;
import org.eclipse.smarthome.binding.homematic.internal.misc.HomematicClientException;
import org.eclipse.smarthome.binding.homematic.internal.misc.MiscUtils;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointConfig;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmInterface;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteDeviceVirtualDatapointHandler
extends AbstractVirtualDatapointHandler {
    private final Logger logger = LoggerFactory.getLogger(DeleteDeviceVirtualDatapointHandler.class);

    @Override
    public String getName() {
        return "DELETE_DEVICE";
    }

    @Override
    public void initialize(HmDevice device) {
        if (!device.isGatewayExtras() && device.getHmInterface() != HmInterface.CUXD) {
            this.addDatapoint(device, 0, this.getName(), HmValueType.BOOL, Boolean.FALSE, false);
        }
    }

    @Override
    public boolean canHandleCommand(HmDatapoint dp, Object value) {
        return this.getName().equals(dp.getName());
    }

    @Override
    public void handleCommand(VirtualGateway gateway, HmDatapoint dp, HmDatapointConfig dpConfig, Object value) throws IOException, HomematicClientException {
        block18: {
            dp.setValue(value);
            if (!MiscUtils.isTrueValue(dp.getValue())) break block18;
            try {
                HmDatapoint deleteMode = dp.getChannel().getDatapoint(HmDatapointInfo.createValuesInfo(dp.getChannel(), "DELETE_DEVICE_MODE"));
                HmDevice device = dp.getChannel().getDevice();
                int flag = -1;
                switch (deleteMode.getOptionValue()) {
                    case "RESET": {
                        flag = 1;
                        break;
                    }
                    case "FORCE": {
                        flag = 2;
                        break;
                    }
                    case "DEFER": {
                        flag = 4;
                    }
                }
                if (flag == -1) {
                    this.logger.info("Can't delete device '{}' from gateway '{}', DELETE_MODE is LOCKED", (Object)device.getAddress(), (Object)gateway.getId());
                } else {
                    gateway.getRpcClient(device.getHmInterface()).deleteDevice(device, flag);
                }
            }
            finally {
                gateway.disableDatapoint(dp, 2.0);
            }
        }
    }
}

