/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.virtual;

import java.io.IOException;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.AbstractVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.VirtualGateway;
import org.eclipse.smarthome.binding.homematic.internal.misc.HomematicClientException;
import org.eclipse.smarthome.binding.homematic.internal.misc.MiscUtils;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointConfig;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmInterface;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;

public class InstallModeVirtualDatapoint
extends AbstractVirtualDatapointHandler {
    @Override
    public String getName() {
        return "INSTALL_MODE";
    }

    @Override
    public void initialize(HmDevice device) {
        if (device.isGatewayExtras()) {
            this.addDatapoint(device, 0, this.getName(), HmValueType.BOOL, Boolean.FALSE, false);
        }
    }

    @Override
    public boolean canHandleCommand(HmDatapoint dp, Object value) {
        return this.getName().equals(dp.getName());
    }

    @Override
    public void handleCommand(VirtualGateway gateway, HmDatapoint dp, HmDatapointConfig dpConfig, Object value) throws IOException, HomematicClientException {
        dp.setValue(value);
        boolean enable = MiscUtils.isTrueValue(value);
        int duration = this.getDuration(dp.getChannel());
        if (enable) {
            gateway.disableDatapoint(dp, duration);
        }
        HmInterface hmInterface = dp.getChannel().getDevice().getHmInterface();
        gateway.getRpcClient(hmInterface).setInstallMode(hmInterface, enable, duration);
    }

    private Integer getDuration(HmChannel channel) {
        HmDatapoint dpDuration = channel.getDatapoint(HmDatapointInfo.createValuesInfo(channel, "INSTALL_MODE_DURATION"));
        return dpDuration == null || dpDuration.getValue() == null || dpDuration.getType() != HmValueType.INTEGER ? 60 : ((Number)dpDuration.getValue()).intValue();
    }
}

