/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.virtual;

import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.AbstractVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.VirtualGateway;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;

public class RssiVirtualDatapointHandler
extends AbstractVirtualDatapointHandler {
    @Override
    public String getName() {
        return "RSSI";
    }

    @Override
    public void initialize(HmDevice device) {
        if (this.isWirelessDevice(device)) {
            HmDatapoint dp = this.addDatapoint(device, 0, this.getName(), HmValueType.INTEGER, this.getRssiValue(device.getChannel(0)), true);
            dp.setUnit("dBm");
            dp.setMinValue(Integer.MIN_VALUE);
            dp.setMaxValue(Integer.MAX_VALUE);
        }
    }

    @Override
    public boolean canHandleEvent(HmDatapoint dp) {
        return this.isWirelessDevice(dp.getChannel().getDevice()) && ("RSSI_DEVICE".equals(dp.getName()) || "RSSI_PEER".equals(dp.getName()));
    }

    @Override
    public void handleEvent(VirtualGateway gateway, HmDatapoint dp) {
        HmChannel channel = dp.getChannel();
        Integer value = this.getRssiValue(channel);
        HmDatapoint vdpRssi = this.getVirtualDatapoint(channel);
        vdpRssi.setValue(value);
    }

    protected Integer getRssiValue(HmChannel channel) {
        HmDatapoint dpRssiDevice = channel.getDatapoint(HmParamsetType.VALUES, "RSSI_DEVICE");
        HmDatapoint dpRssiPeer = channel.getDatapoint(HmParamsetType.VALUES, "RSSI_PEER");
        Integer deviceValue = this.getDatapointValue(dpRssiDevice);
        Integer peerValue = this.getDatapointValue(dpRssiPeer);
        if ((deviceValue == null || deviceValue == 0) && peerValue != null) {
            return peerValue;
        }
        return deviceValue;
    }

    private Integer getDatapointValue(HmDatapoint dp) {
        if (dp == null || dp.getValue() == null || (Integer)dp.getValue() == 0) {
            return null;
        }
        return (Integer)dp.getValue();
    }

    protected boolean isWirelessDevice(HmDevice device) {
        return device.getChannel(0).getDatapoint(HmParamsetType.VALUES, "RSSI_DEVICE") != null;
    }
}

