/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApiVersion {
    private final int major;
    private final int minor;
    private final int micro;
    private static final Pattern versionPattern = Pattern.compile("^([0-9]+)\\.([0-9]+)(\\.([0-9]+))?$");

    public ApiVersion(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public static ApiVersion of(String version) {
        Matcher matcher = versionPattern.matcher(version);
        if (matcher.matches()) {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            String microString = matcher.group(4);
            int micro = Integer.parseInt(microString == null ? "0" : microString);
            ApiVersion apiVersion = new ApiVersion(major, minor, micro);
            return apiVersion;
        }
        throw new IllegalArgumentException("Version \"" + version + "\" is not valid");
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public int compare(ApiVersion other) {
        int c = Integer.compare(this.major, other.major);
        if (c == 0 && (c = Integer.compare(this.minor, other.minor)) == 0) {
            c = Integer.compare(this.micro, other.micro);
        }
        return c;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.micro;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiVersion other = (ApiVersion)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.micro != other.micro) {
            return false;
        }
        return this.minor == other.minor;
    }

    public String toString() {
        return String.valueOf(this.major) + "." + this.minor + "." + this.micro;
    }
}

