/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal.handler;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.hue.internal.ApiVersionUtils;
import org.eclipse.smarthome.binding.hue.internal.Config;
import org.eclipse.smarthome.binding.hue.internal.ConfigUpdate;
import org.eclipse.smarthome.binding.hue.internal.FullConfig;
import org.eclipse.smarthome.binding.hue.internal.FullLight;
import org.eclipse.smarthome.binding.hue.internal.FullSensor;
import org.eclipse.smarthome.binding.hue.internal.HttpClient;
import org.eclipse.smarthome.binding.hue.internal.HueBindingConstants;
import org.eclipse.smarthome.binding.hue.internal.HueBridge;
import org.eclipse.smarthome.binding.hue.internal.State;
import org.eclipse.smarthome.binding.hue.internal.StateUpdate;
import org.eclipse.smarthome.binding.hue.internal.config.HueBridgeConfig;
import org.eclipse.smarthome.binding.hue.internal.exceptions.ApiException;
import org.eclipse.smarthome.binding.hue.internal.exceptions.DeviceOffException;
import org.eclipse.smarthome.binding.hue.internal.exceptions.LinkButtonException;
import org.eclipse.smarthome.binding.hue.internal.exceptions.UnauthorizedException;
import org.eclipse.smarthome.binding.hue.internal.handler.HueClient;
import org.eclipse.smarthome.binding.hue.internal.handler.LightStateConverter;
import org.eclipse.smarthome.binding.hue.internal.handler.LightStatusListener;
import org.eclipse.smarthome.binding.hue.internal.handler.SensorStatusListener;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.core.status.ConfigStatusMessage;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.ConfigStatusBridgeHandler;
import org.eclipse.smarthome.core.types.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class HueBridgeHandler
extends ConfigStatusBridgeHandler
implements HueClient {
    private static final int DEFAULT_POLLING_INTERVAL = 10;
    private static final int DEFAULT_SENSOR_POLLING_INTERVAL = 500;
    final ReentrantLock pollingLock = new ReentrantLock();
    private static final String STATE_ADDED = "added";
    private static final String STATE_CHANGED = "changed";
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(HueBindingConstants.THING_TYPE_BRIDGE);
    private static final String DEVICE_TYPE = "EclipseSmartHome";
    private final Logger logger = LoggerFactory.getLogger(HueBridgeHandler.class);
    private final Map<String, FullLight> lastLightStates = new ConcurrentHashMap<String, FullLight>();
    private final Map<String, FullSensor> lastSensorStates = new ConcurrentHashMap<String, FullSensor>();
    private boolean lastBridgeConnectionState = false;
    private boolean propertiesInitializedSuccessfully = false;
    private final List<LightStatusListener> lightStatusListeners = new CopyOnWriteArrayList<LightStatusListener>();
    private final List<SensorStatusListener> sensorStatusListeners = new CopyOnWriteArrayList<SensorStatusListener>();
    private @Nullable ScheduledFuture<?> pollingJob;
    private @Nullable ScheduledFuture<?> sensorPollingJob;
    @NonNullByDefault(value={})
    private HueBridge hueBridge = null;
    @NonNullByDefault(value={})
    private HueBridgeConfig hueBridgeConfig = null;
    private final Runnable sensorPollingRunnable = new PollingRunnable(this){

        @Override
        protected void doConnectedRun() throws IOException, ApiException {
            HashMap lastSensorStateCopy = new HashMap(lastSensorStates);
            for (FullSensor fullSensor : hueBridge.getSensors()) {
                String sensorId = fullSensor.getId();
                if (lastSensorStateCopy.containsKey(sensorId)) {
                    FullSensor lastFullSensor = (FullSensor)lastSensorStateCopy.remove(sensorId);
                    Map<String, Object> lastFullSensorState = lastFullSensor.getState();
                    lastSensorStates.put(sensorId, fullSensor);
                    if (lastFullSensorState.equals(fullSensor.getState())) continue;
                    logger.debug("Status update for Hue sensor '{}' detected: {}", (Object)sensorId, fullSensor.getState());
                    this.notifySensorStatusListeners(fullSensor, HueBridgeHandler.STATE_CHANGED);
                    continue;
                }
                lastSensorStates.put(sensorId, fullSensor);
                logger.debug("Hue sensor '{}' added.", (Object)sensorId);
                this.notifySensorStatusListeners(fullSensor, HueBridgeHandler.STATE_ADDED);
            }
            for (Map.Entry entry : lastSensorStateCopy.entrySet()) {
                lastSensorStates.remove(entry.getKey());
                logger.debug("Hue sensor '{}' removed.", entry.getKey());
                for (SensorStatusListener sensorStatusListener : sensorStatusListeners) {
                    try {
                        sensorStatusListener.onSensorRemoved(hueBridge, (FullSensor)entry.getValue());
                    }
                    catch (Exception e) {
                        logger.error("An exception occurred while calling the Sensor Listeners", (Throwable)e);
                    }
                }
            }
        }
    };
    private final Runnable pollingRunnable = new PollingRunnable(this){

        @Override
        protected void doConnectedRun() throws IOException, ApiException {
            HashMap lastLightStateCopy = new HashMap(lastLightStates);
            List<FullLight> lights = ApiVersionUtils.supportsFullLights(hueBridge.getVersion()) ? hueBridge.getFullLights() : hueBridge.getFullConfig().getLights();
            for (FullLight fullLight : lights) {
                String lightId = fullLight.getId();
                if (lastLightStateCopy.containsKey(lightId)) {
                    FullLight lastFullLight = (FullLight)lastLightStateCopy.remove(lightId);
                    State lastFullLightState = lastFullLight.getState();
                    lastLightStates.put(lightId, fullLight);
                    if (this.isEqual(lastFullLightState, fullLight.getState())) continue;
                    logger.debug("Status update for Hue light '{}' detected.", (Object)lightId);
                    this.notifyLightStatusListeners(fullLight, HueBridgeHandler.STATE_CHANGED);
                    continue;
                }
                lastLightStates.put(lightId, fullLight);
                logger.debug("Hue light '{}' added.", (Object)lightId);
                this.notifyLightStatusListeners(fullLight, HueBridgeHandler.STATE_ADDED);
            }
            for (Map.Entry entry : lastLightStateCopy.entrySet()) {
                lastLightStates.remove(entry.getKey());
                logger.debug("Hue light '{}' removed.", entry.getKey());
                for (LightStatusListener lightStatusListener : lightStatusListeners) {
                    try {
                        lightStatusListener.onLightRemoved(hueBridge, (FullLight)entry.getValue());
                    }
                    catch (Exception e) {
                        logger.error("An exception occurred while calling the BridgeHeartbeatListener", (Throwable)e);
                    }
                }
            }
        }
    };

    public HueBridgeHandler(Bridge bridge) {
        super(bridge);
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
    }

    @Override
    public void updateLightState(FullLight light, StateUpdate stateUpdate) {
        if (this.hueBridge != null) {
            ((CompletableFuture)this.hueBridge.setLightState(light, stateUpdate).thenAccept(result -> {
                try {
                    this.hueBridge.handleErrors((HttpClient.Result)result);
                }
                catch (Exception e) {
                    this.handleStateUpdateException(light, stateUpdate, e);
                }
            })).exceptionally(e -> {
                this.handleStateUpdateException(light, stateUpdate, (Throwable)e);
                return null;
            });
        } else {
            this.logger.warn("No bridge connected or selected. Cannot set light state.");
        }
    }

    @Override
    public void updateSensorConfig(FullSensor sensor, ConfigUpdate configUpdate) {
        if (this.hueBridge != null) {
            ((CompletableFuture)this.hueBridge.updateSensorConfig(sensor, configUpdate).thenAccept(result -> {
                try {
                    this.hueBridge.handleErrors((HttpClient.Result)result);
                }
                catch (Exception e) {
                    this.handleConfigUpdateException(sensor, configUpdate, e);
                }
            })).exceptionally(e -> {
                this.handleConfigUpdateException(sensor, configUpdate, (Throwable)e);
                return null;
            });
        } else {
            this.logger.warn("No bridge connected or selected. Cannot set sensor config.");
        }
    }

    private void handleStateUpdateException(FullLight light, StateUpdate stateUpdate, Throwable e) {
        if (e instanceof DeviceOffException) {
            if (stateUpdate.getColorTemperature() != null && stateUpdate.getBrightness() == null) {
                return;
            }
            this.updateLightState(light, LightStateConverter.toOnOffLightState(OnOffType.ON));
            this.updateLightState(light, stateUpdate);
        } else if (e instanceof IOException) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getMessage());
        } else if (e instanceof ApiException) {
            this.logger.warn("Error while accessing light: {}", (Object)e.getMessage(), (Object)e);
        } else if (e instanceof IllegalStateException) {
            this.logger.trace("Error while accessing light: {}", (Object)e.getMessage());
        }
    }

    private void handleConfigUpdateException(FullSensor sensor, ConfigUpdate configUpdate, Throwable e) {
        if (e instanceof IOException) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getMessage());
        } else if (e instanceof ApiException) {
            this.logger.warn("Error while accessing sensor: {}", (Object)e.getMessage(), (Object)e);
        } else if (e instanceof IllegalStateException) {
            this.logger.trace("Error while accessing sensor: {}", (Object)e.getMessage());
        }
    }

    public void dispose() {
        this.logger.debug("Handler disposed.");
        if (this.pollingJob != null && !this.pollingJob.isCancelled()) {
            this.pollingJob.cancel(true);
            this.pollingJob = null;
        }
        if (this.sensorPollingJob != null && !this.sensorPollingJob.isCancelled()) {
            this.sensorPollingJob.cancel(true);
            this.sensorPollingJob = null;
        }
        if (this.hueBridge != null) {
            this.hueBridge = null;
        }
    }

    public void initialize() {
        this.logger.debug("Initializing hue bridge handler.");
        this.hueBridgeConfig = (HueBridgeConfig)this.getConfigAs(HueBridgeConfig.class);
        if (this.hueBridgeConfig.getIpAddress() == null || this.hueBridgeConfig.getIpAddress().isEmpty()) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.CONFIGURATION_ERROR, "@text/offline.conf-error-no-ip-address");
        } else {
            if (this.hueBridge == null) {
                this.hueBridge = new HueBridge(this.hueBridgeConfig.getIpAddress(), this.scheduler);
                this.hueBridge.setTimeout(5000);
            }
            this.onUpdate();
        }
    }

    private synchronized void onUpdate() {
        if (this.hueBridge != null) {
            if (this.pollingJob == null || this.pollingJob.isCancelled()) {
                int pollingInterval = 10;
                if (this.hueBridgeConfig.getPollingInterval() < 1) {
                    this.logger.info("Wrong configuration value for polling interval. Using default value: {}s", (Object)pollingInterval);
                } else {
                    pollingInterval = this.hueBridgeConfig.getPollingInterval();
                }
                this.pollingJob = this.scheduler.scheduleWithFixedDelay(this.pollingRunnable, 1L, pollingInterval, TimeUnit.SECONDS);
            }
            if (this.sensorPollingJob == null || this.sensorPollingJob.isCancelled()) {
                int sensorPollingInterval = 500;
                if (this.hueBridgeConfig.getSensorPollingInterval() < 50) {
                    this.logger.info("Wrong configuration value for sensor polling interval. Using default value: {}s", (Object)sensorPollingInterval);
                } else {
                    sensorPollingInterval = this.hueBridgeConfig.getSensorPollingInterval();
                }
                this.sensorPollingJob = this.scheduler.scheduleWithFixedDelay(this.sensorPollingRunnable, 1L, sensorPollingInterval, TimeUnit.MILLISECONDS);
            }
        }
    }

    public void onConnectionLost() {
        this.logger.debug("Bridge connection lost. Updating thing status to OFFLINE.");
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.NONE, "@text/offline.bridge-connection-lost");
    }

    private void onConnectionResumed() throws IOException, ApiException {
        FullConfig fullConfig;
        Config config;
        this.logger.debug("Bridge connection resumed. Updating thing status to ONLINE.");
        if (!this.propertiesInitializedSuccessfully && (config = (fullConfig = this.hueBridge.getFullConfig()).getConfig()) != null) {
            Map properties = this.editProperties();
            properties.put("serialNumber", config.getMACAddress().replaceAll(":", "").toLowerCase());
            properties.put("firmwareVersion", config.getSoftwareVersion());
            this.updateProperties(properties);
            this.propertiesInitializedSuccessfully = true;
        }
        this.updateStatus(ThingStatus.ONLINE);
    }

    private boolean tryResumeBridgeConnection() throws IOException, ApiException {
        this.logger.debug("Connection to Hue Bridge {} established.", (Object)this.hueBridge.getIPAddress());
        if (this.hueBridgeConfig.getUserName() == null) {
            this.logger.warn("User name for Hue bridge authentication not available in configuration. Setting ThingStatus to offline.");
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "@text/offline.conf-error-no-username");
            return false;
        }
        this.onConnectionResumed();
        return true;
    }

    public boolean onNotAuthenticated() {
        if (this.hueBridge == null) {
            return false;
        }
        String userName = this.hueBridgeConfig.getUserName();
        if (userName == null) {
            this.createUser();
        } else {
            try {
                this.hueBridge.authenticate(userName);
                return true;
            }
            catch (Exception e) {
                this.handleAuthenticationFailure(e, userName);
            }
        }
        return false;
    }

    private void createUser() {
        try {
            String newUser = this.createUserOnPhysicalBridge();
            this.updateBridgeThingConfiguration(newUser);
        }
        catch (LinkButtonException ex) {
            this.handleLinkButtonNotPressed(ex);
        }
        catch (Exception ex) {
            this.handleExceptionWhileCreatingUser(ex);
        }
    }

    private String createUserOnPhysicalBridge() throws IOException, ApiException {
        this.logger.info("Creating new user on Hue bridge {} - please press the pairing button on the bridge.", (Object)this.hueBridgeConfig.getIpAddress());
        String userName = this.hueBridge.link(DEVICE_TYPE);
        this.logger.info("User '{}' has been successfully added to Hue bridge.", (Object)userName);
        return userName;
    }

    private void updateBridgeThingConfiguration(String userName) {
        Configuration config = this.editConfiguration();
        config.put("userName", (Object)userName);
        try {
            this.updateConfiguration(config);
            this.logger.debug("Updated configuration parameter {} to '{}'", (Object)"userName", (Object)userName);
        }
        catch (IllegalStateException e) {
            this.logger.trace("Configuration update failed.", (Throwable)e);
            this.logger.warn("Unable to update configuration of Hue bridge.");
            this.logger.warn("Please configure the following user name manually: {}", (Object)userName);
        }
    }

    private void handleAuthenticationFailure(Exception ex, String userName) {
        this.logger.warn("User {} is not authenticated on Hue bridge {}", (Object)userName, (Object)this.hueBridgeConfig.getIpAddress());
        this.logger.warn("Please configure a valid user or remove user from configuration to generate a new one.");
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.CONFIGURATION_ERROR, "@text/offline.conf-error-invalid-username");
    }

    private void handleLinkButtonNotPressed(LinkButtonException ex) {
        this.logger.debug("Failed creating new user on Hue bridge: {}", (Object)ex.getMessage());
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.CONFIGURATION_ERROR, "@text/offline.conf-error-press-pairing-button");
    }

    private void handleExceptionWhileCreatingUser(Exception ex) {
        this.logger.warn("Failed creating new user on Hue bridge", (Throwable)ex);
        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.CONFIGURATION_ERROR, "@text/offline.conf-error-creation-username");
    }

    @Override
    public boolean registerLightStatusListener(LightStatusListener lightStatusListener) {
        boolean result = this.lightStatusListeners.add(lightStatusListener);
        if (result) {
            this.onUpdate();
            for (FullLight light : this.lastLightStates.values()) {
                lightStatusListener.onLightAdded(this.hueBridge, light);
            }
        }
        return result;
    }

    @Override
    public boolean unregisterLightStatusListener(LightStatusListener lightStatusListener) {
        boolean result = this.lightStatusListeners.remove(lightStatusListener);
        if (result) {
            this.onUpdate();
        }
        return result;
    }

    @Override
    public boolean registerSensorStatusListener(SensorStatusListener sensorStatusListener) {
        boolean result = this.sensorStatusListeners.add(sensorStatusListener);
        if (result) {
            this.onUpdate();
            for (FullSensor sensor : this.lastSensorStates.values()) {
                sensorStatusListener.onSensorAdded(this.hueBridge, sensor);
            }
        }
        return result;
    }

    @Override
    public boolean unregisterSensorStatusListener(SensorStatusListener sensorStatusListener) {
        boolean result = this.sensorStatusListeners.remove(sensorStatusListener);
        if (result) {
            this.onUpdate();
        }
        return result;
    }

    @Override
    public @Nullable FullLight getLightById(String lightId) {
        return this.lastLightStates.get(lightId);
    }

    @Override
    public @Nullable FullSensor getSensorById(String sensorId) {
        return this.lastSensorStates.get(sensorId);
    }

    public List<FullLight> getFullLights() {
        List<FullLight> ret = this.withReAuthentication("search for new lights", () -> this.hueBridge.getFullLights());
        return ret != null ? ret : Collections.emptyList();
    }

    public List<FullSensor> getFullSensors() {
        List<FullSensor> ret = this.withReAuthentication("search for new sensors", () -> this.hueBridge.getSensors());
        return ret != null ? ret : Collections.emptyList();
    }

    public void startSearch() {
        this.withReAuthentication("start search mode", () -> {
            this.hueBridge.startSearch();
            return null;
        });
    }

    public void startSearch(List<String> serialNumbers) {
        this.withReAuthentication("start search mode", () -> {
            this.hueBridge.startSearch(serialNumbers);
            return null;
        });
    }

    private <T> T withReAuthentication(String taskDescription, Callable<T> runnable) {
        if (this.hueBridge != null) {
            try {
                try {
                    return runnable.call();
                }
                catch (IllegalStateException | UnauthorizedException exception) {
                    this.lastBridgeConnectionState = false;
                    if (this.onNotAuthenticated()) {
                        return runnable.call();
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Bridge cannot {}.", (Object)taskDescription, (Object)e);
            }
        }
        return null;
    }

    private void notifyLightStatusListeners(FullLight fullLight, String type) {
        if (this.lightStatusListeners.isEmpty()) {
            this.logger.debug("No light status listeners to notify of light change for light '{}'", (Object)fullLight.getId());
            return;
        }
        block10: for (LightStatusListener lightStatusListener : this.lightStatusListeners) {
            try {
                switch (type) {
                    case "added": {
                        this.logger.debug("Sending lightAdded for light '{}'", (Object)fullLight.getId());
                        lightStatusListener.onLightAdded(this.hueBridge, fullLight);
                        continue block10;
                    }
                    case "changed": {
                        this.logger.debug("Sending lightStateChanged for light '{}'", (Object)fullLight.getId());
                        lightStatusListener.onLightStateChanged(this.hueBridge, fullLight);
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Could not notify lightStatusListeners for unknown event type " + type);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("An exception occurred while calling the BridgeHeartbeatListener", (Throwable)e);
            }
        }
    }

    private void notifySensorStatusListeners(FullSensor fullSensor, String type) {
        if (this.sensorStatusListeners.isEmpty()) {
            this.logger.debug("No sensor status listeners to notify of sensor change for sensor '{}'", (Object)fullSensor.getId());
            return;
        }
        block10: for (SensorStatusListener sensorStatusListener : this.sensorStatusListeners) {
            try {
                switch (type) {
                    case "added": {
                        this.logger.debug("Sending sensorAdded for sensor '{}'", (Object)fullSensor.getId());
                        sensorStatusListener.onSensorAdded(this.hueBridge, fullSensor);
                        continue block10;
                    }
                    case "changed": {
                        this.logger.debug("Sending sensorStateChanged for sensor '{}'", (Object)fullSensor.getId());
                        sensorStatusListener.onSensorStateChanged(this.hueBridge, fullSensor);
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Could not notify sensorStatusListeners for unknown event type " + type);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("An exception occurred while calling the Sensor Listeners", (Throwable)e);
            }
        }
    }

    private boolean isEqual(State state1, State state2) {
        return state1.getAlertMode().equals((Object)state2.getAlertMode()) && state1.isOn() == state2.isOn() && state1.getBrightness() == state2.getBrightness() && state1.getColorTemperature() == state2.getColorTemperature() && state1.getHue() == state2.getHue() && state1.getSaturation() == state2.getSaturation() && state1.isReachable() == state2.isReachable() && Objects.equals((Object)state1.getColorMode(), (Object)state2.getColorMode()) && Objects.equals((Object)state1.getEffect(), (Object)state2.getEffect());
    }

    public Collection<ConfigStatusMessage> getConfigStatus() {
        List<ConfigStatusMessage> configStatusMessages = this.hueBridgeConfig.getIpAddress() == null || this.hueBridgeConfig.getIpAddress().isEmpty() ? Collections.singletonList(ConfigStatusMessage.Builder.error((String)"ipAddress").withMessageKeySuffix("missing-ip-address-configuration").withArguments(new Object[]{"ipAddress"}).build()) : Collections.emptyList();
        return configStatusMessages;
    }

    abstract class PollingRunnable
    implements Runnable {
        PollingRunnable() {
        }

        @Override
        public void run() {
            try {
                try {
                    HueBridgeHandler.this.pollingLock.lock();
                    try {
                        if (!HueBridgeHandler.this.lastBridgeConnectionState) {
                            HueBridgeHandler.this.lastBridgeConnectionState = HueBridgeHandler.this.tryResumeBridgeConnection();
                        }
                        if (HueBridgeHandler.this.lastBridgeConnectionState) {
                            this.doConnectedRun();
                        }
                    }
                    catch (IllegalStateException | UnauthorizedException exception) {
                        if (this.isReachable(HueBridgeHandler.this.hueBridge.getIPAddress())) {
                            HueBridgeHandler.this.lastBridgeConnectionState = false;
                            HueBridgeHandler.this.onNotAuthenticated();
                        } else if (HueBridgeHandler.this.lastBridgeConnectionState || HueBridgeHandler.this.thing.getStatus() == ThingStatus.INITIALIZING) {
                            HueBridgeHandler.this.lastBridgeConnectionState = false;
                            HueBridgeHandler.this.onConnectionLost();
                        }
                    }
                    catch (Exception exception) {
                        if (HueBridgeHandler.this.hueBridge != null && HueBridgeHandler.this.lastBridgeConnectionState) {
                            HueBridgeHandler.this.logger.debug("Connection to Hue Bridge {} lost.", (Object)HueBridgeHandler.this.hueBridge.getIPAddress());
                            HueBridgeHandler.this.lastBridgeConnectionState = false;
                            HueBridgeHandler.this.onConnectionLost();
                        }
                    }
                }
                catch (Throwable t) {
                    HueBridgeHandler.this.logger.error("An unexpected error occurred: {}", (Object)t.getMessage(), (Object)t);
                    HueBridgeHandler.this.pollingLock.unlock();
                }
            }
            finally {
                HueBridgeHandler.this.pollingLock.unlock();
            }
        }

        protected abstract void doConnectedRun() throws IOException, ApiException;

        private boolean isReachable(String ipAddress) {
            try {
                HueBridgeHandler.this.hueBridge.authenticate("invalid");
            }
            catch (IOException iOException) {
                return false;
            }
            catch (ApiException e) {
                return !e.getMessage().contains("SocketTimeout") && !e.getMessage().contains("ConnectException") && !e.getMessage().contains("SocketException") && !e.getMessage().contains("NoRouteToHostException");
            }
            return true;
        }
    }
}

