/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.internal.handler.sensors;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.hue.internal.FullSensor;
import org.eclipse.smarthome.binding.hue.internal.HueBindingConstants;
import org.eclipse.smarthome.binding.hue.internal.HueBridge;
import org.eclipse.smarthome.binding.hue.internal.SensorConfigUpdate;
import org.eclipse.smarthome.binding.hue.internal.TemperatureConfigUpdate;
import org.eclipse.smarthome.binding.hue.internal.handler.HueSensorHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.library.unit.SIUnits;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.types.State;

@NonNullByDefault
public class TemperatureHandler
extends HueSensorHandler {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(HueBindingConstants.THING_TYPE_TEMPERATURE_SENSOR);

    public TemperatureHandler(Thing thing) {
        super(thing);
    }

    @Override
    protected SensorConfigUpdate doConfigurationUpdate(Map<String, Object> configurationParameters) {
        TemperatureConfigUpdate configUpdate = new TemperatureConfigUpdate();
        if (configurationParameters.containsKey("ledindication")) {
            configUpdate.setLedIndication(Boolean.TRUE.equals(configurationParameters.get("ledindication")));
        }
        return configUpdate;
    }

    @Override
    protected void doSensorStateChanged(@Nullable HueBridge bridge, FullSensor sensor, Configuration config) {
        Object temperature = sensor.getState().get("temperature");
        if (temperature != null) {
            BigDecimal value = new BigDecimal(String.valueOf(temperature));
            this.updateState("temperature", (State)new QuantityType((Number)value.divide(new BigDecimal(100)), SIUnits.CELSIUS));
        }
        if (sensor.getConfig().containsKey("ledindication")) {
            config.put("ledindication", sensor.getConfig().get("tholddark"));
        }
    }
}

