/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal;

import java.util.Locale;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.lifx.LifxBindingConstants;
import org.eclipse.smarthome.binding.lifx.internal.LifxChannelFactory;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.builder.ChannelBuilder;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component(service={LifxChannelFactory.class}, immediate=true)
public class LifxChannelFactoryImpl
implements LifxChannelFactory {
    private static final String COLOR_ZONE_LABEL_KEY = "channel-type.lifx.colorzone.label";
    private static final String COLOR_ZONE_DESCRIPTION_KEY = "channel-type.lifx.colorzone.description";
    private static final String TEMPERATURE_ZONE_LABEL_KEY = "channel-type.lifx.temperaturezone.label";
    private static final String TEMPERATURE_ZONE_DESCRIPTION_KEY = "channel-type.lifx.temperaturezone.description";
    @NonNullByDefault(value={})
    private Bundle bundle;
    @NonNullByDefault(value={})
    private TranslationProvider i18nProvider;
    @NonNullByDefault(value={})
    private LocaleProvider localeProvider;

    @Override
    public Channel createColorZoneChannel(ThingUID thingUID, int index) {
        String label = this.getText(COLOR_ZONE_LABEL_KEY, index);
        String description = this.getText(COLOR_ZONE_DESCRIPTION_KEY, index);
        return ChannelBuilder.create((ChannelUID)new ChannelUID(thingUID, "colorzone" + index), (String)"Color").withType(LifxBindingConstants.CHANNEL_TYPE_COLOR_ZONE).withLabel(label).withDescription(description).build();
    }

    @Override
    public Channel createTemperatureZoneChannel(ThingUID thingUID, int index) {
        String label = this.getText(TEMPERATURE_ZONE_LABEL_KEY, index);
        String description = this.getText(TEMPERATURE_ZONE_DESCRIPTION_KEY, index);
        return ChannelBuilder.create((ChannelUID)new ChannelUID(thingUID, "temperaturezone" + index), (String)"Dimmer").withType(LifxBindingConstants.CHANNEL_TYPE_TEMPERATURE_ZONE).withLabel(label).withDescription(description).build();
    }

    private @Nullable String getDefaultText(String key) {
        return this.i18nProvider.getText(this.bundle, key, key, Locale.ENGLISH);
    }

    private String getText(String key, Object ... arguments) {
        Locale locale;
        Locale locale2 = locale = this.localeProvider != null ? this.localeProvider.getLocale() : Locale.ENGLISH;
        if (this.i18nProvider == null) {
            return key;
        }
        String text = this.i18nProvider.getText(this.bundle, key, this.getDefaultText(key), locale, arguments);
        return text != null ? text : key;
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.bundle = componentContext.getBundleContext().getBundle();
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        this.bundle = null;
    }

    @Reference
    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    protected void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = null;
    }

    @Reference
    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }
}

