/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.meteoblue.handler;

import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.meteoblue.MeteoBlueBindingConstants;
import org.eclipse.smarthome.binding.meteoblue.internal.MeteoBlueBridgeConfig;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseBridgeHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.io.net.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeteoBlueBridgeHandler
extends BaseBridgeHandler {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(MeteoBlueBindingConstants.THING_TYPE_BRIDGE);
    private final Logger logger = LoggerFactory.getLogger(MeteoBlueBridgeHandler.class);
    private String apiKey;
    private boolean isValidConfig;

    public MeteoBlueBridgeHandler(Bridge bridge) {
        super(bridge);
    }

    public void initialize() {
        this.logger.debug("Initializing meteoblue bridge");
        MeteoBlueBridgeConfig config = (MeteoBlueBridgeConfig)this.getConfigAs(MeteoBlueBridgeConfig.class);
        String apiKeyTemp = config.getApiKey();
        if (StringUtils.isBlank((String)apiKeyTemp)) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "Cannot initialize meteoblue bridge. No apiKey provided.");
            return;
        }
        this.apiKey = apiKeyTemp;
        this.healthCheck();
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
    }

    public String getApiKey() {
        return new String(this.apiKey);
    }

    private void healthCheck() {
        String url = "http://my.meteoblue.com/packages/";
        try {
            HttpUtil.executeUrl((String)"GET", (String)url, (int)30000);
            this.logger.trace("HealthCheck succeeded.");
            this.updateStatus(ThingStatus.ONLINE);
        }
        catch (Exception e) {
            this.logger.trace("HealthCheck failed", (Throwable)e);
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "HealthCheck failed");
        }
    }
}

