/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant;

import com.google.gson.Gson;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.AbstractComponent;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.CChannel;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.HaID;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelStateUpdateListener;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.ColorValue;
import org.eclipse.smarthome.core.thing.ThingUID;

public class ComponentLight
extends AbstractComponent {
    public static final String switchChannelID = "light";
    public static final String brightnessChannelID = "brightness";
    public static final String colorChannelID = "color";
    protected Config config = new Config();

    public ComponentLight(ThingUID thing, HaID haID, String configJSON, @Nullable ChannelStateUpdateListener channelStateUpdateListener) {
        super(thing, haID, configJSON);
        this.config = (Config)new Gson().fromJson(configJSON, Config.class);
        this.channels.put(switchChannelID, new CChannel(this, switchChannelID, new ColorValue(true, this.config.payload_on, this.config.payload_off), this.config.state_topic, this.config.command_topic, this.config.name, "", channelStateUpdateListener));
    }

    @Override
    public String name() {
        return this.config.name;
    }

    static class Config {
        protected String name = "MQTT Light";
        protected String icon = "";
        protected int qos = 1;
        protected boolean retain = true;
        protected @Nullable String unique_id;
        protected int brightness_scale = 255;
        protected boolean optimistic = false;
        protected List<String> effect_list;
        protected String on_command_type = "last";
        protected @Nullable String state_topic;
        protected @Nullable String command_topic;
        protected @Nullable String state_value_template;
        protected @Nullable String brightness_state_topic;
        protected @Nullable String brightness_command_topic;
        protected @Nullable String brightness_value_template;
        protected @Nullable String color_temp_state_topic;
        protected @Nullable String color_temp_command_topic;
        protected @Nullable String color_temp_value_template;
        protected @Nullable String effect_command_topic;
        protected @Nullable String effect_state_topic;
        protected @Nullable String effect_value_template;
        protected @Nullable String rgb_command_topic;
        protected @Nullable String rgb_state_topic;
        protected @Nullable String rgb_value_template;
        protected @Nullable String rgb_command_template;
        protected @Nullable String white_value_command_topic;
        protected @Nullable String white_value_state_topic;
        protected @Nullable String white_value_template;
        protected @Nullable String xy_command_topic;
        protected @Nullable String xy_state_topic;
        protected @Nullable String xy_value_template;
        protected String payload_on = "ON";
        protected String payload_off = "OFF";
        protected @Nullable String availability_topic;
        protected String payload_available = "online";
        protected String payload_not_available = "offline";

        Config() {
        }
    }
}

