/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant;

import com.google.gson.Gson;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.AbstractComponent;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.CChannel;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.HaID;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelStateUpdateListener;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.OnOffValue;
import org.eclipse.smarthome.core.thing.ThingUID;

@NonNullByDefault
public class ComponentSwitch
extends AbstractComponent {
    public static final String switchChannelID = "switch";
    protected Config config = new Config();

    public ComponentSwitch(ThingUID thing, HaID haID, String configJSON, @Nullable ChannelStateUpdateListener channelStateUpdateListener) {
        super(thing, haID, configJSON);
        this.config = (Config)new Gson().fromJson(configJSON, Config.class);
        if (this.config.optimistic && StringUtils.isNotBlank((String)this.config.state_topic)) {
            throw new UnsupportedOperationException("Component:Switch does not support forced optimistic mode");
        }
        this.channels.put(switchChannelID, new CChannel(this, switchChannelID, new OnOffValue(this.config.state_on, this.config.state_off), this.config.state_topic, this.config.command_topic, this.config.name, "", channelStateUpdateListener));
    }

    @Override
    public String name() {
        return this.config.name;
    }

    static class Config {
        protected String name = "MQTT Switch";
        protected String icon = "";
        protected int qos = 1;
        protected boolean retain = true;
        protected @Nullable String value_template;
        protected @Nullable String unique_id;
        protected boolean optimistic = false;
        protected String state_topic = "";
        protected String state_on = "true";
        protected String state_off = "false";
        protected @Nullable String command_topic;
        protected String payload_on = "true";
        protected String payload_off = "false";
        protected @Nullable String availability_topic;
        protected String payload_available = "online";
        protected String payload_not_available = "offline";

        Config() {
        }
    }
}

