/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;

@NonNullByDefault
public class HaID {
    public final String baseTopic;
    public final String component;
    public final String nodeID;
    public final String objectID;

    public HaID(String mqttTopic) {
        String[] strings = mqttTopic.split("/");
        if (strings.length < 3) {
            throw new IllegalArgumentException("MQTT topic not a HomeAssistant topic!");
        }
        if (strings.length >= 4) {
            this.component = strings[1];
            this.nodeID = strings[2];
            this.objectID = strings[3];
        } else {
            this.component = strings[1];
            this.nodeID = "";
            this.objectID = strings[2];
        }
        this.baseTopic = strings[0];
    }

    public HaID(String baseTopic, String objectID, String nodeID, String component) {
        this.baseTopic = baseTopic;
        this.objectID = objectID;
        this.nodeID = nodeID;
        this.component = component;
    }

    public HaID(String baseTopic, ChannelUID channel) {
        String groupId = channel.getGroupId();
        if (groupId == null) {
            throw new IllegalArgumentException("Channel needs a group ID!");
        }
        String[] groupParts = groupId.split("_");
        if (groupParts.length != 2) {
            throw new IllegalArgumentException("Channel needs a group ID with the pattern component_node!");
        }
        this.objectID = channel.getThingUID().getId();
        this.nodeID = groupParts[1];
        this.component = groupParts[0];
        this.baseTopic = baseTopic;
    }

    public String getThingID() {
        return this.objectID;
    }

    public String getChannelGroupTypeID() {
        return String.valueOf(this.objectID) + "_" + this.component + this.nodeID;
    }

    public ChannelTypeUID getChannelTypeID(String channelID) {
        return new ChannelTypeUID("mqtt", String.valueOf(this.objectID) + "_" + this.component + this.nodeID + "_" + channelID);
    }

    public String getChannelGroupID() {
        return String.valueOf(this.component) + "_" + this.nodeID;
    }

    public String toString() {
        return String.valueOf(this.baseTopic) + "/" + this.component + "/" + this.nodeID + "/" + this.objectID;
    }
}

