/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.discovery;

import java.util.Date;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.discovery.MQTTTopicDiscoveryParticipant;
import org.eclipse.smarthome.binding.mqtt.discovery.MQTTTopicDiscoveryService;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.core.thing.ThingTypeUID;

@NonNullByDefault
public abstract class AbstractMQTTDiscovery
extends AbstractDiscoveryService
implements MQTTTopicDiscoveryParticipant {
    protected final String subscribeTopic;

    public AbstractMQTTDiscovery(@Nullable Set<ThingTypeUID> supportedThingTypes, int timeout, boolean backgroundDiscoveryEnabledByDefault, String baseTopic) {
        super(supportedThingTypes, timeout, backgroundDiscoveryEnabledByDefault);
        this.subscribeTopic = baseTopic;
    }

    protected abstract MQTTTopicDiscoveryService getDiscoveryService();

    protected void startScan() {
        if (this.isBackgroundDiscoveryEnabled()) {
            super.stopScan();
            return;
        }
        this.getDiscoveryService().subscribe((MQTTTopicDiscoveryParticipant)this, this.subscribeTopic);
    }

    protected synchronized void stopScan() {
        if (this.isBackgroundDiscoveryEnabled()) {
            super.stopScan();
            return;
        }
        this.getDiscoveryService().unsubscribe((MQTTTopicDiscoveryParticipant)this);
        super.stopScan();
    }

    protected void startBackgroundDiscovery() {
        this.removeOlderResults(new Date().getTime());
        this.getDiscoveryService().subscribe((MQTTTopicDiscoveryParticipant)this, this.subscribeTopic);
    }

    protected void stopBackgroundDiscovery() {
        this.getDiscoveryService().unsubscribe((MQTTTopicDiscoveryParticipant)this);
    }
}

