/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.generic;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.type.DynamicStateDescriptionProvider;
import org.eclipse.smarthome.core.types.StateDescription;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DynamicStateDescriptionProvider.class, MqttChannelStateDescriptionProvider.class})
@NonNullByDefault
public class MqttChannelStateDescriptionProvider
implements DynamicStateDescriptionProvider {
    private final Map<ChannelUID, StateDescription> descriptions = new ConcurrentHashMap<ChannelUID, StateDescription>();
    private final Logger logger = LoggerFactory.getLogger(MqttChannelStateDescriptionProvider.class);

    public void setDescription(ChannelUID channelUID, StateDescription description) {
        this.logger.debug("Adding state description for channel {}", (Object)channelUID);
        this.descriptions.put(channelUID, description);
    }

    public void removeAllDescriptions() {
        this.logger.debug("Removing all state descriptions");
        this.descriptions.clear();
    }

    public @Nullable StateDescription getStateDescription(Channel channel, @Nullable StateDescription originalStateDescription, @Nullable Locale locale) {
        StateDescription description = this.descriptions.get(channel.getUID());
        this.logger.trace("Providing state description for channel {}", (Object)channel.getUID());
        return description;
    }

    public void remove(ChannelUID channel) {
        this.descriptions.remove(channel);
    }
}

