/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelConfig;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelState;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelStateTransformation;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelStateUpdateListener;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.MqttChannelStateDescriptionProvider;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.TransformationServiceProvider;
import org.eclipse.smarthome.binding.mqtt.generic.internal.handler.AbstractMQTTThingHandler;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.ValueFactory;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class GenericThingHandler
extends AbstractMQTTThingHandler
implements ChannelStateUpdateListener {
    private final Logger logger = LoggerFactory.getLogger(GenericThingHandler.class);
    final Map<ChannelUID, ChannelState> channelStateByChannelUID = new HashMap<ChannelUID, ChannelState>();
    protected final MqttChannelStateDescriptionProvider stateDescProvider;
    protected final TransformationServiceProvider transformationServiceProvider;

    public GenericThingHandler(Thing thing, MqttChannelStateDescriptionProvider stateDescProvider, TransformationServiceProvider transformationServiceProvider, int subscribeTimeout) {
        super(thing, subscribeTimeout);
        this.stateDescProvider = stateDescProvider;
        this.transformationServiceProvider = transformationServiceProvider;
    }

    @Override
    public @Nullable ChannelState getChannelState(ChannelUID channelUID) {
        return this.channelStateByChannelUID.get(channelUID);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected CompletableFuture<@Nullable Void> start(MqttBrokerConnection connection) {
        List<@Nullable CompletableFuture> futures = this.channelStateByChannelUID.values().stream().map(c -> c.start(connection, this.scheduler, 0)).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenRun(() -> this.updateStatus(ThingStatus.ONLINE, ThingStatusDetail.NONE));
    }

    @Override
    protected void stop() {
        this.channelStateByChannelUID.values().forEach(c -> c.getValue().resetState());
    }

    @Override
    public void dispose() {
        try {
            this.channelStateByChannelUID.values().stream().map(e -> e.stop()).reduce(CompletableFuture.completedFuture(null), (a, v) -> a.thenCompose(b -> v)).get(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {}
        this.channelStateByChannelUID.forEach((uid, state) -> this.stateDescProvider.remove((ChannelUID)uid));
        this.connection = null;
        this.channelStateByChannelUID.clear();
        super.dispose();
    }

    protected ChannelState createChannelState(ChannelConfig channelConfig, ChannelUID channelUID, Value valueState) {
        ChannelState state = new ChannelState(channelConfig, channelUID, valueState, this);
        String[] transformations = channelConfig.transformationPattern.split("\n");
        Stream.of(transformations).filter(t -> StringUtils.isNotBlank((String)t)).map(t -> new ChannelStateTransformation((String)t, this.transformationServiceProvider)).forEach(t -> state.addTransformation((ChannelStateTransformation)t));
        return state;
    }

    @Override
    public void initialize() {
        ArrayList<ChannelUID> configErrors = new ArrayList<ChannelUID>();
        for (Channel channel : this.thing.getChannels()) {
            ChannelTypeUID channelTypeUID = channel.getChannelTypeUID();
            if (channelTypeUID == null) {
                this.logger.warn("Channel {} has no type", (Object)channel.getLabel());
                continue;
            }
            ChannelConfig channelConfig = (ChannelConfig)channel.getConfiguration().as(ChannelConfig.class);
            try {
                Value value = ValueFactory.createValueState(channelConfig, channelTypeUID.getId());
                ChannelState channelState = this.createChannelState(channelConfig, channel.getUID(), value);
                this.channelStateByChannelUID.put(channel.getUID(), channelState);
                StateDescription description = value.createStateDescription(channelConfig.unit, StringUtils.isBlank((String)channelConfig.commandTopic));
                this.stateDescProvider.setDescription(channel.getUID(), description);
            }
            catch (IllegalArgumentException e2) {
                this.logger.warn("Channel configuration error", (Throwable)e2);
                configErrors.add(channel.getUID());
            }
        }
        if (configErrors.isEmpty()) {
            super.initialize();
        } else {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "Remove and recreate: " + configErrors.stream().map(e -> e.getAsString()).collect(Collectors.joining(",")));
        }
    }
}

