/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.values;

import java.math.BigDecimal;
import java.util.Collections;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.UnDefType;

@NonNullByDefault
public class NumberValue
implements Value {
    private State state = UnDefType.UNDEF;
    private final double min;
    private final double max;
    private final double step;
    private final Boolean isDecimal;
    private final boolean isPercent;
    private DecimalType numberValue;

    public NumberValue(@Nullable Boolean isDecimal, @Nullable BigDecimal min, @Nullable BigDecimal max, @Nullable BigDecimal step, boolean isPercent) {
        this.isDecimal = isDecimal == null ? false : isDecimal;
        this.min = min == null ? 0.0 : min.doubleValue();
        double d = this.max = max == null ? 100.0 : max.doubleValue();
        if (isPercent && this.min >= this.max) {
            throw new IllegalArgumentException("Min need to be smaller than max!");
        }
        this.step = step == null ? 1.0 : step.doubleValue();
        this.isPercent = isPercent;
        this.numberValue = new DecimalType();
    }

    @Override
    public State getValue() {
        return this.state;
    }

    @Override
    public String update(Command command) throws IllegalArgumentException {
        if (this.isPercent) {
            if (command instanceof StringType) {
                double v = Double.valueOf(((StringType)command).toString());
                v = (v - this.min) * 100.0 / (this.max - this.min);
                this.numberValue = new PercentType(new BigDecimal(v));
            } else if (command instanceof PercentType) {
                this.numberValue = (PercentType)command;
            } else if (command instanceof DecimalType) {
                double v = ((DecimalType)command).doubleValue();
                v = (v - this.min) * 100.0 / (this.max - this.min);
                this.numberValue = new PercentType(new BigDecimal(v));
            } else if (command instanceof IncreaseDecreaseType) {
                double v;
                this.numberValue = (IncreaseDecreaseType)command == IncreaseDecreaseType.INCREASE ? new PercentType(new BigDecimal((v = this.numberValue.doubleValue() + this.step) <= this.max ? v : this.max)) : new PercentType(new BigDecimal((v = this.numberValue.doubleValue() - this.step) >= this.min ? v : this.min));
            } else if (command instanceof UpDownType) {
                double v;
                this.numberValue = (UpDownType)command == UpDownType.UP ? new PercentType(new BigDecimal((v = this.numberValue.doubleValue() + this.step) <= this.max ? v : this.max)) : new PercentType(new BigDecimal((v = this.numberValue.doubleValue() - this.step) >= this.min ? v : this.min));
            } else {
                throw new IllegalArgumentException("Type " + command.getClass().getName() + " not supported for PercentValue");
            }
            if (this.isDecimal.booleanValue()) {
                this.state = this.numberValue;
                return this.numberValue.toString();
            }
            this.state = this.numberValue;
            return String.valueOf(this.numberValue.intValue());
        }
        if (command instanceof StringType) {
            this.numberValue = DecimalType.valueOf((String)((StringType)command).toString());
        } else if (command instanceof DecimalType) {
            this.numberValue = (DecimalType)command;
        } else if (command instanceof PercentType) {
            this.numberValue = (PercentType)command;
        } else if (command instanceof IncreaseDecreaseType) {
            double v = (IncreaseDecreaseType)command == IncreaseDecreaseType.INCREASE ? this.numberValue.doubleValue() + this.step : this.numberValue.doubleValue() - this.step;
            this.numberValue = new DecimalType(v);
        } else if (command instanceof UpDownType) {
            double v = (UpDownType)command == UpDownType.UP ? this.numberValue.doubleValue() + this.step : this.numberValue.doubleValue() - this.step;
            this.numberValue = new DecimalType(v);
        } else {
            throw new IllegalArgumentException("Type " + command.getClass().getName() + " not supported for NumberValue");
        }
        if (this.isDecimal.booleanValue()) {
            this.state = this.numberValue;
            return this.numberValue.toString();
        }
        this.state = this.numberValue;
        return String.valueOf(this.numberValue.intValue());
    }

    @Override
    public State update(String updatedValue) throws IllegalArgumentException {
        this.numberValue = DecimalType.valueOf((String)updatedValue);
        this.state = this.numberValue;
        return this.numberValue;
    }

    @Override
    public String getItemType() {
        return this.isPercent ? "Dimmer" : "Number";
    }

    @Override
    public StateDescription createStateDescription(String unit, boolean readOnly) {
        return new StateDescription(new BigDecimal(this.min), new BigDecimal(this.max), new BigDecimal(this.step), "%s " + unit.replace("%", "%%"), readOnly, Collections.emptyList());
    }

    @Override
    public void resetState() {
        this.state = UnDefType.UNDEF;
    }
}

