/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.values;

import java.util.Collections;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.UnDefType;

@NonNullByDefault
public class OpenCloseValue
implements Value {
    private State state = UnDefType.UNDEF;
    private OpenClosedType boolValue;
    private final String openString;
    private final String closeString;

    public OpenCloseValue() {
        this.openString = OpenClosedType.OPEN.name();
        this.closeString = OpenClosedType.CLOSED.name();
        this.boolValue = OpenClosedType.CLOSED;
    }

    public OpenCloseValue(@Nullable String openValue, @Nullable String closeValue) {
        this.openString = openValue == null ? OpenClosedType.OPEN.name() : openValue;
        this.closeString = closeValue == null ? OpenClosedType.CLOSED.name() : closeValue;
        this.boolValue = OpenClosedType.CLOSED;
    }

    @Override
    public State getValue() {
        return this.state;
    }

    @Override
    public String update(Command command) throws IllegalArgumentException {
        if (command instanceof OpenClosedType) {
            this.boolValue = (OpenClosedType)command;
        } else if (command instanceof StringType) {
            this.boolValue = (OpenClosedType)this.update(command.toString());
        } else {
            throw new IllegalArgumentException("Type " + command.getClass().getName() + " not supported for OpenCloseValue");
        }
        this.state = this.boolValue;
        return this.boolValue == OpenClosedType.OPEN ? this.openString : this.closeString;
    }

    @Override
    public State update(String updatedValue) throws IllegalArgumentException {
        String upperCase = updatedValue.toUpperCase();
        if (this.openString.equals(updatedValue) || OpenClosedType.OPEN.name().equals(upperCase)) {
            this.boolValue = OpenClosedType.OPEN;
        } else if (this.closeString.equals(updatedValue) || OpenClosedType.CLOSED.name().equals(upperCase)) {
            this.boolValue = OpenClosedType.CLOSED;
        } else {
            throw new IllegalArgumentException("Didn't recognise the open/closed value " + updatedValue);
        }
        this.state = this.boolValue;
        return this.boolValue;
    }

    @Override
    public String getItemType() {
        return "Contact";
    }

    @Override
    public StateDescription createStateDescription(String unit, boolean readOnly) {
        return new StateDescription(null, null, null, "%s " + unit.replace("%", "%%"), readOnly, Collections.emptyList());
    }

    @Override
    public void resetState() {
        this.state = UnDefType.UNDEF;
    }
}

