/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.values;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateOption;
import org.eclipse.smarthome.core.types.UnDefType;

@NonNullByDefault
public class TextValue
implements Value {
    private State state = UnDefType.UNDEF;
    private StringType strValue = new StringType();
    private final @Nullable Set<String> states;

    public TextValue(String[] states) {
        Set s = Stream.of(states).filter(e -> StringUtils.isNotBlank((String)e)).collect(Collectors.toSet());
        this.states = s.size() > 0 ? s : null;
    }

    public TextValue() {
        this.states = null;
    }

    @Override
    public State getValue() {
        return this.state;
    }

    @Override
    public String update(Command command) throws IllegalArgumentException {
        Set<String> states = this.states;
        String value = command.toString();
        if (states != null && !states.contains(value)) {
            throw new IllegalArgumentException("Value " + value + " not within range");
        }
        this.strValue = new StringType(value);
        this.state = this.strValue;
        return value;
    }

    @Override
    public State update(String value) throws IllegalArgumentException {
        Set<String> states = this.states;
        if (states != null && !states.contains(value)) {
            throw new IllegalArgumentException("Value " + value + " not within range");
        }
        this.strValue = new StringType(value);
        this.state = this.strValue;
        return this.strValue;
    }

    @Override
    public String getItemType() {
        return "String";
    }

    public @Nullable Set<String> getStates() {
        return this.states;
    }

    @Override
    public StateDescription createStateDescription(String unit, boolean readOnly) {
        ArrayList<StateOption> stateOptions = new ArrayList<StateOption>();
        Set<String> states = this.states;
        if (states != null) {
            for (String state : states) {
                stateOptions.add(new StateOption(state, state));
            }
        }
        return new StateDescription(null, null, null, "%s " + unit.replace("%", "%%"), readOnly, stateOptions);
    }

    @Override
    public void resetState() {
        this.state = UnDefType.UNDEF;
    }
}

