/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.values;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelConfig;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.ColorValue;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.NumberValue;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.OnOffValue;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.OpenCloseValue;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.TextValue;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;

@NonNullByDefault
public class ValueFactory {
    public static Value createValueState(ChannelConfig config, String channelTypeID) throws IllegalArgumentException {
        Value value;
        switch (channelTypeID) {
            case "string": {
                value = StringUtils.isBlank((String)config.allowedStates) ? new TextValue() : new TextValue(config.allowedStates.split(","));
                break;
            }
            case "number": {
                value = new NumberValue(config.isDecimal, config.min, config.max, config.step, false);
                break;
            }
            case "dimmer": {
                value = new NumberValue(config.isDecimal, config.min, config.max, config.step, true);
                break;
            }
            case "colorRGB": {
                value = new ColorValue(true, config.on, config.off);
                break;
            }
            case "colorHSB": {
                value = new ColorValue(false, config.on, config.off);
                break;
            }
            case "switch": {
                value = new OnOffValue(config.on, config.off);
                break;
            }
            case "contact": {
                value = new OpenCloseValue(config.on, config.off);
                break;
            }
            default: {
                throw new IllegalArgumentException("ChannelTypeUID not recognised: " + channelTypeID);
            }
        }
        return value;
    }
}

