/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.handler;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.handler.PublishTriggerChannel;
import org.eclipse.smarthome.binding.mqtt.handler.PublishTriggerChannelConfig;
import org.eclipse.smarthome.binding.mqtt.internal.ActionService;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.BaseBridgeHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerService;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.eclipse.smarthome.io.transport.mqtt.MqttConnectionObserver;
import org.eclipse.smarthome.io.transport.mqtt.MqttConnectionState;

@NonNullByDefault
public abstract class AbstractBrokerHandler
extends BaseBridgeHandler
implements MqttConnectionObserver {
    public static int TIMEOUT_DEFAULT = 1200;
    final Map<ChannelUID, PublishTriggerChannel> channelStateByChannelUID = new HashMap<ChannelUID, PublishTriggerChannel>();
    @NonNullByDefault(value={})
    protected MqttBrokerConnection connection;
    protected final CompletableFuture<MqttBrokerConnection> connectionFuture = new CompletableFuture();

    public AbstractBrokerHandler(Bridge thing) {
        super(thing);
    }

    public Collection<Class<? extends ThingHandlerService>> getServices() {
        return Collections.singleton(ActionService.class);
    }

    public CompletableFuture<MqttBrokerConnection> getConnectionAsync() {
        return this.connectionFuture;
    }

    public @Nullable MqttBrokerConnection getConnection() {
        return this.connection;
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
    }

    public void initialize() {
        for (Channel channel : this.thing.getChannels()) {
            PublishTriggerChannelConfig channelConfig = (PublishTriggerChannelConfig)channel.getConfiguration().as(PublishTriggerChannelConfig.class);
            PublishTriggerChannel c = new PublishTriggerChannel(channelConfig, channel.getUID(), this.connection, this);
            this.channelStateByChannelUID.put(channel.getUID(), c);
        }
        this.connection.addConnectionObserver((MqttConnectionObserver)this);
        ((CompletableFuture)this.connection.start().exceptionally(e -> {
            this.connectionStateChanged(MqttConnectionState.DISCONNECTED, (Throwable)e);
            return false;
        })).thenAccept(v -> {
            if (!v.booleanValue()) {
                this.connectionStateChanged(MqttConnectionState.DISCONNECTED, new TimeoutException("Timeout"));
            } else {
                this.connectionStateChanged(MqttConnectionState.CONNECTED, null);
            }
        });
        this.connectionFuture.complete(this.connection);
    }

    public void connectionStateChanged(MqttConnectionState state, @Nullable Throwable error) {
        if (state == MqttConnectionState.CONNECTED) {
            this.updateStatus(ThingStatus.ONLINE);
            this.channelStateByChannelUID.values().forEach(c -> {
                CompletableFuture<Boolean> completableFuture = c.start();
            });
        } else {
            this.channelStateByChannelUID.values().forEach(c -> {
                CompletableFuture<Boolean> completableFuture = c.stop();
            });
            if (error == null) {
                this.updateStatus(ThingStatus.OFFLINE);
            } else {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, error.getMessage());
            }
        }
    }

    protected void triggerChannel(ChannelUID channelUID, String event) {
        super.triggerChannel(channelUID, event);
    }

    public void dispose() {
        this.channelStateByChannelUID.values().forEach(c -> {
            CompletableFuture<Boolean> completableFuture = c.stop();
        });
        this.channelStateByChannelUID.clear();
        this.connection.removeConnectionObserver((MqttConnectionObserver)this);
        this.connection = null;
        super.dispose();
    }
}

