/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.internal;

import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.automation.annotation.ActionInput;
import org.eclipse.smarthome.automation.annotation.ActionScope;
import org.eclipse.smarthome.automation.annotation.RuleAction;
import org.eclipse.smarthome.binding.mqtt.handler.AbstractBrokerHandler;
import org.eclipse.smarthome.core.thing.binding.AnnotatedActionThingHandlerService;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionScope(name="binding.mqtt")
@Component(immediate=false, service={AnnotatedActionThingHandlerService.class})
@NonNullByDefault
public class ActionService
implements AnnotatedActionThingHandlerService {
    private final Logger logger = LoggerFactory.getLogger(ActionService.class);
    private @Nullable AbstractBrokerHandler handler;

    public void setThingHandler(@Nullable ThingHandler handler) {
        this.handler = (AbstractBrokerHandler)handler;
    }

    public @Nullable ThingHandler getThingHandler() {
        return this.handler;
    }

    @RuleAction(label="@text/actionLabel", description="@text/actionDesc")
    void publishMQTT(@ActionInput(name="topic", label="@text/actionInputTopicLabel", description="@text/actionInputTopicDesc") String topic, @ActionInput(name="value", label="@text/actionInputValueLabel", description="@text/actionInputValueDesc") String value) {
        AbstractBrokerHandler brokerHandler = this.handler;
        if (brokerHandler == null) {
            this.logger.warn("MQTT Action service ThingHandler is null!");
            return;
        }
        MqttBrokerConnection connection = brokerHandler.getConnection();
        if (connection == null) {
            this.logger.warn("MQTT Action service ThingHandler connection is null!");
            return;
        }
        ((CompletableFuture)connection.publish(topic, value.getBytes()).thenRun(() -> this.logger.debug("MQTT publish to {} performed", (Object)topic))).exceptionally(e -> {
            this.logger.warn("MQTT publish to {} failed!", (Object)topic);
            return null;
        });
    }
}

