/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwPageBuffer;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class DS2438Configuration {
    private final Logger logger = LoggerFactory.getLogger(DS2438Configuration.class);
    private static final Pattern ASSOC_SENSOR_ID_PATTERN = Pattern.compile("^(26|28|3A)([0-9A-Fa-f]{12})[0-9A-Fa-f]{2}$");
    private OwSensorType sensorSubType = OwSensorType.DS2438;
    private String vendor = "";
    private String hwRevision = "";
    private String prodDate = "";
    private final List<String> associatedSensorIds = new ArrayList<String>();
    private final List<OwSensorType> associatedSensorTypes = new ArrayList<OwSensorType>();

    public DS2438Configuration(OwPageBuffer pageBuffer) {
        String sensorTypeId;
        switch (sensorTypeId = pageBuffer.getPageString(3).substring(0, 2)) {
            case "19": {
                this.vendor = "iButtonLink";
                this.sensorSubType = OwSensorType.MS_TH;
                break;
            }
            case "F1": 
            case "F3": {
                this.vendor = "Elaborated Networks";
                this.sensorSubType = OwSensorType.MS_TH;
                break;
            }
            case "F2": {
                this.vendor = "Elaborated Networks";
                this.sensorSubType = OwSensorType.MS_TH_S;
                break;
            }
            case "F4": {
                this.vendor = "Elaborated Networks";
                this.sensorSubType = OwSensorType.MS_TV;
            }
        }
        int i = 4;
        while (i < 7) {
            block34: {
                Matcher matcher = ASSOC_SENSOR_ID_PATTERN.matcher(pageBuffer.getPageString(i));
                if (!matcher.matches()) break block34;
                this.associatedSensorIds.add(String.valueOf(matcher.group(1)) + "." + matcher.group(2));
                switch (matcher.group(1)) {
                    case "26": {
                        this.associatedSensorTypes.add(OwSensorType.DS2438);
                        break;
                    }
                    case "28": {
                        this.associatedSensorTypes.add(OwSensorType.DS18B20);
                        break;
                    }
                    case "3A": {
                        this.associatedSensorTypes.add(OwSensorType.DS2413);
                    }
                }
            }
            ++i;
        }
        if (this.sensorSubType != OwSensorType.DS2438) {
            this.prodDate = String.format("%d/%d", pageBuffer.getByte(5, 0), 256 * pageBuffer.getByte(5, 1) + pageBuffer.getByte(5, 2));
            this.hwRevision = String.valueOf(pageBuffer.getByte(5, 3));
        }
    }

    public List<String> getAssociatedSensorIds() {
        return this.associatedSensorIds;
    }

    public List<OwSensorType> getAssociatedSensorTypes() {
        return this.associatedSensorTypes;
    }

    public int getAssociatedSensorCount() {
        return this.associatedSensorIds.size();
    }

    public String getHardwareRevision() {
        return this.hwRevision;
    }

    public String getProductionDate() {
        return this.prodDate;
    }

    public OwSensorType getSensorSubType() {
        return this.sensorSubType;
    }

    public String getVendor() {
        return this.vendor;
    }

    public static OwSensorType getMultisensorType(OwSensorType mainsensorType, List<OwSensorType> associatedSensorTypes) {
        OwSensorType multisensorType = OwSensorType.UNKNOWN;
        switch (associatedSensorTypes.size()) {
            case 0: {
                multisensorType = mainsensorType;
                break;
            }
            case 1: {
                if (mainsensorType == OwSensorType.MS_TH_S && associatedSensorTypes.contains((Object)OwSensorType.DS18B20)) {
                    multisensorType = OwSensorType.BMS_S;
                    break;
                }
                if (mainsensorType != OwSensorType.MS_TH || !associatedSensorTypes.contains((Object)OwSensorType.DS18B20)) break;
                multisensorType = OwSensorType.BMS;
                break;
            }
            case 3: {
                if (mainsensorType == OwSensorType.MS_TH_S && associatedSensorTypes.contains((Object)OwSensorType.MS_TV) && associatedSensorTypes.contains((Object)OwSensorType.DS18B20) && associatedSensorTypes.contains((Object)OwSensorType.DS2413)) {
                    multisensorType = OwSensorType.AMS_S;
                    break;
                }
                if (mainsensorType != OwSensorType.MS_TH || !associatedSensorTypes.contains((Object)OwSensorType.MS_TV) || !associatedSensorTypes.contains((Object)OwSensorType.DS18B20) || !associatedSensorTypes.contains((Object)OwSensorType.DS2413)) break;
                multisensorType = OwSensorType.AMS;
            }
        }
        return multisensorType;
    }
}

