/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal;

import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.DigitalIoLogic;
import org.eclipse.smarthome.binding.onewire.internal.DigitalIoMode;
import org.eclipse.smarthome.binding.onewire.internal.device.OwDeviceParameterMap;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.types.State;

@NonNullByDefault
public class DigitalIoConfig {
    private final String channelID;
    private final ChannelUID channelUID;
    private final OwDeviceParameterMap inParam;
    private final OwDeviceParameterMap outParam;
    private DigitalIoMode ioMode = DigitalIoMode.INPUT;
    private DigitalIoLogic ioLogic = DigitalIoLogic.NORMAL;

    public DigitalIoConfig(Thing thing, Integer channelIndex, OwDeviceParameterMap inParam, OwDeviceParameterMap outParam) {
        this.channelUID = new ChannelUID(thing.getUID(), String.format("%s%d", "digital", channelIndex));
        this.channelID = String.format("%s%d", "digital", channelIndex);
        this.inParam = inParam;
        this.outParam = outParam;
    }

    public void setIoMode(String ioMode) {
        this.ioMode = DigitalIoMode.valueOf(ioMode.toUpperCase());
    }

    public void setIoLogic(String ioLogic) {
        this.ioLogic = DigitalIoLogic.valueOf(ioLogic.toUpperCase());
    }

    public Boolean isInverted() {
        if (this.ioLogic == DigitalIoLogic.INVERTED) {
            return true;
        }
        return false;
    }

    public ChannelUID getChannelUID() {
        return this.channelUID;
    }

    public String getChannelId() {
        return this.channelID;
    }

    public OwDeviceParameterMap getParameter() {
        return this.ioMode == DigitalIoMode.INPUT ? this.inParam : this.outParam;
    }

    public Boolean isInput() {
        if (this.ioMode == DigitalIoMode.INPUT) {
            return true;
        }
        return false;
    }

    public Boolean isOutput() {
        if (this.ioMode == DigitalIoMode.OUTPUT) {
            return true;
        }
        return false;
    }

    public DigitalIoMode getIoDirection() {
        return this.ioMode;
    }

    public State convertState(Boolean rawValue) {
        if (this.ioLogic == DigitalIoLogic.NORMAL) {
            return rawValue != false ? OnOffType.ON : OnOffType.OFF;
        }
        return rawValue != false ? OnOffType.OFF : OnOffType.ON;
    }

    public String toString() {
        return String.format("path=%s, mode=%s, logic=%s", new Object[]{Arrays.asList(this.getParameter()), this.ioMode, this.ioLogic});
    }
}

