/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.type.DynamicStateDescriptionProvider;
import org.eclipse.smarthome.core.types.StateDescription;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={DynamicStateDescriptionProvider.class, OwDynamicStateDescriptionProvider.class}, immediate=true)
public class OwDynamicStateDescriptionProvider
implements DynamicStateDescriptionProvider {
    private final Map<ChannelUID, StateDescription> descriptions = new ConcurrentHashMap<ChannelUID, StateDescription>();
    private final Logger logger = LoggerFactory.getLogger(OwDynamicStateDescriptionProvider.class);

    public void setDescription(ChannelUID channelUID, StateDescription description) {
        this.logger.trace("adding state description for channel {}", (Object)channelUID);
        this.descriptions.put(channelUID, description);
    }

    public void removeDescriptionsForThing(ThingUID thingUID) {
        this.logger.trace("removing state description for thing {}", (Object)thingUID);
        this.descriptions.entrySet().removeIf(entry -> ((ChannelUID)entry.getKey()).getThingUID().equals((Object)thingUID));
    }

    public @Nullable StateDescription getStateDescription(Channel channel, @Nullable StateDescription originalStateDescription, @Nullable Locale locale) {
        if (this.descriptions.containsKey(channel.getUID())) {
            this.logger.trace("returning new stateDescription for {}", (Object)channel.getUID());
            return this.descriptions.get(channel.getUID());
        }
        return originalStateDescription;
    }
}

