/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.device;

import javax.measure.Unit;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Temperature;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.Util;
import org.eclipse.smarthome.binding.onewire.internal.device.AbstractOwDevice;
import org.eclipse.smarthome.binding.onewire.internal.device.OwDeviceParameterMap;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverDeviceParameter;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.library.unit.MetricPrefix;
import org.eclipse.smarthome.core.library.unit.SIUnits;
import org.eclipse.smarthome.core.library.unit.SmartHomeUnits;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class DS2438
extends AbstractOwDevice {
    private final Logger logger = LoggerFactory.getLogger(DS2438.class);
    private LightSensorType lightSensorType = LightSensorType.ElabNetV1;
    private static final OwDeviceParameterMap TEMPERATURE_PARAMETER = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/temperature"));
        }
    };
    private static final OwDeviceParameterMap HUMIDITY_PARAMETER = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/humidity"));
        }
    };
    private static final OwDeviceParameterMap VOLTAGE_PARAMETER = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/VAD"));
        }
    };
    private static final OwDeviceParameterMap CURRENT_PARAMETER = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/vis"));
        }
    };
    private static final OwDeviceParameterMap SUPPLY_VOLTAGE_PARAMETER = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/VDD"));
        }
    };

    public DS2438(String sensorId, OwBaseThingHandler callback) {
        super(sensorId, callback);
    }

    @Override
    public void configureChannels() {
        Thing thing = this.callback.getThing();
        Channel humidityChannel = thing.getChannel("humidity");
        if (humidityChannel != null) {
            Configuration channelConfiguration = humidityChannel.getConfiguration();
            if (channelConfiguration.get("humidity") != null) {
                HUMIDITY_PARAMETER.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter((String)channelConfiguration.get("humidity")));
            } else {
                HUMIDITY_PARAMETER.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/humidity"));
            }
        }
        this.isConfigured = true;
    }

    @Override
    public void refresh(OwBaseBridgeHandler bridgeHandler, Boolean forcedRefresh) throws OwException {
        if (this.isConfigured.booleanValue()) {
            State light;
            if (this.enabledChannels.contains("temperature") || this.enabledChannels.contains("humidity") || this.enabledChannels.contains("absolutehumidity") || this.enabledChannels.contains("dewpoint")) {
                QuantityType temperature = new QuantityType((Number)((DecimalType)bridgeHandler.readDecimalType(this.sensorId, TEMPERATURE_PARAMETER)), SIUnits.CELSIUS);
                this.logger.trace("read temperature {} from {}", (Object)temperature, (Object)this.sensorId);
                if (this.enabledChannels.contains("temperature")) {
                    this.callback.postUpdate("temperature", (State)temperature);
                }
                if (this.enabledChannels.contains("humidity") || this.enabledChannels.contains("absolutehumidity") || this.enabledChannels.contains("dewpoint")) {
                    QuantityType humidity = new QuantityType((Number)((DecimalType)bridgeHandler.readDecimalType(this.sensorId, HUMIDITY_PARAMETER)), SmartHomeUnits.PERCENT);
                    this.logger.trace("read humidity {} from {}", (Object)humidity, (Object)this.sensorId);
                    if (this.enabledChannels.contains("humidity")) {
                        this.callback.postUpdate("humidity", (State)humidity);
                    }
                    if (this.enabledChannels.contains("absolutehumidity")) {
                        this.callback.postUpdate("absolutehumidity", Util.calculateAbsoluteHumidity((QuantityType<Temperature>)temperature, (QuantityType<Dimensionless>)humidity));
                    }
                    if (this.enabledChannels.contains("dewpoint")) {
                        this.callback.postUpdate("dewpoint", Util.calculateDewpoint((QuantityType<Temperature>)temperature, (QuantityType<Dimensionless>)humidity));
                    }
                }
            }
            if (this.enabledChannels.contains("voltage")) {
                QuantityType voltage = new QuantityType((Number)((DecimalType)bridgeHandler.readDecimalType(this.sensorId, VOLTAGE_PARAMETER)), SmartHomeUnits.VOLT);
                this.logger.trace("read voltage {} from {}", (Object)voltage, (Object)this.sensorId);
                this.callback.postUpdate("voltage", (State)voltage);
            }
            if (this.enabledChannels.contains("current")) {
                QuantityType current = new QuantityType((Number)((DecimalType)bridgeHandler.readDecimalType(this.sensorId, CURRENT_PARAMETER)), MetricPrefix.MILLI((Unit)SmartHomeUnits.AMPERE));
                this.callback.postUpdate("current", (State)current);
            }
            if (this.enabledChannels.contains("light") && (light = bridgeHandler.readDecimalType(this.sensorId, CURRENT_PARAMETER)) instanceof DecimalType) {
                light = this.lightSensorType == LightSensorType.ElabNetV2 ? new QuantityType((Number)Math.round(Math.pow(10.0, ((DecimalType)light).doubleValue() / 47.0 * 1000.0)), SmartHomeUnits.LUX) : new QuantityType((Number)Math.round(Math.exp(1.059 * Math.log(1000000.0 * ((DecimalType)light).doubleValue() / 1597440.0) + 4.518) * 20000.0), SmartHomeUnits.LUX);
                this.callback.postUpdate("light", light);
            }
            if (this.enabledChannels.contains("supplyvoltage")) {
                QuantityType supplyVoltage = new QuantityType((Number)((DecimalType)bridgeHandler.readDecimalType(this.sensorId, SUPPLY_VOLTAGE_PARAMETER)), SmartHomeUnits.VOLT);
                this.callback.postUpdate("supplyvoltage", (State)supplyVoltage);
            }
        }
    }

    public void setLightSensorType(LightSensorType lightSensorType) {
        this.lightSensorType = lightSensorType;
    }

    public static enum LightSensorType {
        ElabNetV1,
        ElabNetV2;

    }
}

