/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.handler;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwDynamicStateDescriptionProvider;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.OwPageBuffer;
import org.eclipse.smarthome.binding.onewire.internal.Util;
import org.eclipse.smarthome.binding.onewire.internal.device.AbstractOwDevice;
import org.eclipse.smarthome.binding.onewire.internal.device.DS18x20;
import org.eclipse.smarthome.binding.onewire.internal.device.DS1923;
import org.eclipse.smarthome.binding.onewire.internal.device.DS2406_DS2413;
import org.eclipse.smarthome.binding.onewire.internal.device.DS2438;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.builder.ChannelBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class MultisensorThingHandler
extends OwBaseThingHandler {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = new HashSet<ThingTypeUID>(Arrays.asList(OwBindingConstants.THING_TYPE_MS_TH, OwBindingConstants.THING_TYPE_MS_THS, OwBindingConstants.THING_TYPE_MS_TV, OwBindingConstants.THING_TYPE_AMS, OwBindingConstants.THING_TYPE_BMS));
    private final Logger logger = LoggerFactory.getLogger(MultisensorThingHandler.class);
    private final ThingTypeUID thingType = this.thing.getThingTypeUID();
    private String prodDate = "";
    private int hwRevision = 0;
    private int digitalRefreshInterval = 10000;
    private long digitalLastRefresh = 0L;

    public MultisensorThingHandler(Thing thing, OwDynamicStateDescriptionProvider dynamicStateDescriptionProvider) {
        super(thing, dynamicStateDescriptionProvider);
    }

    @Override
    public void initialize() {
        Configuration configuration = this.getConfig();
        Map properties = this.editProperties();
        if (!super.configure()) {
            return;
        }
        if (this.getThing().getStatus() == ThingStatus.OFFLINE) {
            return;
        }
        this.digitalRefreshInterval = configuration.containsKey("digitalrefresh") ? ((BigDecimal)configuration.get("digitalrefresh")).intValue() * 1000 : 10000;
        this.digitalLastRefresh = 0L;
        if (((String)this.sensorIds.get(0)).startsWith("41") || properties.get("modelId") != null && ((String)properties.get("modelId")).equals(OwSensorType.DS1923.name())) {
            this.sensors.add(new DS1923((String)this.sensorIds.get(0), this));
        } else {
            this.sensors.add(new DS2438((String)this.sensorIds.get(0), this));
        }
        if (OwBindingConstants.THING_TYPE_BMS.equals((Object)this.thingType)) {
            this.sensors.add(new DS18x20((String)this.sensorIds.get(1), this));
        } else if (OwBindingConstants.THING_TYPE_AMS.equals((Object)this.thingType)) {
            this.sensors.add(new DS18x20((String)this.sensorIds.get(1), this));
            this.sensors.add(new DS2438((String)this.sensorIds.get(2), this));
            this.sensors.add(new DS2406_DS2413((String)this.sensorIds.get(3), this));
        }
        if (OwBindingConstants.THING_TYPE_BMS.equals((Object)this.thingType) || OwBindingConstants.THING_TYPE_AMS.equals((Object)this.thingType)) {
            if (properties.containsKey("prodDate") && properties.containsKey("hwRevision")) {
                this.hwRevision = Integer.valueOf((String)properties.get("hwRevision"));
            } else {
                this.scheduler.execute(() -> this.updateSensorProperties());
                return;
            }
        }
        this.scheduler.execute(() -> this.configureThingChannels());
    }

    @Override
    public void refresh(OwBaseBridgeHandler bridgeHandler, long now) {
        try {
            Boolean forcedRefresh;
            if (now >= this.digitalLastRefresh + (long)this.digitalRefreshInterval && this.thingType == OwBindingConstants.THING_TYPE_AMS) {
                this.logger.trace("refreshing digital {}", (Object)this.thing.getUID());
                forcedRefresh = this.digitalLastRefresh == 0L;
                this.digitalLastRefresh = now;
                if (!((AbstractOwDevice)this.sensors.get(3)).checkPresence(bridgeHandler).booleanValue()) {
                    return;
                }
                ((AbstractOwDevice)this.sensors.get(3)).refresh(bridgeHandler, forcedRefresh);
            }
            if (now >= this.lastRefresh + this.refreshInterval) {
                if (!((AbstractOwDevice)this.sensors.get(0)).checkPresence(bridgeHandler).booleanValue()) {
                    return;
                }
                this.logger.trace("refreshing analog {}", (Object)this.thing.getUID());
                forcedRefresh = this.lastRefresh == 0L;
                this.lastRefresh = now;
                if (this.thingType.equals((Object)OwBindingConstants.THING_TYPE_AMS)) {
                    int i = 0;
                    while (i < this.sensorCount - 1) {
                        ((AbstractOwDevice)this.sensors.get(i)).refresh(bridgeHandler, forcedRefresh);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.sensorCount) {
                        ((AbstractOwDevice)this.sensors.get(i)).refresh(bridgeHandler, forcedRefresh);
                        ++i;
                    }
                }
            }
        }
        catch (OwException e) {
            this.logger.debug("{}: refresh exception '{}'", (Object)this.thing.getUID(), (Object)e.getMessage());
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "refresh exception");
        }
    }

    private void configureThingChannels() {
        Configuration configuration = this.getConfig();
        ThingBuilder thingBuilder = this.editThing();
        this.logger.debug("configuring sensors for {}", (Object)this.thing.getLabel());
        if (this.thing.getChannel("supplyvoltage") != null) {
            ((AbstractOwDevice)this.sensors.get(0)).enableChannel("supplyvoltage");
        }
        Channel temperatureChannel = this.thing.getChannel("temperature");
        if (configuration.containsKey("temperaturesensor") && configuration.get("temperaturesensor").equals("DS18B20") && this.sensorCount > 1) {
            ((AbstractOwDevice)this.sensors.get(1)).enableChannel("temperature");
            if (temperatureChannel == null) {
                thingBuilder.withChannel(Util.buildTemperatureChannel(this.thing.getUID(), OwBindingConstants.CHANNEL_TYPE_UID_TEMPERATURE_POR_RES));
            } else if (!OwBindingConstants.CHANNEL_TYPE_UID_TEMPERATURE_POR_RES.equals((Object)temperatureChannel.getChannelTypeUID())) {
                thingBuilder.withoutChannel(temperatureChannel.getUID());
                thingBuilder.withChannel(Util.buildTemperatureChannel(this.thing.getUID(), OwBindingConstants.CHANNEL_TYPE_UID_TEMPERATURE_POR_RES));
            }
        } else {
            ((AbstractOwDevice)this.sensors.get(0)).enableChannel("temperature");
            if (temperatureChannel == null) {
                thingBuilder.withChannel(Util.buildTemperatureChannel(this.thing.getUID(), OwBindingConstants.CHANNEL_TYPE_UID_TEMPERATURE));
            } else if (!OwBindingConstants.CHANNEL_TYPE_UID_TEMPERATURE.equals((Object)temperatureChannel.getChannelTypeUID())) {
                thingBuilder.withoutChannel(temperatureChannel.getUID());
                thingBuilder.withChannel(Util.buildTemperatureChannel(this.thing.getUID(), OwBindingConstants.CHANNEL_TYPE_UID_TEMPERATURE));
            }
        }
        if (OwBindingConstants.THING_TYPE_MS_TV.equals((Object)this.thingType)) {
            ((AbstractOwDevice)this.sensors.get(0)).enableChannel("voltage");
        } else if (OwBindingConstants.THING_TYPE_AMS.equals((Object)this.thingType) || OwBindingConstants.THING_TYPE_BMS.equals((Object)this.thingType) || OwBindingConstants.THING_TYPE_MS_TH.equals((Object)this.thingType) || OwBindingConstants.THING_TYPE_MS_THS.equals((Object)this.thingType)) {
            ((AbstractOwDevice)this.sensors.get(0)).enableChannel("humidity");
            if (this.thing.getChannel("absolutehumidity") != null) {
                ((AbstractOwDevice)this.sensors.get(0)).enableChannel("absolutehumidity");
            }
            if (this.thing.getChannel("dewpoint") != null) {
                ((AbstractOwDevice)this.sensors.get(0)).enableChannel("dewpoint");
            }
        }
        if (OwBindingConstants.THING_TYPE_AMS.equals((Object)this.thingType) || OwBindingConstants.THING_TYPE_BMS.equals((Object)this.thingType)) {
            if (configuration.containsKey("lightsensor") && ((Boolean)configuration.get("lightsensor")).booleanValue()) {
                ((AbstractOwDevice)this.sensors.get(0)).enableChannel("light");
                if (this.thing.getChannel("current") != null) {
                    thingBuilder.withoutChannel(new ChannelUID(this.getThing().getUID(), "current"));
                }
                if (this.thing.getChannel("light") == null) {
                    thingBuilder.withChannel(ChannelBuilder.create((ChannelUID)new ChannelUID(this.getThing().getUID(), "light"), (String)"Number:Illuminance").withLabel("Light").withType(new ChannelTypeUID("onewire", "light")).build());
                }
                if (this.hwRevision <= 13) {
                    ((DS2438)this.sensors.get(0)).setLightSensorType(DS2438.LightSensorType.ElabNetV1);
                } else {
                    ((DS2438)this.sensors.get(0)).setLightSensorType(DS2438.LightSensorType.ElabNetV2);
                }
            } else {
                ((AbstractOwDevice)this.sensors.get(0)).enableChannel("current");
                if (this.thing.getChannel("light") != null) {
                    thingBuilder.withoutChannel(new ChannelUID(this.getThing().getUID(), "light"));
                }
                if (this.thing.getChannel("current") == null) {
                    thingBuilder.withChannel(ChannelBuilder.create((ChannelUID)new ChannelUID(this.getThing().getUID(), "current"), (String)"Number:Current").withLabel("Current").withType(new ChannelTypeUID("onewire", "current")).build());
                }
            }
        }
        if (OwBindingConstants.THING_TYPE_AMS.equals((Object)this.thingType)) {
            ((AbstractOwDevice)this.sensors.get(2)).enableChannel("voltage");
        }
        if (OwBindingConstants.THING_TYPE_AMS.equals((Object)this.thingType)) {
            this.digitalRefreshInterval = configuration.containsKey("digitalrefresh") ? ((BigDecimal)configuration.get("digitalrefresh")).intValue() * 1000 : 10000;
        }
        if (this.sensors.get(0) instanceof DS1923 && this.thing.getChannel("supplyvoltage") != null) {
            thingBuilder.withoutChannel(new ChannelUID(this.getThing().getUID(), "supplyvoltage"));
        }
        this.updateThing(thingBuilder.build());
        try {
            int i = 0;
            while (i < this.sensorCount) {
                ((AbstractOwDevice)this.sensors.get(i)).configureChannels();
                ++i;
            }
        }
        catch (OwException e) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, e.getMessage());
            return;
        }
        this.validConfig = true;
        this.updatePresenceStatus((State)UnDefType.UNDEF);
    }

    @Override
    protected void updateSensorProperties() {
        this.logger.info("updating {}", (Object)this.thing.getLabel());
        Map properties = this.editProperties();
        Bridge bridge = this.getBridge();
        if (bridge == null) {
            this.logger.debug("updating thing properties failed, no bridge available");
            this.scheduler.schedule(() -> this.updateSensorProperties(), 5000L, TimeUnit.MILLISECONDS);
            return;
        }
        OwBaseBridgeHandler bridgeHandler = (OwBaseBridgeHandler)bridge.getHandler();
        try {
            if (bridgeHandler == null) {
                throw new OwException("no bridge handler available");
            }
            OwPageBuffer pages = bridgeHandler.readPages((String)this.sensorIds.get(0));
            this.prodDate = String.format("%d/%d", pages.getByte(5, 0), 256 * pages.getByte(5, 1) + pages.getByte(5, 2));
            this.hwRevision = pages.getByte(5, 3);
            properties.put("prodDate", this.prodDate);
            properties.put("hwRevision", String.valueOf(this.hwRevision));
            this.logger.debug("set production date {}, revision {}", (Object)this.prodDate, (Object)this.hwRevision);
        }
        catch (OwException e) {
            this.logger.info("updating thing properties failed: {}", (Object)e.getMessage());
            this.scheduler.schedule(() -> this.updateSensorProperties(), 5000L, TimeUnit.MILLISECONDS);
            return;
        }
        this.updateProperties(properties);
        this.initialize();
    }
}

