/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.handler;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.OwPageBuffer;
import org.eclipse.smarthome.binding.onewire.internal.device.OwDeviceParameterMap;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverConnection;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverConnectionState;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverDeviceParameter;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;

@NonNullByDefault
public class OwserverBridgeHandler
extends OwBaseBridgeHandler {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(OwBindingConstants.THING_TYPE_OWSERVER);
    private static final int RECONNECT_AFTER_FAIL_TIME = 5000;
    private final OwserverConnection owserverConnection;

    public OwserverBridgeHandler(Bridge bridge) {
        super(bridge);
        this.owserverConnection = new OwserverConnection(this);
    }

    public OwserverBridgeHandler(Bridge bridge, OwserverConnection owserverConnection) {
        super(bridge);
        this.owserverConnection = owserverConnection;
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
    }

    public void initialize() {
        Configuration configuration = this.getConfig();
        if (configuration.get("network-address") != null) {
            this.owserverConnection.setHost((String)configuration.get("network-address"));
        }
        if (configuration.get("port") != null) {
            this.owserverConnection.setPort(((BigDecimal)configuration.get("port")).intValue());
        }
        this.updateStatus(ThingStatus.UNKNOWN);
        this.scheduler.execute(() -> this.owserverConnection.start());
    }

    @Override
    public void dispose() {
        this.owserverConnection.stop();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDirectory() throws OwException {
        OwserverConnection owserverConnection = this.owserverConnection;
        synchronized (owserverConnection) {
            return this.owserverConnection.getDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public State checkPresence(String sensorId) throws OwException {
        OwserverConnection owserverConnection = this.owserverConnection;
        synchronized (owserverConnection) {
            return this.owserverConnection.checkPresence(sensorId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OwSensorType getType(String sensorId) throws OwException {
        OwSensorType sensorType = OwSensorType.UNKNOWN;
        OwserverConnection owserverConnection = this.owserverConnection;
        synchronized (owserverConnection) {
            try {
                sensorType = OwSensorType.valueOf(this.owserverConnection.readString(String.valueOf(sensorId) + "/type"));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return sensorType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public State readDecimalType(String sensorId, OwDeviceParameterMap parameter) throws OwException {
        OwserverConnection owserverConnection = this.owserverConnection;
        synchronized (owserverConnection) {
            return this.owserverConnection.readDecimalType(((OwserverDeviceParameter)parameter.get(OwBindingConstants.THING_TYPE_OWSERVER)).getPath(sensorId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<State> readDecimalTypeArray(String sensorId, OwDeviceParameterMap parameter) throws OwException {
        OwserverConnection owserverConnection = this.owserverConnection;
        synchronized (owserverConnection) {
            return this.owserverConnection.readDecimalTypeArray(((OwserverDeviceParameter)parameter.get(OwBindingConstants.THING_TYPE_OWSERVER)).getPath(sensorId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OwPageBuffer readPages(String sensorId) throws OwException {
        OwserverConnection owserverConnection = this.owserverConnection;
        synchronized (owserverConnection) {
            return this.owserverConnection.readPages(sensorId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readString(String sensorId, OwDeviceParameterMap parameter) throws OwException {
        OwserverConnection owserverConnection = this.owserverConnection;
        synchronized (owserverConnection) {
            return this.owserverConnection.readString(((OwserverDeviceParameter)parameter.get(OwBindingConstants.THING_TYPE_OWSERVER)).getPath(sensorId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDecimalType(String path, OwDeviceParameterMap parameter, DecimalType value) throws OwException {
        OwserverConnection owserverConnection = this.owserverConnection;
        synchronized (owserverConnection) {
            this.owserverConnection.writeDecimalType(((OwserverDeviceParameter)parameter.get(OwBindingConstants.THING_TYPE_OWSERVER)).getPath(path), value);
        }
    }

    public void reportConnectionState(OwserverConnectionState connectionState) {
        switch (connectionState) {
            case FAILED: {
                this.refreshable = false;
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR);
                this.scheduler.schedule(() -> this.owserverConnection.start(), 5000L, TimeUnit.MILLISECONDS);
                break;
            }
            case STOPPED: {
                this.refreshable = false;
                break;
            }
            case OPENED: 
            case CLOSED: {
                this.refreshable = true;
                this.updateStatus(ThingStatus.ONLINE, ThingStatusDetail.NONE);
            }
        }
    }
}

