/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.openweathermap.internal.handler;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.measure.Unit;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.openweathermap.internal.OpenWeatherMapBindingConstants;
import org.eclipse.smarthome.binding.openweathermap.internal.config.OpenWeatherMapLocationConfiguration;
import org.eclipse.smarthome.binding.openweathermap.internal.connection.OpenWeatherMapCommunicationException;
import org.eclipse.smarthome.binding.openweathermap.internal.connection.OpenWeatherMapConfigurationException;
import org.eclipse.smarthome.binding.openweathermap.internal.connection.OpenWeatherMapConnection;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.PointType;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.library.types.RawType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelGroupUID;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerCallback;
import org.eclipse.smarthome.core.thing.binding.builder.ChannelBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelKind;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractOpenWeatherMapHandler
extends BaseThingHandler {
    private final Logger logger = LoggerFactory.getLogger(AbstractOpenWeatherMapHandler.class);
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(OpenWeatherMapBindingConstants.THING_TYPE_WEATHER_AND_FORECAST);
    protected @Nullable PointType location;

    public AbstractOpenWeatherMapHandler(Thing thing) {
        super(thing);
    }

    public void initialize() {
        OpenWeatherMapLocationConfiguration config = (OpenWeatherMapLocationConfiguration)this.getConfigAs(OpenWeatherMapLocationConfiguration.class);
        boolean configValid = true;
        if (StringUtils.trimToNull((String)config.getLocation()) == null) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "@text/offline.conf-error-missing-location");
            configValid = false;
        }
        try {
            this.location = new PointType(config.getLocation());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.location = null;
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "@text/offline.conf-error-parsing-location");
            configValid = false;
        }
        if (configValid) {
            this.updateStatus(ThingStatus.UNKNOWN);
        }
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        if (command instanceof RefreshType) {
            this.updateChannel(channelUID);
        } else {
            this.logger.debug("The OpenWeatherMap binding is a read-only binding and cannot handle command '{}'.", (Object)command);
        }
    }

    public void bridgeStatusChanged(ThingStatusInfo bridgeStatusInfo) {
        if (ThingStatus.ONLINE.equals((Object)bridgeStatusInfo.getStatus()) && ThingStatusDetail.BRIDGE_OFFLINE.equals((Object)this.getThing().getStatusInfo().getStatusDetail())) {
            this.updateStatus(ThingStatus.ONLINE, ThingStatusDetail.NONE);
        } else if (ThingStatus.OFFLINE.equals((Object)bridgeStatusInfo.getStatus()) && !ThingStatus.OFFLINE.equals((Object)this.getThing().getStatus())) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.BRIDGE_OFFLINE);
        }
    }

    public void updateData(OpenWeatherMapConnection connection) {
        try {
            if (this.requestData(connection)) {
                this.updateChannels();
                this.updateStatus(ThingStatus.ONLINE);
            }
        }
        catch (OpenWeatherMapCommunicationException e) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getLocalizedMessage());
        }
        catch (OpenWeatherMapConfigurationException e) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, e.getLocalizedMessage());
        }
    }

    protected abstract boolean requestData(OpenWeatherMapConnection var1) throws OpenWeatherMapCommunicationException, OpenWeatherMapConfigurationException;

    private void updateChannels() {
        for (Channel channel : this.getThing().getChannels()) {
            ChannelUID channelUID = channel.getUID();
            if (!ChannelKind.STATE.equals((Object)channel.getKind()) || !channelUID.isInGroup() || channelUID.getGroupId() == null || !this.isLinked(channelUID)) continue;
            this.updateChannel(channelUID);
        }
    }

    protected abstract void updateChannel(ChannelUID var1);

    protected State getDateTimeTypeState(@Nullable Integer value) {
        return value == null ? UnDefType.UNDEF : new DateTimeType(ZonedDateTime.ofInstant(Instant.ofEpochSecond(value.longValue()), ZoneId.systemDefault()));
    }

    protected State getPointTypeState(@Nullable Double latitude, @Nullable Double longitude) {
        return latitude == null || longitude == null ? UnDefType.UNDEF : new PointType(new DecimalType(latitude.doubleValue()), new DecimalType(longitude.doubleValue()));
    }

    protected State getRawTypeState(@Nullable RawType image) {
        return image == null ? UnDefType.UNDEF : image;
    }

    protected State getStringTypeState(@Nullable String value) {
        return value == null ? UnDefType.UNDEF : new StringType(value);
    }

    protected State getQuantityTypeState(@Nullable Number value, Unit<?> unit) {
        return value == null ? UnDefType.UNDEF : new QuantityType(value, unit);
    }

    protected List<Channel> createChannelsForGroup(String channelGroupId, ChannelGroupTypeUID channelGroupTypeUID) {
        this.logger.debug("Building channel group '{}' for thing '{}'.", (Object)channelGroupId, (Object)this.getThing().getUID());
        ArrayList<Channel> channels = new ArrayList<Channel>();
        ThingHandlerCallback callback = this.getCallback();
        if (callback != null) {
            for (ChannelBuilder channelBuilder : callback.createChannelBuilders(new ChannelGroupUID(this.getThing().getUID(), channelGroupId), channelGroupTypeUID)) {
                channels.add(channelBuilder.build());
            }
        }
        return channels;
    }

    protected List<Channel> removeChannelsOfGroup(String channelGroupId) {
        this.logger.debug("Removing channel group '{}' from thing '{}'.", (Object)channelGroupId, (Object)this.getThing().getUID());
        return this.getThing().getChannelsOfGroup(channelGroupId);
    }
}

