/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.sonos.internal.handler;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.sonos.internal.SonosAlarm;
import org.eclipse.smarthome.binding.sonos.internal.SonosBindingConstants;
import org.eclipse.smarthome.binding.sonos.internal.SonosEntry;
import org.eclipse.smarthome.binding.sonos.internal.SonosMetaData;
import org.eclipse.smarthome.binding.sonos.internal.SonosMusicService;
import org.eclipse.smarthome.binding.sonos.internal.SonosStateDescriptionOptionProvider;
import org.eclipse.smarthome.binding.sonos.internal.SonosXMLParser;
import org.eclipse.smarthome.binding.sonos.internal.SonosZoneGroup;
import org.eclipse.smarthome.binding.sonos.internal.SonosZonePlayerState;
import org.eclipse.smarthome.binding.sonos.internal.config.ZonePlayerConfiguration;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.NextPreviousType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.PlayPauseType;
import org.eclipse.smarthome.core.library.types.RawType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateOption;
import org.eclipse.smarthome.core.types.UnDefType;
import org.eclipse.smarthome.io.net.http.HttpUtil;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOParticipant;
import org.eclipse.smarthome.io.transport.upnp.UpnpIOService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZonePlayerHandler
extends BaseThingHandler
implements UpnpIOParticipant {
    private final Logger logger = LoggerFactory.getLogger(ZonePlayerHandler.class);
    private static final String ANALOG_LINE_IN_URI = "x-rincon-stream:";
    private static final String OPTICAL_LINE_IN_URI = "x-sonos-htastream:";
    private static final String QUEUE_URI = "x-rincon-queue:";
    private static final String GROUP_URI = "x-rincon:";
    private static final String STREAM_URI = "x-sonosapi-stream:";
    private static final String RADIO_URI = "x-sonosapi-radio:";
    private static final String FILE_URI = "x-file-cifs:";
    private static final String SPDIF = ":spdif";
    private static final String TUNEIN_URI = "x-sonosapi-stream:s%s?sid=%s&flags=32";
    private static final String STATE_PLAYING = "PLAYING";
    private static final String STATE_PAUSED_PLAYBACK = "PAUSED_PLAYBACK";
    private static final String STATE_STOPPED = "STOPPED";
    private UpnpIOService service;
    private ScheduledFuture<?> pollingJob;
    private SonosZonePlayerState savedState = null;
    private static final Collection<String> SERVICE_SUBSCRIPTIONS = Arrays.asList("DeviceProperties", "AVTransport", "ZoneGroupTopology", "GroupManagement", "RenderingControl", "AudioIn", "HTControl", "ContentDirectory");
    private Map<String, Boolean> subscriptionState = new HashMap<String, Boolean>();
    protected static final int SUBSCRIPTION_DURATION = 1800;
    private static final int SOCKET_TIMEOUT = 5000;
    private static final Integer DEFAULT_NOTIFICATION_TIMEOUT = 20;
    private Integer notificationTimeout = null;
    private final Object notificationLock = new Object();
    private ZonePlayerHandler coordinatorHandler;
    private static final int DEFAULT_REFRESH_INTERVAL = 60;
    private final Map<String, String> stateMap = Collections.synchronizedMap(new HashMap());
    private List<SonosMusicService> musicServices;
    private final Object upnpLock = new Object();
    private final Object stateLock = new Object();
    private SonosStateDescriptionOptionProvider stateDescriptionProvider;
    private final Runnable pollingRunnable = () -> {
        try {
            this.logger.debug("Polling job");
            if (!this.isUpnpDeviceRegistered()) {
                this.logger.debug("UPnP device {} not yet registered", (Object)this.getUDN());
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "@text/offline.upnp-device-not-registered [\"" + this.getUDN() + "\"]");
                Object object = this.upnpLock;
                synchronized (object) {
                    this.subscriptionState = new HashMap<String, Boolean>();
                }
                return;
            }
            this.updatePlayerState();
            if (this.getThing().getStatus() != ThingStatus.ONLINE) {
                return;
            }
            this.addSubscription();
            this.updateZoneInfo();
            this.updateLed();
            this.updateSleepTimerDuration();
        }
        catch (Exception e) {
            this.logger.debug("Exception during poll: {}", (Object)e.getMessage(), (Object)e);
        }
    };
    private final String opmlUrl;

    public ZonePlayerHandler(Thing thing, UpnpIOService upnpIOService, String opmlUrl, SonosStateDescriptionOptionProvider stateDescriptionProvider) {
        super(thing);
        this.opmlUrl = opmlUrl;
        this.logger.debug("Creating a ZonePlayerHandler for thing '{}'", (Object)this.getThing().getUID());
        if (upnpIOService != null) {
            this.service = upnpIOService;
        }
        this.stateDescriptionProvider = stateDescriptionProvider;
    }

    public void dispose() {
        this.logger.debug("Handler disposed for thing {}", (Object)this.getThing().getUID());
        if (this.pollingJob != null && !this.pollingJob.isCancelled()) {
            this.pollingJob.cancel(true);
            this.pollingJob = null;
        }
        this.removeSubscription();
        this.service.unregisterParticipant((UpnpIOParticipant)this);
    }

    public void initialize() {
        this.logger.debug("initializing handler for thing {}", (Object)this.getThing().getUID());
        if (this.migrateThingType()) {
            return;
        }
        if (this.getUDN() != null) {
            this.service.registerParticipant((UpnpIOParticipant)this);
            this.onUpdate();
            this.notificationTimeout = ((ZonePlayerConfiguration)this.getConfigAs(ZonePlayerConfiguration.class)).notificationTimeout;
            if (this.notificationTimeout == null) {
                this.notificationTimeout = DEFAULT_NOTIFICATION_TIMEOUT;
            }
        } else {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "@text/offline.conf-error-missing-udn");
            this.logger.debug("Cannot initalize the zoneplayer. UDN not set.");
        }
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        block96: {
            block95: {
                if (!(command instanceof RefreshType)) break block95;
                this.updateChannel(channelUID.getId());
                break block96;
            }
            switch (channelUID.getId()) {
                case "led": {
                    this.setLed(command);
                    break;
                }
                case "mute": {
                    this.setMute(command);
                    break;
                }
                case "notificationsound": {
                    this.scheduleNotificationSound(command);
                    break;
                }
                case "stop": {
                    this.stopPlaying(command);
                    break;
                }
                case "volume": {
                    this.setVolumeForGroup(command);
                    break;
                }
                case "add": {
                    this.addMember(command);
                    break;
                }
                case "remove": {
                    this.removeMember(command);
                    break;
                }
                case "standalone": {
                    this.becomeStandAlonePlayer();
                    break;
                }
                case "publicaddress": {
                    this.publicAddress();
                    break;
                }
                case "radio": {
                    this.playRadio(command);
                    break;
                }
                case "tuneinstationid": {
                    this.playTuneinStation(command);
                    break;
                }
                case "favorite": {
                    this.playFavorite(command);
                    break;
                }
                case "alarm": {
                    this.setAlarm(command);
                    break;
                }
                case "snooze": {
                    this.snoozeAlarm(command);
                    break;
                }
                case "saveall": {
                    this.saveAllPlayerState();
                    break;
                }
                case "restoreall": {
                    this.restoreAllPlayerState();
                    break;
                }
                case "save": {
                    this.saveState();
                    break;
                }
                case "restore": {
                    this.restoreState();
                    break;
                }
                case "playlist": {
                    this.playPlayList(command);
                    break;
                }
                case "clearqueue": {
                    this.clearQueue();
                    break;
                }
                case "playqueue": {
                    this.playQueue();
                    break;
                }
                case "playtrack": {
                    this.playTrack(command);
                    break;
                }
                case "playuri": {
                    this.playURI(command);
                    break;
                }
                case "playlinein": {
                    this.playLineIn(command);
                    break;
                }
                case "control": {
                    try {
                        if (command instanceof PlayPauseType) {
                            if (command == PlayPauseType.PLAY) {
                                this.getCoordinatorHandler().play();
                            } else if (command == PlayPauseType.PAUSE) {
                                this.getCoordinatorHandler().pause();
                            }
                        }
                        if (!(command instanceof NextPreviousType)) break;
                        if (command == NextPreviousType.NEXT) {
                            this.getCoordinatorHandler().next();
                            break;
                        }
                        if (command != NextPreviousType.PREVIOUS) break;
                        this.getCoordinatorHandler().previous();
                    }
                    catch (IllegalStateException e) {
                        this.logger.debug("Cannot handle control command ({})", (Object)e.getMessage());
                    }
                    break;
                }
                case "sleeptimer": {
                    this.setSleepTimer(command);
                    break;
                }
                case "shuffle": {
                    this.setShuffle(command);
                    break;
                }
                case "repeat": {
                    this.setRepeat(command);
                    break;
                }
            }
        }
    }

    private void restoreAllPlayerState() {
        Collection allThings = this.thingRegistry.getAll();
        for (Thing aThing : allThings) {
            ZonePlayerHandler handler;
            if (!SonosBindingConstants.SUPPORTED_THING_TYPES_UIDS.contains(aThing.getThingTypeUID()) || (handler = (ZonePlayerHandler)aThing.getHandler()) == null) continue;
            handler.restoreState();
        }
    }

    private void saveAllPlayerState() {
        Collection allThings = this.thingRegistry.getAll();
        for (Thing aThing : allThings) {
            ZonePlayerHandler handler;
            if (!SonosBindingConstants.SUPPORTED_THING_TYPES_UIDS.contains(aThing.getThingTypeUID()) || (handler = (ZonePlayerHandler)aThing.getHandler()) == null) continue;
            handler.saveState();
        }
    }

    public void onValueReceived(String variable, String value, String service) {
        block100: {
            Map<String, String> parsedValues;
            if (this.getThing().getStatus() != ThingStatus.ONLINE) break block100;
            this.logger.trace("Received pair '{}':'{}' (service '{}') for thing '{}'", new Object[]{variable, value, service, this.getThing().getUID()});
            String oldValue = this.stateMap.get(variable);
            if (this.shouldIgnoreVariableUpdate(variable, value, oldValue)) {
                return;
            }
            this.stateMap.put(variable, value);
            if (service.equals("AVTransport") && variable.equals("LastChange")) {
                parsedValues = SonosXMLParser.getAVTransportFromXML(value);
                for (String parsedValue : parsedValues.keySet()) {
                    if (!parsedValue.equals("TransportState")) {
                        this.onValueReceived(parsedValue, parsedValues.get(parsedValue), "AVTransport");
                    }
                    if (parsedValue.equals("AVTransportURI")) {
                        this.onValueReceived("CurrentURI", parsedValues.get(parsedValue), service);
                        continue;
                    }
                    if (!parsedValue.equals("AVTransportURIMetaData")) continue;
                    this.onValueReceived("CurrentURIMetaData", parsedValues.get(parsedValue), service);
                }
                this.updateMediaInformation();
                if (parsedValues.get("TransportState") != null) {
                    this.onValueReceived("TransportState", parsedValues.get("TransportState"), "AVTransport");
                }
            }
            if (service.equals("RenderingControl") && variable.equals("LastChange")) {
                parsedValues = SonosXMLParser.getRenderingControlFromXML(value);
                for (String parsedValue : parsedValues.keySet()) {
                    this.onValueReceived(parsedValue, parsedValues.get(parsedValue), "RenderingControl");
                }
            }
            ArrayList<StateOption> options = new ArrayList<StateOption>();
            switch (variable) {
                case "TransportState": {
                    this.updateChannel("state");
                    this.updateChannel("control");
                    this.updateChannel("stop");
                    this.dispatchOnAllGroupMembers(variable, value, service);
                    break;
                }
                case "CurrentPlayMode": {
                    this.updateChannel("shuffle");
                    this.updateChannel("repeat");
                    this.dispatchOnAllGroupMembers(variable, value, service);
                    break;
                }
                case "CurrentLEDState": {
                    this.updateChannel("led");
                    break;
                }
                case "ZoneName": {
                    this.updateState("zonename", (State)(this.stateMap.get("ZoneName") != null ? new StringType(this.stateMap.get("ZoneName")) : UnDefType.UNDEF));
                    break;
                }
                case "CurrentZoneName": {
                    this.updateChannel("zonename");
                    break;
                }
                case "ZoneGroupState": {
                    this.updateChannel("coordinator");
                    this.updateGroupCoordinator();
                    this.updateMediaInformation();
                    if (this.stateMap.get("TransportState") != null) {
                        this.dispatchOnAllGroupMembers("TransportState", this.stateMap.get("TransportState"), "AVTransport");
                    }
                    if (this.stateMap.get("CurrentPlayMode") == null) break;
                    this.dispatchOnAllGroupMembers("CurrentPlayMode", this.stateMap.get("CurrentPlayMode"), "AVTransport");
                    break;
                }
                case "LocalGroupUUID": {
                    this.updateChannel("zonegroupid");
                    break;
                }
                case "GroupCoordinatorIsLocal": {
                    this.updateChannel("localcoordinator");
                    break;
                }
                case "VolumeMaster": {
                    this.updateChannel("volume");
                    break;
                }
                case "MuteMaster": {
                    this.updateChannel("mute");
                    break;
                }
                case "LineInConnected": 
                case "TOSLinkConnected": {
                    if (!SonosBindingConstants.WITH_LINEIN_THING_TYPES_UIDS.contains(this.getThing().getThingTypeUID())) break;
                    this.updateChannel("linein");
                    break;
                }
                case "AlarmRunning": {
                    this.updateChannel("alarmrunning");
                    this.updateRunningAlarmProperties();
                    break;
                }
                case "RunningAlarmProperties": {
                    this.updateChannel("alarmproperties");
                    break;
                }
                case "CurrentURIFormatted": {
                    this.updateChannel("currenttrack");
                    break;
                }
                case "CurrentTitle": {
                    this.updateChannel("currenttitle");
                    break;
                }
                case "CurrentArtist": {
                    this.updateChannel("currentartist");
                    break;
                }
                case "CurrentAlbum": {
                    this.updateChannel("currentalbum");
                    break;
                }
                case "CurrentURI": {
                    this.updateChannel("currenttransporturi");
                    break;
                }
                case "CurrentTrackURI": {
                    this.updateChannel("currenttrackuri");
                    break;
                }
                case "CurrentAlbumArtURI": {
                    this.updateChannel("currentalbumarturl");
                    break;
                }
                case "CurrentSleepTimerGeneration": {
                    if (!value.equals("0")) break;
                    this.updateState("sleeptimer", (State)new DecimalType(0L));
                    break;
                }
                case "SleepTimerGeneration": {
                    if (value.equals("0")) {
                        this.updateState("sleeptimer", (State)new DecimalType(0L));
                        break;
                    }
                    this.updateSleepTimerDuration();
                    break;
                }
                case "RemainingSleepTimerDuration": {
                    this.updateState("sleeptimer", (State)(this.stateMap.get("RemainingSleepTimerDuration") != null ? new DecimalType(this.sleepStrTimeToSeconds(this.stateMap.get("RemainingSleepTimerDuration"))) : UnDefType.UNDEF));
                    break;
                }
                case "CurrentTuneInStationId": {
                    this.updateChannel("tuneinstationid");
                    break;
                }
                case "SavedQueuesUpdateID": {
                    for (SonosEntry entry : this.getPlayLists()) {
                        options.add(new StateOption(entry.getTitle(), entry.getTitle()));
                    }
                    this.stateDescriptionProvider.setStateOptions(new ChannelUID(this.getThing().getUID(), "playlist"), options);
                    break;
                }
                case "FavoritesUpdateID": {
                    for (SonosEntry entry : this.getFavorites()) {
                        options.add(new StateOption(entry.getTitle(), entry.getTitle()));
                    }
                    this.stateDescriptionProvider.setStateOptions(new ChannelUID(this.getThing().getUID(), "favorite"), options);
                    break;
                }
                case "ContainerUpdateIDs": {
                    if (!value.startsWith("R:0,") && this.stateDescriptionProvider.getStateOptions(new ChannelUID(this.getThing().getUID(), "radio")) != null) break;
                    for (SonosEntry entry : this.getFavoriteRadios()) {
                        options.add(new StateOption(entry.getTitle(), entry.getTitle()));
                    }
                    this.stateDescriptionProvider.setStateOptions(new ChannelUID(this.getThing().getUID(), "radio"), options);
                    break;
                }
            }
        }
    }

    private void dispatchOnAllGroupMembers(String variable, String value, String service) {
        if (this.isCoordinator()) {
            for (String member : this.getOtherZoneGroupMembers()) {
                try {
                    ZonePlayerHandler memberHandler = this.getHandlerByName(member);
                    if (memberHandler == null || !ThingStatus.ONLINE.equals((Object)memberHandler.getThing().getStatus())) continue;
                    memberHandler.onValueReceived(variable, value, service);
                }
                catch (IllegalStateException e) {
                    this.logger.debug("Cannot update channel for group member ({})", (Object)e.getMessage());
                }
            }
        }
    }

    private String getAlbumArtUrl() {
        String url = null;
        String albumArtURI = this.stateMap.get("CurrentAlbumArtURI");
        if (albumArtURI != null) {
            if (albumArtURI.startsWith("http")) {
                url = albumArtURI;
            } else if (albumArtURI.startsWith("/")) {
                try {
                    URL serviceDescrUrl = this.service.getDescriptorURL((UpnpIOParticipant)this);
                    if (serviceDescrUrl != null) {
                        url = new URL(serviceDescrUrl.getProtocol(), serviceDescrUrl.getHost(), serviceDescrUrl.getPort(), albumArtURI).toExternalForm();
                    }
                }
                catch (MalformedURLException e) {
                    this.logger.debug("Failed to build a valid album art URL from {}: {}", (Object)albumArtURI, (Object)e.getMessage());
                }
            }
        }
        return url;
    }

    protected void updateChannel(String channelId) {
        if (!this.isLinked(channelId)) {
            return;
        }
        UnDefType newState = UnDefType.UNDEF;
        switch (channelId) {
            case "state": {
                if (this.stateMap.get("TransportState") == null) break;
                newState = new StringType(this.stateMap.get("TransportState"));
                break;
            }
            case "control": {
                if (this.stateMap.get("TransportState") == null) break;
                if (this.stateMap.get("TransportState").equals(STATE_PLAYING)) {
                    newState = PlayPauseType.PLAY;
                    break;
                }
                if (this.stateMap.get("TransportState").equals(STATE_STOPPED)) {
                    newState = PlayPauseType.PAUSE;
                    break;
                }
                if (!this.stateMap.get("TransportState").equals(STATE_PAUSED_PLAYBACK)) break;
                newState = PlayPauseType.PAUSE;
                break;
            }
            case "stop": {
                if (this.stateMap.get("TransportState") == null) break;
                if (this.stateMap.get("TransportState").equals(STATE_STOPPED)) {
                    newState = OnOffType.ON;
                    break;
                }
                newState = OnOffType.OFF;
                break;
            }
            case "shuffle": {
                if (this.stateMap.get("CurrentPlayMode") == null) break;
                newState = this.isShuffleActive() != false ? OnOffType.ON : OnOffType.OFF;
                break;
            }
            case "repeat": {
                if (this.stateMap.get("CurrentPlayMode") == null) break;
                newState = new StringType(this.getRepeatMode());
                break;
            }
            case "led": {
                if (this.stateMap.get("CurrentLEDState") == null) break;
                newState = this.stateMap.get("CurrentLEDState").equals("On") ? OnOffType.ON : OnOffType.OFF;
                break;
            }
            case "zonename": {
                if (this.stateMap.get("CurrentZoneName") == null) break;
                newState = new StringType(this.stateMap.get("CurrentZoneName"));
                break;
            }
            case "zonegroupid": {
                if (this.stateMap.get("LocalGroupUUID") == null) break;
                newState = new StringType(this.stateMap.get("LocalGroupUUID"));
                break;
            }
            case "coordinator": {
                newState = new StringType(this.getCoordinator());
                break;
            }
            case "localcoordinator": {
                if (this.stateMap.get("GroupCoordinatorIsLocal") == null) break;
                newState = this.stateMap.get("GroupCoordinatorIsLocal").equals("true") ? OnOffType.ON : OnOffType.OFF;
                break;
            }
            case "volume": {
                if (this.stateMap.get("VolumeMaster") == null) break;
                newState = new PercentType(this.stateMap.get("VolumeMaster"));
                break;
            }
            case "mute": {
                if (this.stateMap.get("MuteMaster") == null) break;
                newState = this.stateMap.get("MuteMaster").equals("1") ? OnOffType.ON : OnOffType.OFF;
                break;
            }
            case "linein": {
                if (this.stateMap.get("LineInConnected") != null) {
                    newState = this.stateMap.get("LineInConnected").equals("true") ? OnOffType.ON : OnOffType.OFF;
                    break;
                }
                if (this.stateMap.get("TOSLinkConnected") == null) break;
                newState = this.stateMap.get("TOSLinkConnected").equals("true") ? OnOffType.ON : OnOffType.OFF;
                break;
            }
            case "alarmrunning": {
                if (this.stateMap.get("AlarmRunning") == null) break;
                newState = this.stateMap.get("AlarmRunning").equals("1") ? OnOffType.ON : OnOffType.OFF;
                break;
            }
            case "alarmproperties": {
                if (this.stateMap.get("RunningAlarmProperties") == null) break;
                newState = new StringType(this.stateMap.get("RunningAlarmProperties"));
                break;
            }
            case "currenttrack": {
                if (this.stateMap.get("CurrentURIFormatted") == null) break;
                newState = new StringType(this.stateMap.get("CurrentURIFormatted"));
                break;
            }
            case "currenttitle": {
                if (this.stateMap.get("CurrentTitle") == null) break;
                newState = new StringType(this.stateMap.get("CurrentTitle"));
                break;
            }
            case "currentartist": {
                if (this.stateMap.get("CurrentArtist") == null) break;
                newState = new StringType(this.stateMap.get("CurrentArtist"));
                break;
            }
            case "currentalbum": {
                if (this.stateMap.get("CurrentAlbum") == null) break;
                newState = new StringType(this.stateMap.get("CurrentAlbum"));
                break;
            }
            case "currentalbumart": {
                newState = null;
                this.updateAlbumArtChannel(false);
                break;
            }
            case "currentalbumarturl": {
                String url = this.getAlbumArtUrl();
                if (url == null) break;
                newState = new StringType(url);
                break;
            }
            case "currenttransporturi": {
                if (this.stateMap.get("CurrentURI") == null) break;
                newState = new StringType(this.stateMap.get("CurrentURI"));
                break;
            }
            case "currenttrackuri": {
                if (this.stateMap.get("CurrentTrackURI") == null) break;
                newState = new StringType(this.stateMap.get("CurrentTrackURI"));
                break;
            }
            case "tuneinstationid": {
                if (this.stateMap.get("CurrentTuneInStationId") == null) break;
                newState = new StringType(this.stateMap.get("CurrentTuneInStationId"));
                break;
            }
            default: {
                newState = null;
            }
        }
        if (newState != null) {
            this.updateState(channelId, (State)newState);
        }
    }

    private void updateAlbumArtChannel(boolean allGroup) {
        String url = this.getAlbumArtUrl();
        if (url != null) {
            this.scheduler.submit(() -> {
                RawType image = HttpUtil.downloadImage((String)url, (boolean)true, (long)500000L);
                this.updateChannel("currentalbumart", (State)(image != null ? image : UnDefType.UNDEF), allGroup);
            });
        } else {
            this.updateChannel("currentalbumart", (State)UnDefType.UNDEF, allGroup);
        }
    }

    private void updateChannel(String channeldD, State state, boolean allGroup) {
        if (allGroup) {
            for (String member : this.getZoneGroupMembers()) {
                try {
                    ZonePlayerHandler memberHandler = this.getHandlerByName(member);
                    if (memberHandler == null || !ThingStatus.ONLINE.equals((Object)memberHandler.getThing().getStatus()) || !memberHandler.isLinked(channeldD)) continue;
                    memberHandler.updateState(channeldD, state);
                }
                catch (IllegalStateException e) {
                    this.logger.debug("Cannot update channel for group member ({})", (Object)e.getMessage());
                }
            }
        } else if (ThingStatus.ONLINE.equals((Object)this.getThing().getStatus()) && this.isLinked(channeldD)) {
            this.updateState(channeldD, state);
        }
    }

    private boolean shouldIgnoreVariableUpdate(String variable, String value, String oldValue) {
        return !this.hasValueChanged(value, oldValue) && !this.isQueueEvent(variable);
    }

    private boolean hasValueChanged(String value, String oldValue) {
        return oldValue != null ? !oldValue.equals(value) : value != null;
    }

    private boolean isQueueEvent(String variable) {
        return "LastChange".equals(variable);
    }

    private void updateGroupCoordinator() {
        try {
            this.coordinatorHandler = this.getHandlerByName(this.getCoordinator());
        }
        catch (IllegalStateException e) {
            this.logger.debug("Cannot update the group coordinator ({})", (Object)e.getMessage());
            this.coordinatorHandler = null;
        }
    }

    private boolean isUpnpDeviceRegistered() {
        return this.service.isRegistered((UpnpIOParticipant)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubscription() {
        Object object = this.upnpLock;
        synchronized (object) {
            if (this.service.isRegistered((UpnpIOParticipant)this)) {
                for (String subscription : SERVICE_SUBSCRIPTIONS) {
                    if (this.subscriptionState.get(subscription) != null && this.subscriptionState.get(subscription).booleanValue()) continue;
                    this.logger.debug("{}: Subscribing to service {}...", (Object)this.getUDN(), (Object)subscription);
                    this.service.addSubscription((UpnpIOParticipant)this, subscription, 1800);
                    this.subscriptionState.put(subscription, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubscription() {
        Object object = this.upnpLock;
        synchronized (object) {
            if (this.service.isRegistered((UpnpIOParticipant)this)) {
                for (String subscription : SERVICE_SUBSCRIPTIONS) {
                    if (this.subscriptionState.get(subscription) == null || !this.subscriptionState.get(subscription).booleanValue()) continue;
                    this.logger.debug("{}: Unsubscribing from service {}...", (Object)this.getUDN(), (Object)subscription);
                    this.service.removeSubscription((UpnpIOParticipant)this, subscription);
                }
            }
            this.subscriptionState = new HashMap<String, Boolean>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceSubscribed(String service, boolean succeeded) {
        Object object = this.upnpLock;
        synchronized (object) {
            this.logger.debug("{}: Subscription to service {} {}", new Object[]{this.getUDN(), service, succeeded ? "succeeded" : "failed"});
            this.subscriptionState.put(service, succeeded);
        }
    }

    private void onUpdate() {
        if (this.pollingJob == null || this.pollingJob.isCancelled()) {
            ZonePlayerConfiguration config = (ZonePlayerConfiguration)this.getConfigAs(ZonePlayerConfiguration.class);
            int refreshInterval = 60;
            if (config.refresh != null) {
                refreshInterval = config.refresh;
            }
            this.pollingJob = this.scheduler.scheduleWithFixedDelay(this.pollingRunnable, 0L, refreshInterval, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePlayerState() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "DeviceProperties", "GetZoneInfo", null);
        if (result.isEmpty()) {
            if (!ThingStatus.OFFLINE.equals((Object)this.getThing().getStatus())) {
                this.logger.debug("Sonos player {} is not available in local network", (Object)this.getUDN());
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "@text/offline.not-available-on-network [\"" + this.getUDN() + "\"]");
                Object object = this.upnpLock;
                synchronized (object) {
                    this.subscriptionState = new HashMap<String, Boolean>();
                }
            }
        } else if (!ThingStatus.ONLINE.equals((Object)this.getThing().getStatus())) {
            this.logger.debug("Sonos player {} has been found in local network", (Object)this.getUDN());
            this.updateStatus(ThingStatus.ONLINE);
        }
    }

    protected void updateCurrentZoneName() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "DeviceProperties", "GetZoneAttributes", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "DeviceProperties");
        }
    }

    protected void updateLed() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "DeviceProperties", "GetLEDState", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "DeviceProperties");
        }
    }

    protected void updateTime() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AlarmClock", "GetTimeNow", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AlarmClock");
        }
    }

    protected void updatePosition() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "GetPositionInfo", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    protected void updateRunningAlarmProperties() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "GetRunningAlarmProperties", null);
        String alarmID = (String)result.get("AlarmID");
        String loggedStartTime = (String)result.get("LoggedStartTime");
        String newStringValue = null;
        newStringValue = alarmID != null && loggedStartTime != null ? String.valueOf(alarmID) + " - " + loggedStartTime : "No running alarm";
        result.put("RunningAlarmProperties", newStringValue);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    protected void updateZoneInfo() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "DeviceProperties", "GetZoneInfo", null);
        Map result2 = this.service.invokeAction((UpnpIOParticipant)this, "DeviceProperties", "GetZoneAttributes", null);
        result.putAll(result2);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "DeviceProperties");
        }
        Map properties = this.editProperties();
        boolean update = false;
        if (StringUtils.isNotEmpty((String)this.stateMap.get("HardwareVersion")) && !this.stateMap.get("HardwareVersion").equals(properties.get("hardwareVersion"))) {
            update = true;
            properties.put("hardwareVersion", this.stateMap.get("HardwareVersion"));
        }
        if (StringUtils.isNotEmpty((String)this.stateMap.get("DisplaySoftwareVersion")) && !this.stateMap.get("DisplaySoftwareVersion").equals(properties.get("firmwareVersion"))) {
            update = true;
            properties.put("firmwareVersion", this.stateMap.get("DisplaySoftwareVersion"));
        }
        if (StringUtils.isNotEmpty((String)this.stateMap.get("SerialNumber")) && !this.stateMap.get("SerialNumber").equals(properties.get("serialNumber"))) {
            update = true;
            properties.put("serialNumber", this.stateMap.get("SerialNumber"));
        }
        if (StringUtils.isNotEmpty((String)this.stateMap.get("MACAddress")) && !this.stateMap.get("MACAddress").equals(properties.get("macAddress"))) {
            update = true;
            properties.put("macAddress", this.stateMap.get("MACAddress"));
        }
        if (StringUtils.isNotEmpty((String)this.stateMap.get("IPAddress")) && !this.stateMap.get("IPAddress").equals(properties.get("ipAddress"))) {
            update = true;
            properties.put("ipAddress", this.stateMap.get("IPAddress"));
        }
        if (update) {
            this.updateProperties(properties);
        }
    }

    public String getCoordinator() {
        if (this.stateMap.get("ZoneGroupState") != null) {
            List<SonosZoneGroup> zoneGroups = SonosXMLParser.getZoneGroupFromXML(this.stateMap.get("ZoneGroupState"));
            for (SonosZoneGroup zg : zoneGroups) {
                if (!zg.getMembers().contains(this.getUDN())) continue;
                return zg.getCoordinator();
            }
        }
        return this.getUDN();
    }

    public boolean isCoordinator() {
        return this.getUDN().equals(this.getCoordinator());
    }

    protected void updateMediaInformation() {
        String currentURI = this.getCurrentURI();
        SonosMetaData currentTrack = this.getTrackMetadata();
        SonosMetaData currentUriMetaData = this.getCurrentURIMetadata();
        String artist = null;
        String album = null;
        String title = null;
        String resultString = null;
        String stationID = null;
        boolean needsUpdating = false;
        if (currentURI != null) {
            if (currentURI.isEmpty()) {
                needsUpdating = true;
            } else if (this.isPlayingStream(currentURI)) {
                boolean opmlUrlSucceeded = false;
                stationID = StringUtils.substringBetween((String)currentURI, (String)":s", (String)"?sid");
                if (this.opmlUrl != null) {
                    String mac = this.getMACAddress();
                    if (stationID != null && !stationID.isEmpty() && mac != null && !mac.isEmpty()) {
                        List<String> fields;
                        String url = this.opmlUrl;
                        url = StringUtils.replace((String)url, (String)"%id", (String)stationID);
                        url = StringUtils.replace((String)url, (String)"%serial", (String)mac);
                        String response = null;
                        try {
                            response = HttpUtil.executeUrl((String)"GET", (String)url, (int)5000);
                        }
                        catch (IOException e) {
                            this.logger.debug("Request to device failed: {}", (Throwable)e);
                        }
                        if (response != null && (fields = SonosXMLParser.getRadioTimeFromXML(response)) != null && fields.size() > 0) {
                            opmlUrlSucceeded = true;
                            resultString = new String();
                            title = fields.get(0);
                            ListIterator<String> listIterator = fields.listIterator();
                            while (listIterator.hasNext()) {
                                String field = (String)listIterator.next();
                                resultString = String.valueOf(resultString) + field;
                                if (!listIterator.hasNext()) continue;
                                resultString = String.valueOf(resultString) + " - ";
                            }
                            needsUpdating = true;
                        }
                    }
                }
                if (!opmlUrlSucceeded && currentUriMetaData != null) {
                    title = currentUriMetaData.getTitle();
                    resultString = currentTrack == null || currentTrack.getStreamContent() == null || currentTrack.getStreamContent().isEmpty() ? title : String.valueOf(title) + " - " + currentTrack.getStreamContent();
                    needsUpdating = true;
                }
            } else if (this.isPlayingLineIn(currentURI)) {
                if (currentTrack != null) {
                    resultString = title = currentTrack.getTitle();
                    needsUpdating = true;
                }
            } else if ((this.isPlayingRadio(currentURI) || !currentURI.contains("x-rincon-mp3") && !currentURI.contains("x-sonosapi")) && currentTrack != null) {
                artist = !currentTrack.getAlbumArtist().isEmpty() ? currentTrack.getAlbumArtist() : currentTrack.getCreator();
                album = currentTrack.getAlbum();
                title = currentTrack.getTitle();
                resultString = String.valueOf(artist) + " - " + album + " - " + title;
                needsUpdating = true;
            }
        }
        String albumArtURI = currentTrack != null && currentTrack.getAlbumArtUri() != null && !currentTrack.getAlbumArtUri().isEmpty() ? currentTrack.getAlbumArtUri() : "";
        ZonePlayerHandler handlerForImageUpdate = null;
        for (String member : this.getZoneGroupMembers()) {
            try {
                ZonePlayerHandler memberHandler = this.getHandlerByName(member);
                if (memberHandler == null || !ThingStatus.ONLINE.equals((Object)memberHandler.getThing().getStatus())) continue;
                if (memberHandler.isLinked("currentalbumart") && this.hasValueChanged(albumArtURI, memberHandler.stateMap.get("CurrentAlbumArtURI"))) {
                    handlerForImageUpdate = memberHandler;
                }
                memberHandler.onValueReceived("CurrentTuneInStationId", stationID != null ? stationID : "", "AVTransport");
                if (!needsUpdating) continue;
                memberHandler.onValueReceived("CurrentArtist", artist != null ? artist : "", "AVTransport");
                memberHandler.onValueReceived("CurrentAlbum", album != null ? album : "", "AVTransport");
                memberHandler.onValueReceived("CurrentTitle", title != null ? title : "", "AVTransport");
                memberHandler.onValueReceived("CurrentURIFormatted", resultString != null ? resultString : "", "AVTransport");
                memberHandler.onValueReceived("CurrentAlbumArtURI", albumArtURI, "AVTransport");
            }
            catch (IllegalStateException e) {
                this.logger.debug("Cannot update media data for group member ({})", (Object)e.getMessage());
            }
        }
        if (needsUpdating && handlerForImageUpdate != null) {
            super.updateAlbumArtChannel(true);
        }
    }

    public boolean isGroupCoordinator() {
        String value = this.stateMap.get("GroupCoordinatorIsLocal");
        if (value != null) {
            return value.equals("true");
        }
        return false;
    }

    public String getUDN() {
        return ((ZonePlayerConfiguration)this.getConfigAs(ZonePlayerConfiguration.class)).udn;
    }

    public String getCurrentURI() {
        return this.stateMap.get("CurrentURI");
    }

    public SonosMetaData getCurrentURIMetadata() {
        if (this.stateMap.get("CurrentURIMetaData") != null && !this.stateMap.get("CurrentURIMetaData").isEmpty()) {
            return SonosXMLParser.getMetaDataFromXML(this.stateMap.get("CurrentURIMetaData"));
        }
        return null;
    }

    public SonosMetaData getTrackMetadata() {
        if (this.stateMap.get("CurrentTrackMetaData") != null && !this.stateMap.get("CurrentTrackMetaData").isEmpty()) {
            return SonosXMLParser.getMetaDataFromXML(this.stateMap.get("CurrentTrackMetaData"));
        }
        return null;
    }

    public SonosMetaData getEnqueuedTransportURIMetaData() {
        if (this.stateMap.get("EnqueuedTransportURIMetaData") != null && !this.stateMap.get("EnqueuedTransportURIMetaData").isEmpty()) {
            return SonosXMLParser.getMetaDataFromXML(this.stateMap.get("EnqueuedTransportURIMetaData"));
        }
        return null;
    }

    public String getMACAddress() {
        if (StringUtils.isEmpty((String)this.stateMap.get("MACAddress"))) {
            this.updateZoneInfo();
        }
        return this.stateMap.get("MACAddress");
    }

    public String getPosition() {
        this.updatePosition();
        return this.stateMap.get("RelTime");
    }

    public long getCurrenTrackNr() {
        this.updatePosition();
        String value = this.stateMap.get("Track");
        if (value != null) {
            return Long.valueOf(value);
        }
        return -1L;
    }

    public String getVolume() {
        return this.stateMap.get("VolumeMaster");
    }

    public String getTransportState() {
        return this.stateMap.get("TransportState");
    }

    public List<SonosEntry> getArtists(String filter) {
        return this.getEntries("A:", filter);
    }

    public List<SonosEntry> getArtists() {
        return this.getEntries("A:", "dc:title,res,dc:creator,upnp:artist,upnp:album");
    }

    public List<SonosEntry> getAlbums(String filter) {
        return this.getEntries("A:ALBUM", filter);
    }

    public List<SonosEntry> getAlbums() {
        return this.getEntries("A:ALBUM", "dc:title,res,dc:creator,upnp:artist,upnp:album");
    }

    public List<SonosEntry> getTracks(String filter) {
        return this.getEntries("A:TRACKS", filter);
    }

    public List<SonosEntry> getTracks() {
        return this.getEntries("A:TRACKS", "dc:title,res,dc:creator,upnp:artist,upnp:album");
    }

    public List<SonosEntry> getQueue(String filter) {
        return this.getEntries("Q:0", filter);
    }

    public List<SonosEntry> getQueue() {
        return this.getEntries("Q:0", "dc:title,res,dc:creator,upnp:artist,upnp:album");
    }

    public long getQueueSize() {
        return this.getNbEntries("Q:0");
    }

    public List<SonosEntry> getPlayLists(String filter) {
        return this.getEntries("SQ:", filter);
    }

    public List<SonosEntry> getPlayLists() {
        return this.getEntries("SQ:", "dc:title,res,dc:creator,upnp:artist,upnp:album");
    }

    public List<SonosEntry> getFavoriteRadios(String filter) {
        return this.getEntries("R:0/0", filter);
    }

    public List<SonosEntry> getFavoriteRadios() {
        return this.getEntries("R:0/0", "dc:title,res,dc:creator,upnp:artist,upnp:album");
    }

    public List<SonosEntry> getFavorites() {
        return this.getEntries("FV:2", "dc:title,res,dc:creator,upnp:artist,upnp:album");
    }

    protected List<SonosEntry> getEntries(String type, String filter) {
        long startAt = 0L;
        HashMap<String, String> inputs = new HashMap<String, String>();
        inputs.put("ObjectID", type);
        inputs.put("BrowseFlag", "BrowseDirectChildren");
        inputs.put("Filter", filter);
        inputs.put("StartingIndex", Long.toString(startAt));
        inputs.put("RequestedCount", Integer.toString(200));
        inputs.put("SortCriteria", "");
        List<SonosEntry> resultList = null;
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "ContentDirectory", "Browse", inputs);
        long totalMatches = this.getResultEntry(result, "TotalMatches", type, filter);
        long initialNumberReturned = this.getResultEntry(result, "NumberReturned", type, filter);
        String initialResult = (String)result.get("Result");
        resultList = SonosXMLParser.getEntriesFromString(initialResult);
        startAt += initialNumberReturned;
        while (startAt < totalMatches) {
            inputs.put("StartingIndex", Long.toString(startAt));
            result = this.service.invokeAction((UpnpIOParticipant)this, "ContentDirectory", "Browse", inputs);
            String nextResult = (String)result.get("Result");
            long numberReturned = this.getResultEntry(result, "NumberReturned", type, filter);
            resultList.addAll(SonosXMLParser.getEntriesFromString(nextResult));
            startAt += numberReturned;
        }
        return resultList;
    }

    protected long getNbEntries(String type) {
        HashMap<String, String> inputs = new HashMap<String, String>();
        inputs.put("ObjectID", type);
        inputs.put("BrowseFlag", "BrowseDirectChildren");
        inputs.put("Filter", "dc:title");
        inputs.put("StartingIndex", "0");
        inputs.put("RequestedCount", "1");
        inputs.put("SortCriteria", "");
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "ContentDirectory", "Browse", inputs);
        return this.getResultEntry(result, "TotalMatches", type, "dc:title");
    }

    private Long getResultEntry(Map<String, String> resultInput, String requestedKey, String entriesType, String entriesFilter) {
        long result = 0L;
        if (resultInput.isEmpty()) {
            return result;
        }
        try {
            result = Long.valueOf(resultInput.get(requestedKey));
        }
        catch (NumberFormatException ex) {
            this.logger.debug("Could not fetch {} result for type: {} and filter: {}. Using default value '0': {}", new Object[]{requestedKey, entriesType, entriesFilter, ex.getMessage(), ex});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveState() {
        Object object = this.stateLock;
        synchronized (object) {
            this.savedState = new SonosZonePlayerState();
            String currentURI = this.getCurrentURI();
            this.savedState.transportState = this.getTransportState();
            this.savedState.volume = this.getVolume();
            if (currentURI != null) {
                if (this.isPlayingStream(currentURI) || this.isPlayingRadio(currentURI)) {
                    SonosMetaData track = this.getTrackMetadata();
                    SonosMetaData current = this.getCurrentURIMetadata();
                    if (track != null && current != null) {
                        this.savedState.entry = new SonosEntry("", current.getTitle(), "", "", track.getAlbumArtUri(), "", current.getUpnpClass(), currentURI);
                    }
                } else if (currentURI.contains(GROUP_URI)) {
                    this.savedState.entry = new SonosEntry("", "", "", "", "", "", "", currentURI);
                } else if (this.isPlayingLineIn(currentURI)) {
                    this.savedState.entry = new SonosEntry("", "", "", "", "", "", "", currentURI);
                } else if (this.isPlayingQueue(currentURI)) {
                    SonosMetaData queued = this.getEnqueuedTransportURIMetaData();
                    if (queued != null) {
                        this.savedState.track = this.getCurrenTrackNr();
                        if (queued.getUpnpClass().contains("object.container.playlistContainer")) {
                            List<SonosEntry> playLists = this.getPlayLists();
                            for (SonosEntry someList : playLists) {
                                if (!someList.getTitle().equals(queued.getTitle())) continue;
                                this.savedState.entry = new SonosEntry(someList.getId(), someList.getTitle(), someList.getParentId(), "", "", "", someList.getUpnpClass(), someList.getRes());
                                break;
                            }
                        } else if (queued.getUpnpClass().contains("object.container")) {
                            this.logger.debug("Save State for a container of type {}", (Object)queued.getUpnpClass());
                            String existingList = "";
                            List<SonosEntry> playLists = this.getPlayLists();
                            for (SonosEntry someList : playLists) {
                                if (!someList.getTitle().equals("smarthome-" + this.getUDN())) continue;
                                existingList = someList.getId();
                                break;
                            }
                            this.saveQueue("smarthome-" + this.getUDN(), existingList);
                            playLists = this.getPlayLists();
                            for (SonosEntry someList : playLists) {
                                if (!someList.getTitle().equals("smarthome-" + this.getUDN())) continue;
                                this.savedState.entry = new SonosEntry(someList.getId(), someList.getTitle(), someList.getParentId(), "", "", "", someList.getUpnpClass(), someList.getRes());
                                break;
                            }
                        }
                    } else {
                        this.savedState.entry = new SonosEntry("", "", "", "", "", "", "", QUEUE_URI + this.getUDN() + "#0");
                    }
                }
                this.savedState.relTime = this.getPosition();
            } else {
                this.savedState.entry = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreState() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.savedState != null) {
                if (this.savedState.volume != null) {
                    this.setVolume((Command)DecimalType.valueOf((String)this.savedState.volume));
                }
                if (this.isCoordinator()) {
                    if (this.savedState.entry != null) {
                        if (this.savedState.entry.getUpnpClass().contains("object.container.playlistContainer")) {
                            this.addURIToQueue(this.savedState.entry.getRes(), SonosXMLParser.compileMetadataString(this.savedState.entry), 0L, true);
                            SonosEntry entry = new SonosEntry("", "", "", "", "", "", "", QUEUE_URI + this.getUDN() + "#0");
                            this.setCurrentURI(entry);
                            this.setPositionTrack(this.savedState.track);
                        } else {
                            this.setCurrentURI(this.savedState.entry);
                            this.setPosition(this.savedState.relTime);
                        }
                    }
                    if (this.savedState.transportState != null) {
                        if (this.savedState.transportState.equals(STATE_PLAYING)) {
                            this.play();
                        } else if (this.savedState.transportState.equals(STATE_STOPPED)) {
                            this.stop();
                        } else if (this.savedState.transportState.equals(STATE_PAUSED_PLAYBACK)) {
                            this.pause();
                        }
                    }
                }
            }
        }
    }

    public void saveQueue(String name, String queueID) {
        if (name != null && queueID != null) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            inputs.put("Title", name);
            inputs.put("ObjectID", queueID);
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "SaveQueue", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
            }
        }
    }

    public void setVolume(Command command) {
        if (command != null && (command instanceof OnOffType || command instanceof IncreaseDecreaseType || command instanceof DecimalType || command instanceof PercentType)) {
            int i;
            HashMap<String, String> inputs = new HashMap<String, String>();
            String newValue = null;
            if (command instanceof IncreaseDecreaseType && command == IncreaseDecreaseType.INCREASE) {
                i = Integer.valueOf(this.getVolume());
                newValue = String.valueOf(Math.min(100, i + 1));
            } else if (command instanceof IncreaseDecreaseType && command == IncreaseDecreaseType.DECREASE) {
                i = Integer.valueOf(this.getVolume());
                newValue = String.valueOf(Math.max(0, i - 1));
            } else if (command instanceof OnOffType && command == OnOffType.ON) {
                newValue = "100";
            } else if (command instanceof OnOffType && command == OnOffType.OFF) {
                newValue = "0";
            } else if (command instanceof DecimalType) {
                newValue = String.valueOf(((DecimalType)command).intValue());
            } else {
                return;
            }
            inputs.put("Channel", "Master");
            inputs.put("DesiredVolume", newValue);
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "RenderingControl", "SetVolume", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "RenderingControl");
            }
        }
    }

    public void setVolumeForGroup(Command command) {
        if (this.isAdHocGroup() || this.isStandalonePlayer()) {
            this.setVolume(command);
        } else {
            try {
                this.getCoordinatorHandler().setVolume(command);
            }
            catch (IllegalStateException e) {
                this.logger.debug("Cannot set group volume ({})", (Object)e.getMessage());
            }
        }
    }

    private boolean isAdHocGroup() {
        List<String> zoneGroupMemberNames;
        SonosZoneGroup currentZoneGroup = this.getCurrentZoneGroup();
        if (currentZoneGroup != null && (zoneGroupMemberNames = currentZoneGroup.getMemberZoneNames()) != null) {
            for (String zoneName : zoneGroupMemberNames) {
                if (zoneName.equals(zoneGroupMemberNames.get(0))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStandalonePlayer() {
        return this.getCurrentZoneGroup() != null ? this.getCurrentZoneGroup().getMembers().size() == 1 : true;
    }

    private SonosZoneGroup getCurrentZoneGroup() {
        String zoneGroupState = this.stateMap.get("ZoneGroupState");
        if (zoneGroupState != null) {
            List<SonosZoneGroup> zoneGroups = SonosXMLParser.getZoneGroupFromXML(zoneGroupState);
            for (SonosZoneGroup zoneGroup : zoneGroups) {
                if (!zoneGroup.getMembers().contains(this.getUDN())) continue;
                return zoneGroup;
            }
        }
        this.logger.debug("Could not fetch Sonos group state information");
        return null;
    }

    public void setNotificationSoundVolume(PercentType notificationSoundVolume) {
        if (notificationSoundVolume != null) {
            this.setVolumeForGroup((Command)notificationSoundVolume);
        }
    }

    public PercentType getNotificationSoundVolume() {
        Integer notificationSoundVolume = ((ZonePlayerConfiguration)this.getConfigAs(ZonePlayerConfiguration.class)).notificationVolume;
        if (notificationSoundVolume == null) {
            String volume = this.getVolume();
            return volume != null ? new PercentType(volume) : null;
        }
        return new PercentType(notificationSoundVolume.intValue());
    }

    public void addURIToQueue(String URI2, String meta, long desiredFirstTrack, boolean enqueueAsNext) {
        if (URI2 != null && meta != null) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            try {
                inputs.put("InstanceID", "0");
                inputs.put("EnqueuedURI", URI2);
                inputs.put("EnqueuedURIMetaData", meta);
                inputs.put("DesiredFirstTrackNumberEnqueued", Long.toString(desiredFirstTrack));
                inputs.put("EnqueueAsNext", Boolean.toString(enqueueAsNext));
            }
            catch (NumberFormatException ex) {
                this.logger.debug("Action Invalid Value Format Exception {}", (Object)ex.getMessage());
            }
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "AddURIToQueue", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
            }
        }
    }

    public void setCurrentURI(SonosEntry newEntry) {
        this.setCurrentURI(newEntry.getRes(), SonosXMLParser.compileMetadataString(newEntry));
    }

    public void setCurrentURI(String URI2, String URIMetaData) {
        if (URI2 != null && URIMetaData != null) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            try {
                inputs.put("InstanceID", "0");
                inputs.put("CurrentURI", URI2);
                inputs.put("CurrentURIMetaData", URIMetaData);
            }
            catch (NumberFormatException ex) {
                this.logger.debug("Action Invalid Value Format Exception {}", (Object)ex.getMessage());
            }
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "SetAVTransportURI", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
            }
        }
    }

    public void setPosition(String relTime) {
        this.seek("REL_TIME", relTime);
    }

    public void setPositionTrack(long tracknr) {
        this.seek("TRACK_NR", Long.toString(tracknr));
    }

    public void setPositionTrack(String tracknr) {
        this.seek("TRACK_NR", tracknr);
    }

    protected void seek(String unit, String target) {
        if (unit != null && target != null) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            try {
                inputs.put("InstanceID", "0");
                inputs.put("Unit", unit);
                inputs.put("Target", target);
            }
            catch (NumberFormatException ex) {
                this.logger.debug("Action Invalid Value Format Exception {}", (Object)ex.getMessage());
            }
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "Seek", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
            }
        }
    }

    public void play() {
        HashMap<String, String> inputs = new HashMap<String, String>();
        inputs.put("Speed", "1");
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "Play", inputs);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    public void stop() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "Stop", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    public void pause() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "Pause", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    public void setShuffle(Command command) {
        block28: {
            if (command == null || !(command instanceof OnOffType) && !(command instanceof OpenClosedType) && !(command instanceof UpDownType)) break block28;
            try {
                ZonePlayerHandler coordinator;
                block29: {
                    coordinator = this.getCoordinatorHandler();
                    if (!command.equals(OnOffType.ON) && !command.equals(UpDownType.UP) && !command.equals(OpenClosedType.OPEN)) break block29;
                    switch (coordinator.getRepeatMode()) {
                        case "ALL": {
                            coordinator.updatePlayMode("SHUFFLE");
                            break;
                        }
                        case "ONE": {
                            coordinator.updatePlayMode("SHUFFLE_REPEAT_ONE");
                            break;
                        }
                        case "OFF": {
                            coordinator.updatePlayMode("SHUFFLE_NOREPEAT");
                        }
                    }
                    break block28;
                }
                if (!command.equals(OnOffType.OFF) && !command.equals(UpDownType.DOWN) && !command.equals(OpenClosedType.CLOSED)) break block28;
                switch (coordinator.getRepeatMode()) {
                    case "ALL": {
                        coordinator.updatePlayMode("REPEAT_ALL");
                        break;
                    }
                    case "ONE": {
                        coordinator.updatePlayMode("REPEAT_ONE");
                        break;
                    }
                    case "OFF": {
                        coordinator.updatePlayMode("NORMAL");
                    }
                }
            }
            catch (IllegalStateException e) {
                this.logger.debug("Cannot handle shuffle command ({})", (Object)e.getMessage());
            }
        }
    }

    public void setRepeat(Command command) {
        block15: {
            if (command == null || !(command instanceof StringType)) break block15;
            try {
                ZonePlayerHandler coordinator = this.getCoordinatorHandler();
                switch (command.toString()) {
                    case "ALL": {
                        coordinator.updatePlayMode(coordinator.isShuffleActive() != false ? "SHUFFLE" : "REPEAT_ALL");
                        break;
                    }
                    case "ONE": {
                        coordinator.updatePlayMode(coordinator.isShuffleActive() != false ? "SHUFFLE_REPEAT_ONE" : "REPEAT_ONE");
                        break;
                    }
                    case "OFF": {
                        coordinator.updatePlayMode(coordinator.isShuffleActive() != false ? "SHUFFLE_NOREPEAT" : "NORMAL");
                        break;
                    }
                    default: {
                        this.logger.debug("{}: unexpected repeat command; accepted values are ALL, ONE and OFF", (Object)command.toString());
                        break;
                    }
                }
            }
            catch (IllegalStateException e) {
                this.logger.debug("Cannot handle repeat command ({})", (Object)e.getMessage());
            }
        }
    }

    public Boolean isShuffleActive() {
        return this.stateMap.get("CurrentPlayMode") != null && this.stateMap.get("CurrentPlayMode").startsWith("SHUFFLE");
    }

    /*
     * Exception decompiling
     */
    public String getRepeatMode() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[8] lbl46 : CaseStatement: default:\u000a, @NONE, blocks:[8] lbl46 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updatePlayMode(String playMode) {
        HashMap<String, String> inputs = new HashMap<String, String>();
        inputs.put("InstanceID", "0");
        inputs.put("NewPlayMode", playMode);
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "SetPlayMode", inputs);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    public void removeAllTracksFromQueue() {
        HashMap<String, String> inputs = new HashMap<String, String>();
        inputs.put("InstanceID", "0");
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "RemoveAllTracksFromQueue", inputs);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    public void playLineIn(Command command) {
        if (command != null && command instanceof StringType) {
            try {
                String remotePlayerName = command.toString();
                ZonePlayerHandler coordinatorHandler = this.getCoordinatorHandler();
                ZonePlayerHandler remoteHandler = this.getHandlerByName(remotePlayerName);
                if (remoteHandler.isAnalogLineInConnected().booleanValue() || remoteHandler.isOpticalLineInConnected().booleanValue()) {
                    coordinatorHandler.stop();
                    if (remoteHandler.isAnalogLineInConnected().booleanValue()) {
                        coordinatorHandler.setCurrentURI(ANALOG_LINE_IN_URI + remoteHandler.getUDN(), "");
                    } else {
                        coordinatorHandler.setCurrentURI(OPTICAL_LINE_IN_URI + remoteHandler.getUDN() + SPDIF, "");
                    }
                    coordinatorHandler.setMute((Command)OnOffType.OFF);
                    coordinatorHandler.play();
                } else {
                    this.logger.debug("Line-in of {} is not connected", (Object)remoteHandler.getUDN());
                }
            }
            catch (IllegalStateException e) {
                this.logger.debug("Cannot play line-in ({})", (Object)e.getMessage());
            }
        }
    }

    private ZonePlayerHandler getCoordinatorHandler() throws IllegalStateException {
        if (this.coordinatorHandler == null) {
            try {
                this.coordinatorHandler = this.getHandlerByName(this.getCoordinator());
            }
            catch (IllegalStateException illegalStateException) {
                this.coordinatorHandler = null;
                throw new IllegalStateException("Missing group coordinator " + this.getCoordinator());
            }
        }
        return this.coordinatorHandler;
    }

    protected List<String> getZoneGroupMembers() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.stateMap.get("ZoneGroupState") != null) {
            List<SonosZoneGroup> zoneGroups = SonosXMLParser.getZoneGroupFromXML(this.stateMap.get("ZoneGroupState"));
            for (SonosZoneGroup zg : zoneGroups) {
                if (!zg.getMembers().contains(this.getUDN())) continue;
                result.addAll(zg.getMembers());
                break;
            }
        } else {
            result.add(this.getUDN());
        }
        return result;
    }

    protected List<String> getOtherZoneGroupMembers() {
        List<String> zoneGroupMembers = this.getZoneGroupMembers();
        zoneGroupMembers.remove(this.getUDN());
        return zoneGroupMembers;
    }

    protected ZonePlayerHandler getHandlerByName(String remotePlayerName) throws IllegalStateException {
        if (this.thingRegistry != null) {
            for (ThingTypeUID supportedThingType : SonosBindingConstants.SUPPORTED_THING_TYPES_UIDS) {
                Thing thing = this.thingRegistry.get(new ThingUID(supportedThingType, remotePlayerName));
                if (thing == null) continue;
                return (ZonePlayerHandler)thing.getHandler();
            }
            Collection allThings = this.thingRegistry.getAll();
            for (Thing aThing : allThings) {
                if (!SonosBindingConstants.SUPPORTED_THING_TYPES_UIDS.contains(aThing.getThingTypeUID()) || !aThing.getConfiguration().get("udn").equals(remotePlayerName)) continue;
                return (ZonePlayerHandler)aThing.getHandler();
            }
        }
        throw new IllegalStateException("Could not find handler for " + remotePlayerName);
    }

    public void setMute(Command command) {
        if (command != null && (command instanceof OnOffType || command instanceof OpenClosedType || command instanceof UpDownType)) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            inputs.put("Channel", "Master");
            if (command.equals(OnOffType.ON) || command.equals(UpDownType.UP) || command.equals(OpenClosedType.OPEN)) {
                inputs.put("DesiredMute", "True");
            } else if (command.equals(OnOffType.OFF) || command.equals(UpDownType.DOWN) || command.equals(OpenClosedType.CLOSED)) {
                inputs.put("DesiredMute", "False");
            }
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "RenderingControl", "SetMute", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "RenderingControl");
            }
        }
    }

    public List<SonosAlarm> getCurrentAlarmList() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AlarmClock", "ListAlarms", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AlarmClock");
        }
        return SonosXMLParser.getAlarmsFromStringResult((String)result.get("CurrentAlarmList"));
    }

    public void updateAlarm(SonosAlarm alarm) {
        if (alarm != null) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            try {
                inputs.put("ID", Integer.toString(alarm.getID()));
                inputs.put("StartLocalTime", alarm.getStartTime());
                inputs.put("Duration", alarm.getDuration());
                inputs.put("Recurrence", alarm.getRecurrence());
                inputs.put("RoomUUID", alarm.getRoomUUID());
                inputs.put("ProgramURI", alarm.getProgramURI());
                inputs.put("ProgramMetaData", alarm.getProgramMetaData());
                inputs.put("PlayMode", alarm.getPlayMode());
                inputs.put("Volume", Integer.toString(alarm.getVolume()));
                if (alarm.getIncludeLinkedZones()) {
                    inputs.put("IncludeLinkedZones", "1");
                } else {
                    inputs.put("IncludeLinkedZones", "0");
                }
                if (alarm.getEnabled()) {
                    inputs.put("Enabled", "1");
                } else {
                    inputs.put("Enabled", "0");
                }
            }
            catch (NumberFormatException ex) {
                this.logger.debug("Action Invalid Value Format Exception {}", (Object)ex.getMessage());
            }
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "AlarmClock", "UpdateAlarm", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "AlarmClock");
            }
        }
    }

    public void setAlarm(Command command) {
        if (command instanceof OnOffType || command instanceof OpenClosedType || command instanceof UpDownType) {
            if (command.equals(OnOffType.ON) || command.equals(UpDownType.UP) || command.equals(OpenClosedType.OPEN)) {
                this.setAlarm(true);
            } else if (command.equals(OnOffType.OFF) || command.equals(UpDownType.DOWN) || command.equals(OpenClosedType.CLOSED)) {
                this.setAlarm(false);
            }
        }
    }

    public void setAlarm(boolean alarmSwitch) {
        List<SonosAlarm> sonosAlarms = this.getCurrentAlarmList();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        String currentLocalTime = this.getTime();
        Date currentDateTime = null;
        try {
            currentDateTime = fmt.parse(currentLocalTime);
        }
        catch (ParseException e) {
            this.logger.debug("An exception occurred while formatting a date", (Throwable)e);
        }
        if (currentDateTime != null) {
            Calendar currentDateTimeCalendar = Calendar.getInstance();
            currentDateTimeCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            currentDateTimeCalendar.setTime(currentDateTime);
            currentDateTimeCalendar.add(6, 10);
            long shortestDuration = currentDateTimeCalendar.getTimeInMillis() - currentDateTime.getTime();
            SonosAlarm firstAlarm = null;
            for (SonosAlarm anAlarm : sonosAlarms) {
                Date durationDate;
                SimpleDateFormat durationFormat = new SimpleDateFormat("HH:mm:ss");
                durationFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                try {
                    durationDate = durationFormat.parse(anAlarm.getDuration());
                }
                catch (ParseException e) {
                    this.logger.debug("An exception occurred while parsing a date : '{}'", (Object)e.getMessage());
                    continue;
                }
                long duration = durationDate.getTime();
                if (duration >= shortestDuration || !anAlarm.getRoomUUID().equals(this.getUDN())) continue;
                shortestDuration = duration;
                firstAlarm = anAlarm;
            }
            if (firstAlarm != null) {
                if (alarmSwitch) {
                    firstAlarm.setEnabled(true);
                } else {
                    firstAlarm.setEnabled(false);
                }
                this.updateAlarm(firstAlarm);
            }
        }
    }

    public String getTime() {
        this.updateTime();
        return this.stateMap.get("CurrentLocalTime");
    }

    public Boolean isAlarmRunning() {
        return this.stateMap.get("AlarmRunning") != null && this.stateMap.get("AlarmRunning").equals("1");
    }

    public void snoozeAlarm(Command command) {
        if (this.isAlarmRunning().booleanValue() && command instanceof DecimalType) {
            int minutes = ((DecimalType)command).intValue();
            HashMap<String, String> inputs = new HashMap<String, String>();
            Calendar snoozePeriod = Calendar.getInstance();
            snoozePeriod.setTimeZone(TimeZone.getTimeZone("GMT"));
            snoozePeriod.setTimeInMillis(0L);
            snoozePeriod.add(12, minutes);
            SimpleDateFormat pFormatter = new SimpleDateFormat("HH:mm:ss");
            pFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                inputs.put("Duration", pFormatter.format(snoozePeriod.getTime()));
            }
            catch (NumberFormatException ex) {
                this.logger.debug("Action Invalid Value Format Exception {}", (Object)ex.getMessage());
            }
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "SnoozeAlarm", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
            }
        } else {
            this.logger.debug("There is no alarm running on {}", (Object)this.getUDN());
        }
    }

    public Boolean isAnalogLineInConnected() {
        return this.stateMap.get("LineInConnected") != null && this.stateMap.get("LineInConnected").equals("true");
    }

    public Boolean isOpticalLineInConnected() {
        return this.stateMap.get("TOSLinkConnected") != null && this.stateMap.get("TOSLinkConnected").equals("true");
    }

    public void becomeStandAlonePlayer() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "BecomeCoordinatorOfStandaloneGroup", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    public void addMember(Command command) {
        if (command != null && command instanceof StringType) {
            SonosEntry entry = new SonosEntry("", "", "", "", "", "", "", GROUP_URI + this.getUDN());
            try {
                this.getHandlerByName(command.toString()).setCurrentURI(entry);
            }
            catch (IllegalStateException e) {
                this.logger.debug("Cannot add group member ({})", (Object)e.getMessage());
            }
        }
    }

    public boolean publicAddress() {
        if (this.isAnalogLineInConnected().booleanValue() || this.isOpticalLineInConnected().booleanValue()) {
            this.becomeStandAlonePlayer();
            ArrayList<SonosZoneGroup> currentSonosZoneGroups = new ArrayList<SonosZoneGroup>();
            for (SonosZoneGroup grp : SonosXMLParser.getZoneGroupFromXML(this.stateMap.get("ZoneGroupState"))) {
                currentSonosZoneGroups.add((SonosZoneGroup)grp.clone());
            }
            for (SonosZoneGroup group : currentSonosZoneGroups) {
                for (String player : group.getMembers()) {
                    try {
                        ZonePlayerHandler somePlayer = this.getHandlerByName(player);
                        if (somePlayer == this) continue;
                        somePlayer.becomeStandAlonePlayer();
                        somePlayer.stop();
                        this.addMember((Command)StringType.valueOf((String)somePlayer.getUDN()));
                    }
                    catch (IllegalStateException e) {
                        this.logger.debug("Cannot add to group ({})", (Object)e.getMessage());
                    }
                }
            }
            try {
                ZonePlayerHandler coordinator = this.getCoordinatorHandler();
                SonosEntry entry = new SonosEntry("", "", "", "", "", "", "", ANALOG_LINE_IN_URI + this.getUDN());
                if (this.isOpticalLineInConnected().booleanValue()) {
                    entry = new SonosEntry("", "", "", "", "", "", "", OPTICAL_LINE_IN_URI + this.getUDN() + SPDIF);
                }
                coordinator.setCurrentURI(entry);
                coordinator.play();
                return true;
            }
            catch (IllegalStateException e) {
                this.logger.debug("Cannot handle command ({})", (Object)e.getMessage());
                return false;
            }
        }
        this.logger.debug("Line-in of {} is not connected", (Object)this.getUDN());
        return false;
    }

    public void playURI(Command command) {
        if (command != null && command instanceof StringType) {
            try {
                String url = command.toString();
                ZonePlayerHandler coordinator = this.getCoordinatorHandler();
                coordinator.stop();
                coordinator.waitForNotTransportState(STATE_PLAYING);
                coordinator.removeAllTracksFromQueue();
                if (!url.startsWith("x-") && !url.startsWith("http")) {
                    url = FILE_URI + url;
                }
                coordinator.addURIToQueue(url, "", 0L, true);
                coordinator.setCurrentURI(QUEUE_URI + coordinator.getUDN() + "#0", "");
                coordinator.setMute((Command)OnOffType.OFF);
                coordinator.play();
            }
            catch (IllegalStateException e) {
                this.logger.debug("Cannot play URI ({})", (Object)e.getMessage());
            }
        }
    }

    private void scheduleNotificationSound(Command command) {
        this.scheduler.submit(() -> {
            Object object = this.notificationLock;
            synchronized (object) {
                this.playNotificationSoundURI(command);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playNotificationSoundURI(Command notificationURL) {
        if (notificationURL != null && notificationURL instanceof StringType) {
            try {
                ZonePlayerHandler coordinator = this.getCoordinatorHandler();
                String currentURI = coordinator.getCurrentURI();
                if (this.isPlayingStream(currentURI) || this.isPlayingRadio(currentURI)) {
                    this.handleRadioStream(currentURI, notificationURL, coordinator);
                } else if (this.isPlayingLineIn(currentURI)) {
                    this.handleLineIn(currentURI, notificationURL, coordinator);
                } else if (this.isPlayingQueue(currentURI)) {
                    this.handleSharedQueue(notificationURL, coordinator);
                } else if (this.isPlaylistEmpty(coordinator)) {
                    this.handleEmptyQueue(notificationURL, coordinator);
                }
                Object object = this.notificationLock;
                synchronized (object) {
                    this.notificationLock.notify();
                }
            }
            catch (IllegalStateException e) {
                this.logger.debug("Cannot play sound ({})", (Object)e.getMessage());
            }
        }
    }

    private boolean isPlaylistEmpty(ZonePlayerHandler coordinator) {
        return coordinator.getQueueSize() == 0L;
    }

    private boolean isPlayingQueue(String currentURI) {
        if (currentURI == null) {
            return false;
        }
        return currentURI.contains(QUEUE_URI);
    }

    private boolean isPlayingStream(String currentURI) {
        if (currentURI == null) {
            return false;
        }
        return currentURI.contains(STREAM_URI);
    }

    private boolean isPlayingRadio(String currentURI) {
        if (currentURI == null) {
            return false;
        }
        return currentURI.contains(RADIO_URI);
    }

    private boolean isPlayingLineIn(String currentURI) {
        if (currentURI == null) {
            return false;
        }
        return currentURI.contains(ANALOG_LINE_IN_URI) || currentURI.startsWith(OPTICAL_LINE_IN_URI) && currentURI.endsWith(SPDIF);
    }

    private void handleRadioStream(String currentStreamURI, Command notificationURL, ZonePlayerHandler coordinator) {
        String nextAction = coordinator.getTransportState();
        SonosMetaData track = coordinator.getTrackMetadata();
        SonosMetaData currentURI = coordinator.getCurrentURIMetadata();
        if (track != null && currentURI != null) {
            this.handleNotificationSound(notificationURL, coordinator);
            coordinator.setCurrentURI(new SonosEntry("", currentURI.getTitle(), "", "", track.getAlbumArtUri(), "", currentURI.getUpnpClass(), currentStreamURI));
            this.restoreLastTransportState(coordinator, nextAction);
        }
    }

    private void handleLineIn(String currentLineInURI, Command notificationURL, ZonePlayerHandler coordinator) {
        String nextAction = coordinator.getTransportState();
        this.handleNotificationSound(notificationURL, coordinator);
        coordinator.setCurrentURI(currentLineInURI, "");
        this.restoreLastTransportState(coordinator, nextAction);
    }

    private void handleSharedQueue(Command notificationURL, ZonePlayerHandler coordinator) {
        String nextAction = coordinator.getTransportState();
        String trackPosition = coordinator.getPosition();
        long currentTrackNumber = coordinator.getCurrenTrackNr();
        this.handleNotificationSound(notificationURL, coordinator);
        coordinator.setPositionTrack(currentTrackNumber);
        coordinator.setPosition(trackPosition);
        this.restoreLastTransportState(coordinator, nextAction);
    }

    private void handleNotificationSound(Command notificationURL, ZonePlayerHandler coordinator) {
        String originalVolume = this.isAdHocGroup() || this.isStandalonePlayer() ? this.getVolume() : coordinator.getVolume();
        coordinator.stop();
        coordinator.waitForNotTransportState(STATE_PLAYING);
        this.applyNotificationSoundVolume();
        long notificationPosition = coordinator.getQueueSize() + 1L;
        coordinator.addURIToQueue(notificationURL.toString(), "", notificationPosition, false);
        coordinator.setCurrentURI(QUEUE_URI + coordinator.getUDN() + "#0", "");
        coordinator.setPositionTrack(notificationPosition);
        coordinator.play();
        coordinator.waitForFinishedNotification();
        if (originalVolume != null) {
            this.setVolumeForGroup((Command)DecimalType.valueOf((String)originalVolume));
        }
        coordinator.removeRangeOfTracksFromQueue((Command)new StringType(String.valueOf(Long.toString(notificationPosition)) + ",1"));
    }

    private void restoreLastTransportState(ZonePlayerHandler coordinator, String nextAction) {
        block10: {
            if (nextAction == null) break block10;
            switch (nextAction) {
                case "PLAYING": {
                    coordinator.play();
                    coordinator.waitForTransportState(STATE_PLAYING);
                    break;
                }
                case "PAUSED_PLAYBACK": {
                    coordinator.pause();
                }
            }
        }
    }

    private void handleEmptyQueue(Command notificationURL, ZonePlayerHandler coordinator) {
        String originalVolume = coordinator.getVolume();
        coordinator.applyNotificationSoundVolume();
        coordinator.playURI(notificationURL);
        coordinator.waitForFinishedNotification();
        coordinator.removeAllTracksFromQueue();
        coordinator.setVolume((Command)DecimalType.valueOf((String)originalVolume));
    }

    private void applyNotificationSoundVolume() {
        this.setNotificationSoundVolume(this.getNotificationSoundVolume());
    }

    private void waitForFinishedNotification() {
        this.waitForTransportState(STATE_PLAYING);
        String notificationTitle = this.stateMap.get("CurrentTitle");
        long playstart = System.currentTimeMillis();
        while (System.currentTimeMillis() - playstart < this.notificationTimeout.longValue() * 1000L) {
            try {
                Thread.sleep(50L);
                if (notificationTitle.equals(this.stateMap.get("CurrentTitle")) && STATE_PLAYING.equals(this.stateMap.get("TransportState"))) continue;
                break;
            }
            catch (InterruptedException interruptedException) {
                this.logger.debug("InterruptedException during playing a notification sound");
            }
        }
    }

    private void waitForTransportState(String state) {
        if (this.stateMap.get("TransportState") != null) {
            long start = System.currentTimeMillis();
            while (!this.stateMap.get("TransportState").equals(state)) {
                try {
                    Thread.sleep(50L);
                    if (System.currentTimeMillis() - start <= this.notificationTimeout.longValue() * 1000L) continue;
                    break;
                }
                catch (InterruptedException interruptedException) {
                    this.logger.debug("InterruptedException during playing a notification sound");
                }
            }
        }
    }

    private void waitForNotTransportState(String state) {
        if (this.stateMap.get("TransportState") != null) {
            long start = System.currentTimeMillis();
            while (this.stateMap.get("TransportState").equals(state)) {
                try {
                    Thread.sleep(50L);
                    if (System.currentTimeMillis() - start <= this.notificationTimeout.longValue() * 1000L) continue;
                    break;
                }
                catch (InterruptedException interruptedException) {
                    this.logger.debug("InterruptedException during playing a notification sound");
                }
            }
        }
    }

    public void removeRangeOfTracksFromQueue(Command command) {
        if (command != null && command instanceof StringType) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            String[] rangeInputSplit = command.toString().split(",");
            String startIndex = rangeInputSplit[0] != null ? rangeInputSplit[0] : "1";
            String numberOfTracks = rangeInputSplit[1] != null ? rangeInputSplit[1] : "1";
            inputs.put("InstanceID", "0");
            inputs.put("StartingIndex", startIndex);
            inputs.put("NumberOfTracks", numberOfTracks);
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "RemoveTrackRangeFromQueue", inputs);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
            }
        }
    }

    public void clearQueue() {
        try {
            ZonePlayerHandler coordinator = this.getCoordinatorHandler();
            coordinator.removeAllTracksFromQueue();
        }
        catch (IllegalStateException e) {
            this.logger.debug("Cannot clear queue ({})", (Object)e.getMessage());
        }
    }

    public void playQueue() {
        try {
            ZonePlayerHandler coordinator = this.getCoordinatorHandler();
            coordinator.setCurrentURI(QUEUE_URI + coordinator.getUDN() + "#0", "");
            coordinator.setMute((Command)OnOffType.OFF);
            coordinator.play();
        }
        catch (IllegalStateException e) {
            this.logger.debug("Cannot play queue ({})", (Object)e.getMessage());
        }
    }

    public void setLed(Command command) {
        if (command != null && (command instanceof OnOffType || command instanceof OpenClosedType || command instanceof UpDownType)) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            if (command.equals(OnOffType.ON) || command.equals(UpDownType.UP) || command.equals(OpenClosedType.OPEN)) {
                inputs.put("DesiredLEDState", "On");
            } else if (command.equals(OnOffType.OFF) || command.equals(UpDownType.DOWN) || command.equals(OpenClosedType.CLOSED)) {
                inputs.put("DesiredLEDState", "Off");
            }
            Map result = this.service.invokeAction((UpnpIOParticipant)this, "DeviceProperties", "SetLEDState", inputs);
            Map result2 = this.service.invokeAction((UpnpIOParticipant)this, "DeviceProperties", "GetLEDState", null);
            result.putAll(result2);
            for (String variable : result.keySet()) {
                this.onValueReceived(variable, (String)result.get(variable), "DeviceProperties");
            }
        }
    }

    public void removeMember(Command command) {
        if (command != null && command instanceof StringType) {
            try {
                ZonePlayerHandler oldmemberHandler = this.getHandlerByName(command.toString());
                oldmemberHandler.becomeStandAlonePlayer();
                SonosEntry entry = new SonosEntry("", "", "", "", "", "", "", QUEUE_URI + oldmemberHandler.getUDN() + "#0");
                oldmemberHandler.setCurrentURI(entry);
            }
            catch (IllegalStateException e) {
                this.logger.debug("Cannot remove group member ({})", (Object)e.getMessage());
            }
        }
    }

    public void previous() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "Previous", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    public void next() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "Next", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    public void stopPlaying(Command command) {
        try {
            if (command instanceof OnOffType) {
                this.getCoordinatorHandler().stop();
            }
        }
        catch (IllegalStateException e) {
            this.logger.debug("Cannot handle stop command ({})", (Object)e.getMessage(), (Object)e);
        }
    }

    public void playRadio(Command command) {
        if (command instanceof StringType) {
            String station = command.toString();
            List<SonosEntry> stations = this.getFavoriteRadios();
            SonosEntry theEntry = null;
            for (SonosEntry someStation : stations) {
                if (!someStation.getTitle().equals(station)) continue;
                theEntry = someStation;
                break;
            }
            if (theEntry != null) {
                try {
                    ZonePlayerHandler coordinator = this.getCoordinatorHandler();
                    coordinator.setCurrentURI(theEntry);
                    coordinator.play();
                }
                catch (IllegalStateException e) {
                    this.logger.debug("Cannot play radio ({})", (Object)e.getMessage());
                }
            } else {
                this.logger.debug("Radio station '{}' not found", (Object)station);
            }
        }
    }

    public void playTuneinStation(Command command) {
        if (command instanceof StringType) {
            String stationId = command.toString();
            List<SonosMusicService> allServices = this.getAvailableMusicServices();
            SonosMusicService tuneinService = null;
            if (allServices != null) {
                for (SonosMusicService service : allServices) {
                    if (!service.getName().equals("TuneIn")) continue;
                    tuneinService = service;
                    break;
                }
            }
            if (tuneinService != null) {
                try {
                    ZonePlayerHandler coordinator = this.getCoordinatorHandler();
                    SonosEntry entry = new SonosEntry("", "TuneIn station", "", "", "", "", "object.item.audioItem.audioBroadcast", String.format(TUNEIN_URI, stationId, tuneinService.getId()));
                    entry.setDesc("SA_RINCON" + tuneinService.getType().toString() + "_");
                    coordinator.setCurrentURI(entry);
                    coordinator.play();
                }
                catch (IllegalStateException e) {
                    this.logger.debug("Cannot play TuneIn station {} ({})", (Object)stationId, (Object)e.getMessage());
                }
            } else {
                this.logger.debug("TuneIn service not found");
            }
        }
    }

    private List<SonosMusicService> getAvailableMusicServices() {
        Map result;
        if (this.musicServices == null && (result = this.service.invokeAction((UpnpIOParticipant)this, "MusicServices", "ListAvailableServices", null)).get("AvailableServiceDescriptorList") != null) {
            this.musicServices = SonosXMLParser.getMusicServicesFromXML((String)result.get("AvailableServiceDescriptorList"));
            String[] servicesTypes = new String[]{};
            if (result.get("AvailableServiceTypeList") != null) {
                servicesTypes = ((String)result.get("AvailableServiceTypeList")).split(",");
            }
            int idx = 0;
            for (SonosMusicService service : this.musicServices) {
                if (!service.getName().equals("TuneIn")) {
                    if (idx < servicesTypes.length) {
                        try {
                            Integer serviceType = Integer.parseInt(servicesTypes[idx]);
                            service.setType(serviceType);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        ++idx;
                    }
                } else {
                    service.setType(65031);
                }
                this.logger.debug("Service name {} => id {} type {}", new Object[]{service.getName(), service.getId(), service.getType()});
            }
        }
        return this.musicServices;
    }

    public void playFavorite(Command command) {
        if (command instanceof StringType) {
            String favorite = command.toString();
            List<SonosEntry> favorites = this.getFavorites();
            SonosEntry theEntry = null;
            for (SonosEntry entry : favorites) {
                if (!entry.getTitle().equals(favorite)) continue;
                theEntry = entry;
                break;
            }
            if (theEntry != null) {
                try {
                    ZonePlayerHandler coordinator = this.getCoordinatorHandler();
                    if (theEntry.getResourceMetaData() != null && theEntry.getResourceMetaData().getUpnpClass().startsWith("object.container")) {
                        coordinator.removeAllTracksFromQueue();
                        coordinator.addURIToQueue(theEntry);
                        coordinator.setCurrentURI(QUEUE_URI + coordinator.getUDN() + "#0", "");
                        String firstTrackNumberEnqueued = this.stateMap.get("FirstTrackNumberEnqueued");
                        if (firstTrackNumberEnqueued != null) {
                            coordinator.seek("TRACK_NR", firstTrackNumberEnqueued);
                        }
                    } else {
                        coordinator.setCurrentURI(theEntry);
                    }
                    coordinator.play();
                }
                catch (IllegalStateException e) {
                    this.logger.debug("Cannot paly favorite ({})", (Object)e.getMessage());
                }
            } else {
                this.logger.debug("Favorite '{}' not found", (Object)favorite);
            }
        }
    }

    public void playTrack(Command command) {
        if (command != null && command instanceof DecimalType) {
            try {
                ZonePlayerHandler coordinator = this.getCoordinatorHandler();
                String trackNumber = String.valueOf(((DecimalType)command).intValue());
                coordinator.setCurrentURI(QUEUE_URI + coordinator.getUDN() + "#0", "");
                coordinator.setPositionTrack(trackNumber);
                coordinator.setMute((Command)OnOffType.OFF);
                coordinator.play();
            }
            catch (IllegalStateException e) {
                this.logger.debug("Cannot play track ({})", (Object)e.getMessage());
            }
        }
    }

    public void playPlayList(Command command) {
        if (command != null && command instanceof StringType) {
            String playlist = command.toString();
            List<SonosEntry> playlists = this.getPlayLists();
            SonosEntry theEntry = null;
            for (SonosEntry somePlaylist : playlists) {
                if (!somePlaylist.getTitle().equals(playlist)) continue;
                theEntry = somePlaylist;
                break;
            }
            if (theEntry != null) {
                try {
                    ZonePlayerHandler coordinator = this.getCoordinatorHandler();
                    coordinator.addURIToQueue(theEntry);
                    coordinator.setCurrentURI(QUEUE_URI + coordinator.getUDN() + "#0", "");
                    String firstTrackNumberEnqueued = this.stateMap.get("FirstTrackNumberEnqueued");
                    if (firstTrackNumberEnqueued != null) {
                        coordinator.seek("TRACK_NR", firstTrackNumberEnqueued);
                    }
                    coordinator.play();
                }
                catch (IllegalStateException e) {
                    this.logger.debug("Cannot play playlist ({})", (Object)e.getMessage());
                }
            } else {
                this.logger.debug("Playlist '{}' not found", (Object)playlist);
            }
        }
    }

    public void addURIToQueue(SonosEntry newEntry) {
        this.addURIToQueue(newEntry.getRes(), SonosXMLParser.compileMetadataString(newEntry), 1L, true);
    }

    public String getZoneName() {
        return this.stateMap.get("ZoneName");
    }

    public String getZoneGroupID() {
        return this.stateMap.get("LocalGroupUUID");
    }

    public String getRunningAlarmProperties() {
        this.updateRunningAlarmProperties();
        return this.stateMap.get("RunningAlarmProperties");
    }

    public String getMute() {
        return this.stateMap.get("MuteMaster");
    }

    public boolean getLed() {
        return this.stateMap.get("CurrentLEDState") != null && this.stateMap.get("CurrentLEDState").equals("On");
    }

    public String getCurrentZoneName() {
        this.updateCurrentZoneName();
        return this.stateMap.get("CurrentZoneName");
    }

    public void onStatusChanged(boolean status) {
        if (status) {
            if (this.getThing().getStatus() != ThingStatus.ONLINE) {
                this.updateStatus(ThingStatus.ONLINE);
                this.scheduler.execute(this.pollingRunnable);
            }
        } else {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.COMMUNICATION_ERROR);
        }
    }

    private String getModelNameFromDescriptor() {
        URL descriptor = this.service.getDescriptorURL((UpnpIOParticipant)this);
        if (descriptor != null) {
            String sonosModelDescription = SonosXMLParser.parseModelDescription(this.service.getDescriptorURL((UpnpIOParticipant)this));
            return SonosXMLParser.extractModelName(sonosModelDescription);
        }
        return null;
    }

    private boolean migrateThingType() {
        String modelName;
        if (this.getThing().getThingTypeUID().equals((Object)SonosBindingConstants.ZONEPLAYER_THING_TYPE_UID) && this.isSupportedModel(modelName = this.getModelNameFromDescriptor())) {
            this.updateSonosThingType(modelName);
            return true;
        }
        return false;
    }

    private boolean isSupportedModel(String modelName) {
        for (ThingTypeUID thingTypeUID : SonosBindingConstants.SUPPORTED_KNOWN_THING_TYPES_UIDS) {
            if (!thingTypeUID.getId().equalsIgnoreCase(modelName)) continue;
            return true;
        }
        return false;
    }

    private void updateSonosThingType(String newThingTypeID) {
        this.changeThingType(new ThingTypeUID("sonos", newThingTypeID), this.getConfig());
    }

    public void setSleepTimer(Command command) {
        if (command != null && command instanceof DecimalType) {
            HashMap<String, String> inputs = new HashMap<String, String>();
            inputs.put("InstanceID", "0");
            inputs.put("NewSleepTimerDuration", this.sleepSecondsToTimeStr(((DecimalType)command).longValue()));
            this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "ConfigureSleepTimer", inputs);
        }
    }

    protected void updateSleepTimerDuration() {
        Map result = this.service.invokeAction((UpnpIOParticipant)this, "AVTransport", "GetRemainingSleepTimerDuration", null);
        for (String variable : result.keySet()) {
            this.onValueReceived(variable, (String)result.get(variable), "AVTransport");
        }
    }

    private String sleepSecondsToTimeStr(long sleepSeconds) {
        if (sleepSeconds == 0L) {
            return "";
        }
        if (sleepSeconds < 68400L) {
            long remainingSeconds = sleepSeconds;
            long hours = TimeUnit.SECONDS.toHours(remainingSeconds);
            long minutes = TimeUnit.SECONDS.toMinutes(remainingSeconds -= TimeUnit.HOURS.toSeconds(hours));
            long seconds = TimeUnit.SECONDS.toSeconds(remainingSeconds -= TimeUnit.MINUTES.toSeconds(minutes));
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        this.logger.debug("Sonos SleepTimer: Invalid sleep time set. sleep time must be >=0 and < 68400s (24h)");
        return "ERR";
    }

    private long sleepStrTimeToSeconds(String sleepTime) {
        String[] units = sleepTime.split(":");
        int hours = Integer.parseInt(units[0]);
        int minutes = Integer.parseInt(units[1]);
        int seconds = Integer.parseInt(units[2]);
        return 3600 * hours + 60 * minutes + seconds;
    }
}

