/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.tradfri.handler;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.CoapObserveRelation;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.binding.tradfri.handler.TradfriGatewayHandler;
import org.eclipse.smarthome.binding.tradfri.internal.CoapCallback;
import org.eclipse.smarthome.binding.tradfri.internal.TradfriCoapClient;
import org.eclipse.smarthome.binding.tradfri.internal.config.TradfriDeviceConfig;
import org.eclipse.smarthome.binding.tradfri.internal.model.TradfriDeviceData;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TradfriThingHandler
extends BaseThingHandler
implements CoapCallback {
    private final Logger logger = LoggerFactory.getLogger(TradfriThingHandler.class);
    protected Integer id;
    protected volatile boolean active;
    protected TradfriCoapClient coapClient;
    private CoapObserveRelation observeRelation;

    public TradfriThingHandler(@NonNull Thing thing) {
        super(thing);
    }

    public synchronized void initialize() {
        Bridge tradfriGateway = this.getBridge();
        this.id = ((TradfriDeviceConfig)this.getConfigAs(TradfriDeviceConfig.class)).id;
        TradfriGatewayHandler handler = (TradfriGatewayHandler)tradfriGateway.getHandler();
        String uriString = String.valueOf(handler.getGatewayURI()) + "/" + this.id;
        try {
            URI uri = new URI(uriString);
            this.coapClient = new TradfriCoapClient(uri);
            this.coapClient.setEndpoint((Endpoint)handler.getEndpoint());
        }
        catch (URISyntaxException e) {
            this.logger.debug("Illegal device URI `{}`: {}", (Object)uriString, (Object)e.getMessage());
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, e.getMessage());
            return;
        }
        this.active = true;
        this.updateStatus(ThingStatus.UNKNOWN);
        switch (tradfriGateway.getStatus()) {
            case ONLINE: {
                this.scheduler.schedule(() -> {
                    this.observeRelation = this.coapClient.startObserve(this);
                }, 3L, TimeUnit.SECONDS);
                break;
            }
            default: {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.BRIDGE_OFFLINE, String.format("Gateway offline '%s'", tradfriGateway.getStatusInfo()));
            }
        }
    }

    public synchronized void dispose() {
        this.active = false;
        if (this.observeRelation != null) {
            this.observeRelation.reactiveCancel();
            this.observeRelation = null;
        }
        if (this.coapClient != null) {
            this.coapClient.shutdown();
        }
        super.dispose();
    }

    @Override
    public void setStatus(ThingStatus status, ThingStatusDetail statusDetail) {
        if (this.active && this.getBridge().getStatus() != ThingStatus.OFFLINE && status != ThingStatus.ONLINE) {
            this.updateStatus(status, statusDetail);
            this.scheduler.schedule(() -> {
                if (this.observeRelation != null) {
                    this.observeRelation.reactiveCancel();
                    this.observeRelation = null;
                }
                this.observeRelation = this.coapClient.startObserve(this);
            }, 10L, TimeUnit.SECONDS);
        }
    }

    public void bridgeStatusChanged(ThingStatusInfo bridgeStatusInfo) {
        super.bridgeStatusChanged(bridgeStatusInfo);
        if (bridgeStatusInfo.getStatus() == ThingStatus.OFFLINE) {
            this.dispose();
        } else if (bridgeStatusInfo.getStatus() == ThingStatus.ONLINE) {
            this.initialize();
        }
    }

    protected void set(String payload) {
        this.logger.debug("Sending payload: {}", (Object)payload);
        this.coapClient.asyncPut(payload, this, this.scheduler);
    }

    protected void updateDeviceProperties(TradfriDeviceData state) {
        String vendor;
        String modelId;
        String firmwareVersion = state.getFirmwareVersion();
        if (firmwareVersion != null) {
            this.getThing().setProperty("firmwareVersion", firmwareVersion);
        }
        if ((modelId = state.getModelId()) != null) {
            this.getThing().setProperty("modelId", modelId);
        }
        if ((vendor = state.getVendor()) != null) {
            this.getThing().setProperty("vendor", vendor);
        }
    }
}

