/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.tradfri.internal.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TradfriDeviceData {
    private final Logger logger = LoggerFactory.getLogger(TradfriDeviceData.class);
    protected JsonObject root;
    protected JsonArray array;
    protected JsonObject attributes;
    protected JsonObject generalInfo;

    public TradfriDeviceData(String attributesNodeName) {
        this.root = new JsonObject();
        this.array = new JsonArray();
        this.attributes = new JsonObject();
        this.array.add((JsonElement)this.attributes);
        this.root.add(attributesNodeName, (JsonElement)this.array);
        this.generalInfo = new JsonObject();
        this.root.add("3", (JsonElement)this.generalInfo);
    }

    public TradfriDeviceData(String attributesNodeName, JsonElement json) {
        try {
            this.root = json.getAsJsonObject();
            this.array = this.root.getAsJsonArray(attributesNodeName);
            this.attributes = this.array.get(0).getAsJsonObject();
            this.generalInfo = this.root.getAsJsonObject("3");
        }
        catch (JsonSyntaxException e) {
            this.logger.error("JSON error: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public Integer getDeviceId() {
        return this.root.get("9003").getAsInt();
    }

    public boolean getReachabilityStatus() {
        if (this.root.get("9019") != null) {
            return this.root.get("9019").getAsInt() == 1;
        }
        return false;
    }

    public String getFirmwareVersion() {
        if (this.generalInfo.get("3") != null) {
            return this.generalInfo.get("3").getAsString();
        }
        return null;
    }

    public String getModelId() {
        if (this.generalInfo.get("1") != null) {
            return this.generalInfo.get("1").getAsString();
        }
        return null;
    }

    public String getVendor() {
        if (this.generalInfo.get("0") != null) {
            return this.generalInfo.get("0").getAsString();
        }
        return null;
    }
}

