/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.weatherunderground.handler;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.weatherunderground.internal.json.WeatherUndergroundJsonData;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.BaseBridgeHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.io.net.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class WeatherUndergroundBridgeHandler
extends BaseBridgeHandler {
    private final Logger logger = LoggerFactory.getLogger(WeatherUndergroundBridgeHandler.class);
    private final Gson gson = new Gson();
    private static final String URL = "http://api.wunderground.com/api/%APIKEY%/";
    public static final int FETCH_TIMEOUT_MS = 30000;
    private @Nullable ScheduledFuture<?> controlApiKeyJob;
    private @Nullable String apikey;

    public WeatherUndergroundBridgeHandler(Bridge bridge) {
        super(bridge);
    }

    public void initialize() {
        this.logger.debug("Initializing weatherunderground bridge handler.");
        Configuration config = this.getThing().getConfiguration();
        if (StringUtils.trimToNull((String)((String)config.get("apikey"))) == null) {
            this.logger.debug("Setting thing '{}' to OFFLINE: Parameter 'apikey' must be configured.", (Object)this.getThing().getUID());
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "@text/offline.conf-error-missing-apikey");
        } else {
            this.apikey = (String)config.get("apikey");
            this.updateStatus(ThingStatus.UNKNOWN);
            this.startControlApiKeyJob();
        }
    }

    private void startControlApiKeyJob() {
        if (this.controlApiKeyJob == null || this.controlApiKeyJob.isCancelled()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WeatherUndergroundJsonData result = null;
                    String errorDetail = null;
                    String error = null;
                    String statusDescr = null;
                    boolean resultOk = false;
                    try {
                        String urlStr = WeatherUndergroundBridgeHandler.URL.replace("%APIKEY%", StringUtils.trimToEmpty((String)WeatherUndergroundBridgeHandler.this.getApikey()));
                        String response = null;
                        try {
                            response = HttpUtil.executeUrl((String)"GET", (String)urlStr, (int)30000);
                            WeatherUndergroundBridgeHandler.this.logger.debug("apiResponse = {}", (Object)response);
                        }
                        catch (IllegalArgumentException e) {
                            error = "Error creating URI";
                            errorDetail = e.getMessage();
                            statusDescr = "@text/offline.uri-error";
                        }
                        result = (WeatherUndergroundJsonData)WeatherUndergroundBridgeHandler.this.gson.fromJson(response, WeatherUndergroundJsonData.class);
                        if (result.getResponse() == null) {
                            error = "Error in Weather Underground response";
                            errorDetail = "missing response sub-object";
                            statusDescr = "@text/offline.comm-error-response";
                        } else if (result.getResponse().getErrorDescription() != null) {
                            if ("keynotfound".equals(result.getResponse().getErrorType())) {
                                error = "API key has to be fixed";
                                errorDetail = result.getResponse().getErrorDescription();
                                statusDescr = "@text/offline.comm-error-invalid-api-key";
                            } else if ("invalidquery".equals(result.getResponse().getErrorType())) {
                                resultOk = true;
                            } else {
                                error = "Error in Weather Underground response";
                                errorDetail = result.getResponse().getErrorDescription();
                                statusDescr = "@text/offline.comm-error-response";
                            }
                        } else {
                            resultOk = true;
                        }
                    }
                    catch (IOException e) {
                        error = "Error running Weather Underground request";
                        errorDetail = e.getMessage();
                        statusDescr = "@text/offline.comm-error-running-request";
                    }
                    catch (JsonSyntaxException e) {
                        error = "Error parsing Weather Underground response";
                        errorDetail = e.getMessage();
                        statusDescr = "@text/offline.comm-error-parsing-response";
                    }
                    if (resultOk) {
                        WeatherUndergroundBridgeHandler.this.updateStatus(ThingStatus.ONLINE);
                    } else {
                        WeatherUndergroundBridgeHandler.this.logger.debug("Setting thing '{}' to OFFLINE: Error '{}': {}", new Object[]{WeatherUndergroundBridgeHandler.this.getThing().getUID(), error, errorDetail});
                        WeatherUndergroundBridgeHandler.this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.COMMUNICATION_ERROR, statusDescr);
                    }
                }
            };
            this.controlApiKeyJob = this.scheduler.schedule(runnable, 1L, TimeUnit.SECONDS);
        }
    }

    public void dispose() {
        this.logger.debug("Disposing weatherunderground bridge handler.");
        if (this.controlApiKeyJob != null && !this.controlApiKeyJob.isCancelled()) {
            this.controlApiKeyJob.cancel(true);
            this.controlApiKeyJob = null;
        }
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
    }

    public @Nullable String getApikey() {
        return this.apikey;
    }
}

