/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.weatherunderground.internal.json;

import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

public class WeatherUndergroundJsonUtils {
    private static final String TREND_UP = "up";
    private static final String TREND_DOWN = "down";
    private static final String TREND_STABLE = "stable";

    public static ZonedDateTime convertToZonedDateTime(String value) {
        if (WeatherUndergroundJsonUtils.isValid(value)) {
            try {
                Instant epochSeconds = Instant.ofEpochSecond(Long.valueOf(value));
                return ZonedDateTime.ofInstant(epochSeconds, TimeZone.getDefault().toZoneId());
            }
            catch (DateTimeException dateTimeException) {
                LoggerFactory.getLogger(WeatherUndergroundJsonUtils.class).debug("Cannot convert {} to ZonedDateTime", (Object)value);
            }
        }
        return null;
    }

    public static Integer convertToInteger(String value) {
        Integer result = null;
        if (WeatherUndergroundJsonUtils.isValid(value)) {
            try {
                result = Integer.valueOf(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                LoggerFactory.getLogger(WeatherUndergroundJsonUtils.class).debug("Cannot convert {} to Integer", (Object)value);
            }
        }
        return result;
    }

    public static BigDecimal convertToBigDecimal(String value) {
        BigDecimal result = null;
        if (WeatherUndergroundJsonUtils.isValid(value)) {
            result = new BigDecimal(value.trim());
        }
        return result;
    }

    private static boolean isValid(String value) {
        return value != null && !value.isEmpty() && !value.equalsIgnoreCase("N/A") && !value.equalsIgnoreCase("NA") && !value.equals("-") && !value.equals("--");
    }

    public static URL getValidUrl(String url) {
        URL validUrl = null;
        if (StringUtils.isNotBlank((String)url)) {
            try {
                validUrl = new URL(url);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return validUrl;
    }

    public static String convertToTrend(String value) {
        String result = null;
        if (WeatherUndergroundJsonUtils.isValid(value)) {
            try {
                int val = Integer.valueOf(value.trim());
                result = val < 0 ? TREND_DOWN : (val > 0 ? TREND_UP : TREND_STABLE);
            }
            catch (NumberFormatException numberFormatException) {
                LoggerFactory.getLogger(WeatherUndergroundJsonUtils.class).debug("Cannot convert {} to Integer", (Object)value);
            }
        }
        return result;
    }
}

