/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterGroup;
import org.eclipse.smarthome.core.common.registry.Identifiable;

public class ConfigDescription
implements Identifiable<URI> {
    private URI uri;
    private List<ConfigDescriptionParameter> parameters;
    private List<ConfigDescriptionParameterGroup> parameterGroups;

    public ConfigDescription(URI uri) throws IllegalArgumentException {
        this(uri, null, null);
    }

    public ConfigDescription(URI uri, List<ConfigDescriptionParameter> parameters) {
        this(uri, parameters, null);
    }

    public ConfigDescription(URI uri, List<ConfigDescriptionParameter> parameters, List<ConfigDescriptionParameterGroup> groups) {
        if (uri == null) {
            throw new IllegalArgumentException("The URI must not be null!");
        }
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("The scheme is missing!");
        }
        if (!uri.isOpaque()) {
            throw new IllegalArgumentException("The scheme specific part (token) must not start with a slash ('/')!");
        }
        this.uri = uri;
        this.parameters = parameters != null ? Collections.unmodifiableList(parameters) : Collections.unmodifiableList(new ArrayList(0));
        this.parameterGroups = groups != null ? Collections.unmodifiableList(groups) : Collections.unmodifiableList(new ArrayList(0));
    }

    public URI getUID() {
        return this.uri;
    }

    public List<ConfigDescriptionParameter> getParameters() {
        return this.parameters;
    }

    public Map<String, ConfigDescriptionParameter> toParametersMap() {
        HashMap<String, ConfigDescriptionParameter> map = new HashMap<String, ConfigDescriptionParameter>();
        for (ConfigDescriptionParameter parameter : this.parameters) {
            map.put(parameter.getName(), parameter);
        }
        return Collections.unmodifiableMap(map);
    }

    public List<ConfigDescriptionParameterGroup> getParameterGroups() {
        return this.parameterGroups;
    }

    public String toString() {
        return "ConfigDescription [uri=" + this.uri + ", parameters=" + this.parameters + ", groups=" + this.parameterGroups + "]";
    }
}

