/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.internal.validation;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.internal.validation.ConfigDescriptionParameterValidator;
import org.eclipse.smarthome.config.core.internal.validation.ConfigDescriptionParameterValidatorFactory;
import org.eclipse.smarthome.config.core.validation.ConfigDescriptionValidator;
import org.eclipse.smarthome.config.core.validation.ConfigValidationException;
import org.eclipse.smarthome.config.core.validation.ConfigValidationMessage;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public final class ConfigDescriptionValidatorImpl
implements ConfigDescriptionValidator {
    private final Logger logger = LoggerFactory.getLogger(ConfigDescriptionValidatorImpl.class);
    private ConfigDescriptionRegistry configDescriptionRegistry;
    private TranslationProvider translationProvider;
    private static final List<ConfigDescriptionParameterValidator> VALIDATORS = Collections.unmodifiableList(Arrays.asList(ConfigDescriptionParameterValidatorFactory.createRequiredValidator(), ConfigDescriptionParameterValidatorFactory.createTypeValidator(), ConfigDescriptionParameterValidatorFactory.createMinMaxValidator(), ConfigDescriptionParameterValidatorFactory.createPatternValidator()));
    private BundleContext bundleContext;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate() {
        this.bundleContext = null;
    }

    @Override
    public void validate(Map<String, Object> configurationParameters, URI configDescriptionURI) {
        Objects.requireNonNull(configurationParameters, "Configuration parameters must not be null");
        Objects.requireNonNull(configDescriptionURI, "Config description URI must not be null");
        ConfigDescription configDescription = this.getConfigDescription(configDescriptionURI);
        if (configDescription == null) {
            this.logger.warn("Skipping config description validation because no config description found for URI '{}'", (Object)configDescriptionURI);
            return;
        }
        Map<String, ConfigDescriptionParameter> map = configDescription.toParametersMap();
        ArrayList<ConfigValidationMessage> configDescriptionValidationMessages = new ArrayList<ConfigValidationMessage>();
        for (String key : configurationParameters.keySet()) {
            ConfigDescriptionParameter configDescriptionParameter = map.get(key);
            if (configDescriptionParameter == null) continue;
            if (configDescriptionParameter.isMultiple().booleanValue() && configurationParameters.get(key) instanceof List) {
                for (Object value : (List)configurationParameters.get(key)) {
                    ConfigValidationMessage message = this.validateParameter(configDescriptionParameter, value);
                    if (message == null) continue;
                    configDescriptionValidationMessages.add(message);
                }
                continue;
            }
            ConfigValidationMessage message = this.validateParameter(configDescriptionParameter, configurationParameters.get(key));
            if (message == null) continue;
            configDescriptionValidationMessages.add(message);
        }
        if (!configDescriptionValidationMessages.isEmpty()) {
            throw new ConfigValidationException(this.bundleContext.getBundle(), this.translationProvider, configDescriptionValidationMessages);
        }
    }

    private ConfigValidationMessage validateParameter(ConfigDescriptionParameter configDescriptionParameter, Object value) {
        for (ConfigDescriptionParameterValidator validator : VALIDATORS) {
            ConfigValidationMessage message = validator.validate(configDescriptionParameter, value);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    private ConfigDescription getConfigDescription(URI configDescriptionURI) {
        if (this.configDescriptionRegistry == null) {
            this.logger.warn("No config description registry available.");
            return null;
        }
        ConfigDescription configDescription = this.configDescriptionRegistry.getConfigDescription(configDescriptionURI);
        if (configDescription == null) {
            this.logger.warn("No config description found for URI '{}'", (Object)configDescriptionURI);
        }
        return configDescription;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = configDescriptionRegistry;
    }

    protected void unsetConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setTranslationProvider(TranslationProvider translationProvider) {
        this.translationProvider = translationProvider;
    }

    protected void unsetTranslationProvider(TranslationProvider translationProvider) {
        this.translationProvider = null;
    }
}

