/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.usbserial.linuxsysfs.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.config.discovery.usbserial.UsbSerialDeviceInformation;
import org.eclipse.smarthome.config.discovery.usbserial.linuxsysfs.internal.UsbSerialScanner;

@NonNullByDefault
public class DeltaUsbSerialScanner {
    private Set<UsbSerialDeviceInformation> lastScanResult = new HashSet<UsbSerialDeviceInformation>();
    private final UsbSerialScanner usbSerialScanner;

    public DeltaUsbSerialScanner(UsbSerialScanner usbSerialScanner) {
        this.usbSerialScanner = usbSerialScanner;
    }

    public synchronized Delta<UsbSerialDeviceInformation> scan() throws IOException {
        Set<UsbSerialDeviceInformation> scanResult = this.usbSerialScanner.scan();
        Set<UsbSerialDeviceInformation> added = this.setDifference(scanResult, this.lastScanResult);
        Set<UsbSerialDeviceInformation> removed = this.setDifference(this.lastScanResult, scanResult);
        Set<UsbSerialDeviceInformation> unchanged = this.setDifference(scanResult, added);
        this.lastScanResult = scanResult;
        return new Delta<UsbSerialDeviceInformation>(added, removed, unchanged);
    }

    public boolean canPerformScans() {
        return this.usbSerialScanner.canPerformScans();
    }

    private <T> Set<T> setDifference(Set<T> set1, Set<T> set2) {
        HashSet<T> result = new HashSet<T>(set1);
        result.removeAll(set2);
        return Collections.unmodifiableSet(result);
    }

    class Delta<T> {
        private final Set<T> added;
        private final Set<T> removed;
        private final Set<T> unchanged;

        public Delta(Set<T> added, Set<T> removed, Set<T> unchanged) {
            this.added = added;
            this.removed = removed;
            this.unchanged = unchanged;
        }

        public Set<T> getAdded() {
            return this.added;
        }

        public Set<T> getRemoved() {
            return this.removed;
        }

        public Set<T> getUnchanged() {
            return this.unchanged;
        }
    }
}

