/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.discovery.DiscoveryListener;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.config.discovery.ScanListener;
import org.eclipse.smarthome.config.discovery.internal.DiscoveryResultImpl;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.i18n.I18nUtil;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractDiscoveryService
implements DiscoveryService {
    private static final String DISCOVERY_THREADPOOL_NAME = "discovery";
    private final Logger logger = LoggerFactory.getLogger(AbstractDiscoveryService.class);
    protected final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"discovery");
    private final Set<DiscoveryListener> discoveryListeners = new CopyOnWriteArraySet<DiscoveryListener>();
    protected @Nullable ScanListener scanListener = null;
    private boolean backgroundDiscoveryEnabled;
    private final Map<ThingUID, DiscoveryResult> cachedResults = new HashMap<ThingUID, DiscoveryResult>();
    private final Set<ThingTypeUID> supportedThingTypes;
    private final int timeout;
    private long timestampOfLastScan = 0L;
    private @Nullable ScheduledFuture<?> scheduledStop;
    @NonNullByDefault(value={})
    protected TranslationProvider i18nProvider;
    @NonNullByDefault(value={})
    protected LocaleProvider localeProvider;

    public AbstractDiscoveryService(@Nullable Set<ThingTypeUID> supportedThingTypes, int timeout, boolean backgroundDiscoveryEnabledByDefault) throws IllegalArgumentException {
        this.supportedThingTypes = supportedThingTypes == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<ThingTypeUID>(supportedThingTypes));
        if (timeout < 0) {
            throw new IllegalArgumentException("The timeout must be >= 0!");
        }
        this.timeout = timeout;
        this.backgroundDiscoveryEnabled = backgroundDiscoveryEnabledByDefault;
    }

    public AbstractDiscoveryService(@Nullable Set<ThingTypeUID> supportedThingTypes, int timeout) throws IllegalArgumentException {
        this(supportedThingTypes, timeout, true);
    }

    public AbstractDiscoveryService(int timeout) throws IllegalArgumentException {
        this(null, timeout);
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        return this.supportedThingTypes;
    }

    @Override
    public int getScanTimeout() {
        return this.timeout;
    }

    @Override
    public boolean isBackgroundDiscoveryEnabled() {
        return this.backgroundDiscoveryEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDiscoveryListener(@Nullable DiscoveryListener listener) {
        if (listener == null) {
            return;
        }
        Map<ThingUID, DiscoveryResult> map = this.cachedResults;
        synchronized (map) {
            for (DiscoveryResult cachedResult : this.cachedResults.values()) {
                listener.thingDiscovered(this, cachedResult);
            }
        }
        this.discoveryListeners.add(listener);
    }

    @Override
    public void removeDiscoveryListener(@Nullable DiscoveryListener listener) {
        this.discoveryListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startScan(@Nullable ScanListener listener) {
        AbstractDiscoveryService abstractDiscoveryService = this;
        synchronized (abstractDiscoveryService) {
            this.stopScan();
            if (this.scheduledStop != null) {
                this.scheduledStop.cancel(false);
                this.scheduledStop = null;
            }
            this.scanListener = listener;
            if (this.getScanTimeout() > 0) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AbstractDiscoveryService.this.stopScan();
                        }
                        catch (Exception e) {
                            AbstractDiscoveryService.this.logger.debug("Exception occurred during execution: {}", (Object)e.getMessage(), (Object)e);
                        }
                    }
                };
                this.scheduledStop = this.scheduler.schedule(runnable, (long)this.getScanTimeout(), TimeUnit.SECONDS);
            }
            this.timestampOfLastScan = new Date().getTime();
            try {
                this.startScan();
            }
            catch (Exception ex) {
                if (this.scheduledStop != null) {
                    this.scheduledStop.cancel(false);
                    this.scheduledStop = null;
                }
                this.scanListener = null;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void abortScan() {
        AbstractDiscoveryService abstractDiscoveryService = this;
        synchronized (abstractDiscoveryService) {
            ScanListener scanListener;
            if (this.scheduledStop != null) {
                this.scheduledStop.cancel(false);
                this.scheduledStop = null;
            }
            if ((scanListener = this.scanListener) != null) {
                CancellationException e = new CancellationException("Scan has been aborted.");
                scanListener.onErrorOccurred(e);
                this.scanListener = null;
            }
        }
    }

    protected abstract void startScan();

    protected synchronized void stopScan() {
        if (this.scanListener != null) {
            this.scanListener.onFinished();
            this.scanListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void thingDiscovered(DiscoveryResult discoveryResult) {
        DiscoveryResult discoveryResultNew;
        if (this.i18nProvider != null && this.localeProvider != null) {
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            String defaultLabel = discoveryResult.getLabel();
            String key = I18nUtil.stripConstantOr((String)defaultLabel, () -> this.inferKey(discoveryResult, "label"));
            String label = this.i18nProvider.getText(bundle, key, defaultLabel, this.localeProvider.getLocale());
            discoveryResultNew = new DiscoveryResultImpl(discoveryResult.getThingTypeUID(), discoveryResult.getThingUID(), discoveryResult.getBridgeUID(), discoveryResult.getProperties(), discoveryResult.getRepresentationProperty(), label, discoveryResult.getTimeToLive());
        } else {
            discoveryResultNew = discoveryResult;
        }
        for (DiscoveryListener discoveryListener : this.discoveryListeners) {
            try {
                discoveryListener.thingDiscovered(this, discoveryResultNew);
            }
            catch (Exception e) {
                this.logger.error("An error occurred while calling the discovery listener {}.", (Object)discoveryListener.getClass().getName(), (Object)e);
            }
        }
        Map<ThingUID, DiscoveryResult> map = this.cachedResults;
        synchronized (map) {
            this.cachedResults.put(discoveryResultNew.getThingUID(), discoveryResultNew);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void thingRemoved(ThingUID thingUID) {
        for (DiscoveryListener discoveryListener : this.discoveryListeners) {
            try {
                discoveryListener.thingRemoved(this, thingUID);
            }
            catch (Exception e) {
                this.logger.error("An error occurred while calling the discovery listener {}.", (Object)discoveryListener.getClass().getName(), (Object)e);
            }
        }
        Map<ThingUID, DiscoveryResult> map = this.cachedResults;
        synchronized (map) {
            this.cachedResults.remove(thingUID);
        }
    }

    protected void removeOlderResults(long timestamp) {
        this.removeOlderResults(timestamp, null, null);
    }

    protected void removeOlderResults(long timestamp, @Nullable ThingUID bridgeUID) {
        this.removeOlderResults(timestamp, null, bridgeUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeOlderResults(long timestamp, @Nullable Collection<ThingTypeUID> thingTypeUIDs, @Nullable ThingUID bridgeUID) {
        Collection<ThingUID> removedThings = null;
        Collection toBeRemoved = thingTypeUIDs != null ? thingTypeUIDs : this.getSupportedThingTypes();
        for (DiscoveryListener discoveryListener : this.discoveryListeners) {
            try {
                removedThings = discoveryListener.removeOlderResults(this, timestamp, toBeRemoved, bridgeUID);
            }
            catch (Exception e) {
                this.logger.error("An error occurred while calling the discovery listener {}.", (Object)discoveryListener.getClass().getName(), (Object)e);
            }
        }
        if (removedThings != null) {
            Map<ThingUID, DiscoveryResult> map = this.cachedResults;
            synchronized (map) {
                for (ThingUID uid : removedThings) {
                    this.cachedResults.remove(uid);
                }
            }
        }
    }

    protected void activate(@Nullable Map<String, @Nullable Object> configProperties) {
        Object property;
        if (configProperties != null && (property = configProperties.get("background")) != null) {
            this.backgroundDiscoveryEnabled = this.getAutoDiscoveryEnabled(property);
        }
        if (this.backgroundDiscoveryEnabled) {
            this.startBackgroundDiscovery();
            this.logger.debug("Background discovery for discovery service '{}' enabled.", (Object)this.getClass().getName());
        }
    }

    protected void modified(@Nullable Map<String, @Nullable Object> configProperties) {
        Object property;
        if (configProperties != null && (property = configProperties.get("background")) != null) {
            boolean enabled = this.getAutoDiscoveryEnabled(property);
            if (this.backgroundDiscoveryEnabled && !enabled) {
                this.stopBackgroundDiscovery();
                this.logger.debug("Background discovery for discovery service '{}' disabled.", (Object)this.getClass().getName());
            } else if (!this.backgroundDiscoveryEnabled && enabled) {
                this.startBackgroundDiscovery();
                this.logger.debug("Background discovery for discovery service '{}' enabled.", (Object)this.getClass().getName());
            }
            this.backgroundDiscoveryEnabled = enabled;
        }
    }

    protected void deactivate() {
        if (this.backgroundDiscoveryEnabled) {
            this.stopBackgroundDiscovery();
        }
    }

    protected void startBackgroundDiscovery() {
    }

    protected void stopBackgroundDiscovery() {
    }

    protected long getTimestampOfLastScan() {
        return this.timestampOfLastScan;
    }

    private boolean getAutoDiscoveryEnabled(Object autoDiscoveryEnabled) {
        if (autoDiscoveryEnabled instanceof String) {
            return Boolean.valueOf((String)autoDiscoveryEnabled);
        }
        return autoDiscoveryEnabled == Boolean.TRUE;
    }

    private String inferKey(DiscoveryResult discoveryResult, String lastSegment) {
        return "discovery." + discoveryResult.getThingUID().getAsString().replaceAll(":", ".") + "." + lastSegment;
    }
}

