/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.internal;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultFlag;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;

public class DiscoveryResultImpl
implements DiscoveryResult {
    private ThingUID bridgeUID;
    private ThingUID thingUID;
    private ThingTypeUID thingTypeUID;
    private Map<String, Object> properties;
    private String representationProperty;
    private DiscoveryResultFlag flag;
    private String label;
    private long timestamp;
    private long timeToLive = -1L;

    DiscoveryResultImpl() {
    }

    @Deprecated
    public DiscoveryResultImpl(ThingUID thingUID, ThingUID bridgeUID, Map<String, Object> properties, String representationProperty, String label, long timeToLive) throws IllegalArgumentException {
        this(thingUID.getThingTypeUID(), thingUID, bridgeUID, properties, representationProperty, label, timeToLive);
    }

    public DiscoveryResultImpl(ThingTypeUID thingTypeUID, ThingUID thingUID, ThingUID bridgeUID, Map<String, Object> properties, String representationProperty, String label, long timeToLive) throws IllegalArgumentException {
        if (thingUID == null) {
            throw new IllegalArgumentException("The thing UID must not be null!");
        }
        if (timeToLive < 1L && timeToLive != -1L) {
            throw new IllegalArgumentException("The ttl must not be 0 or negative!");
        }
        this.thingUID = thingUID;
        this.thingTypeUID = thingTypeUID;
        this.bridgeUID = bridgeUID;
        this.properties = Collections.unmodifiableMap(properties != null ? new HashMap<String, Object>(properties) : new HashMap());
        this.representationProperty = representationProperty;
        this.label = label == null ? "" : label;
        this.timestamp = new Date().getTime();
        this.timeToLive = timeToLive;
        this.flag = DiscoveryResultFlag.NEW;
    }

    @Override
    public ThingUID getThingUID() {
        return this.thingUID;
    }

    @Override
    public ThingTypeUID getThingTypeUID() {
        if (this.thingTypeUID != null) {
            return this.thingTypeUID;
        }
        return this.thingUID.getThingTypeUID();
    }

    @Override
    public String getBindingId() {
        ThingUID thingId = this.thingUID;
        if (thingId != null) {
            return thingId.getBindingId();
        }
        return "";
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public String getRepresentationProperty() {
        return this.representationProperty;
    }

    @Override
    public DiscoveryResultFlag getFlag() {
        return this.flag;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public ThingUID getBridgeUID() {
        return this.bridgeUID;
    }

    public void synchronize(DiscoveryResult sourceResult) {
        if (sourceResult != null && sourceResult.getThingUID().equals((Object)this.thingUID)) {
            this.properties = sourceResult.getProperties();
            this.representationProperty = sourceResult.getRepresentationProperty();
            this.label = sourceResult.getLabel();
            this.timestamp = new Date().getTime();
            this.timeToLive = sourceResult.getTimeToLive();
        }
    }

    public void setFlag(DiscoveryResultFlag flag) {
        this.flag = flag == null ? DiscoveryResultFlag.NEW : flag;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.thingUID == null ? 0 : this.thingUID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscoveryResultImpl other = (DiscoveryResultImpl)obj;
        return !(this.thingUID == null ? other.thingUID != null : !this.thingUID.equals((Object)other.thingUID));
    }

    public String toString() {
        return "DiscoveryResult [thingUID=" + this.thingUID + ", properties=" + this.properties + ", representationProperty=" + this.representationProperty + ", flag=" + (Object)((Object)this.flag) + ", label=" + this.label + ", bridgeUID=" + this.bridgeUID + ", ttl=" + this.timeToLive + ", timestamp=" + this.timestamp + "]";
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getTimeToLive() {
        return this.timeToLive;
    }
}

