/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.semantics;

import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.semantics.SemanticTags;
import org.eclipse.smarthome.core.semantics.model.Equipment;
import org.eclipse.smarthome.core.semantics.model.Location;
import org.eclipse.smarthome.core.semantics.model.Point;
import org.eclipse.smarthome.core.semantics.model.Property;
import org.eclipse.smarthome.core.semantics.model.Tag;

@NonNullByDefault
public class SemanticsPredicates {
    public static Predicate<Item> isLocation() {
        return i -> SemanticsPredicates.isA(Location.class).test((Item)i);
    }

    public static Predicate<Item> isEquipment() {
        return i -> SemanticsPredicates.isA(Equipment.class).test((Item)i);
    }

    public static Predicate<Item> isPoint() {
        return i -> SemanticsPredicates.isA(Point.class).test((Item)i);
    }

    public static Predicate<Item> isA(Class<? extends Tag> type) {
        return i -> {
            Class<? extends Tag> semanticType = SemanticTags.getSemanticType(i);
            return semanticType != null && type.isAssignableFrom(semanticType);
        };
    }

    public static Predicate<Item> relatesTo(Class<? extends Property> property) {
        return i -> {
            Class<? extends Property> semanticProperty = SemanticTags.getProperty(i);
            return semanticProperty != null && property.isAssignableFrom(semanticProperty);
        };
    }
}

