/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.semantics.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.common.registry.AbstractProvider;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.Metadata;
import org.eclipse.smarthome.core.items.MetadataKey;
import org.eclipse.smarthome.core.items.MetadataProvider;
import org.eclipse.smarthome.core.semantics.SemanticTags;
import org.eclipse.smarthome.core.semantics.model.Equipment;
import org.eclipse.smarthome.core.semantics.model.Location;
import org.eclipse.smarthome.core.semantics.model.Point;
import org.eclipse.smarthome.core.semantics.model.Property;
import org.eclipse.smarthome.core.semantics.model.Tag;
import org.eclipse.smarthome.core.semantics.model.TagInfo;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component(immediate=true)
public class SemanticsMetadataProvider
extends AbstractProvider<Metadata>
implements MetadataProvider,
RegistryChangeListener<Item> {
    public static final String NAMESPACE = "semantics";
    private final Map<List<Class<? extends Tag>>, String> parentRelations = new HashMap<List<Class<? extends Tag>>, String>();
    private final Map<List<Class<? extends Tag>>, String> memberRelations = new HashMap<List<Class<? extends Tag>>, String>();
    private final Map<List<Class<? extends Tag>>, String> propertyRelations = new HashMap<List<Class<? extends Tag>>, String>();
    private final Map<String, Metadata> semantics = new TreeMap<String, Metadata>(new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    });
    @NonNullByDefault(value={})
    private ItemRegistry itemRegistry;

    @Activate
    protected void activate() {
        this.initRelations();
        for (Item item : this.itemRegistry.getAll()) {
            this.processItem(item);
        }
        this.itemRegistry.addRegistryChangeListener((RegistryChangeListener)this);
    }

    protected void deactivate() {
        this.itemRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.semantics.clear();
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    public Collection<Metadata> getAll() {
        return this.semantics.values();
    }

    private void processItem(Item item) {
        MetadataKey key = new MetadataKey(NAMESPACE, item.getName());
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        Class<? extends Tag> type = SemanticTags.getSemanticType(item);
        if (type != null) {
            this.processProperties(item, configuration);
            this.processHierarchy(item, configuration);
            Metadata md = new Metadata(key, type.getAnnotation(TagInfo.class).id(), configuration);
            Metadata oldMd = this.semantics.put(item.getName(), md);
            if (oldMd == null) {
                this.notifyListenersAboutAddedElement(md);
            } else {
                this.notifyListenersAboutUpdatedElement(oldMd, md);
            }
        }
    }

    private void processProperties(Item item, Map<String, Object> configuration) {
        Class<? extends Tag> type = SemanticTags.getSemanticType(item);
        for (Map.Entry<List<Class<? extends Tag>>, String> relation : this.propertyRelations.entrySet()) {
            Class<? extends Property> p;
            Class<? extends Tag> entityClass = relation.getKey().get(0);
            if (!entityClass.isAssignableFrom(type) || (p = SemanticTags.getProperty(item)) == null) continue;
            configuration.put(relation.getValue(), p.getAnnotation(TagInfo.class).id());
        }
    }

    private void processHierarchy(Item item, Map<String, Object> configuration) {
        Class<? extends Tag> type = SemanticTags.getSemanticType(item);
        if (type != null) {
            for (String parent : item.getGroupNames()) {
                Item parentItem = (Item)this.itemRegistry.get((Object)parent);
                if (parentItem == null) continue;
                this.processParent(type, parentItem, configuration);
            }
            if (item instanceof GroupItem) {
                GroupItem gItem = (GroupItem)item;
                for (Item memberItem : gItem.getMembers()) {
                    this.processMember(type, memberItem, configuration);
                }
            }
        }
    }

    private void processParent(Class<? extends Tag> type, Item parentItem, Map<String, Object> configuration) {
        Class<? extends Tag> typeParent = SemanticTags.getSemanticType(parentItem);
        if (typeParent == null) {
            return;
        }
        for (Map.Entry<List<Class<? extends Tag>>, String> relation : this.parentRelations.entrySet()) {
            List<Class<? extends Tag>> relClasses = relation.getKey();
            Class<? extends Tag> entityClass = relClasses.get(0);
            Class<? extends Tag> parentClass = relClasses.get(1);
            if (!entityClass.isAssignableFrom(type) || !parentClass.isAssignableFrom(typeParent)) continue;
            configuration.put(relation.getValue(), parentItem.getName());
        }
    }

    private void processMember(Class<? extends Tag> type, Item memberItem, Map<String, Object> configuration) {
        Class<? extends Tag> typeMember = SemanticTags.getSemanticType(memberItem);
        if (typeMember == null) {
            return;
        }
        for (Map.Entry<List<Class<? extends Tag>>, String> relation : this.memberRelations.entrySet()) {
            List<Class<? extends Tag>> relClasses = relation.getKey();
            Class<? extends Tag> entityClass = relClasses.get(0);
            Class<? extends Tag> parentClass = relClasses.get(1);
            if (!entityClass.isAssignableFrom(type) || !parentClass.isAssignableFrom(typeMember)) continue;
            configuration.put(relation.getValue(), memberItem.getName());
        }
    }

    private void initRelations() {
        this.parentRelations.put(Arrays.asList(Equipment.class, Location.class), "hasLocation");
        this.parentRelations.put(Arrays.asList(Point.class, Location.class), "hasLocation");
        this.parentRelations.put(Arrays.asList(Location.class, Location.class), "isPartOf");
        this.parentRelations.put(Arrays.asList(Equipment.class, Equipment.class), "isPartOf");
        this.parentRelations.put(Arrays.asList(Point.class, Equipment.class), "isPointOf");
        this.memberRelations.put(Arrays.asList(Equipment.class, Point.class), "hasPoint");
        this.propertyRelations.put(Arrays.asList(Point.class), "relatesTo");
    }

    public void added(Item item) {
        this.processItem(item);
    }

    public void removed(Item item) {
        Metadata removedMd = this.semantics.remove(item.getName());
        if (removedMd != null) {
            this.notifyListenersAboutRemovedElement(removedMd);
        }
    }

    public void updated(Item oldItem, Item item) {
        this.processItem(item);
    }
}

