/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.core.status.ConfigStatusProvider;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.thing.binding.BridgeHandler;
import org.eclipse.smarthome.core.thing.binding.ThingFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerService;
import org.eclipse.smarthome.core.thing.binding.firmware.FirmwareUpdateHandler;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class BaseThingHandlerFactory
implements ThingHandlerFactory {
    @NonNullByDefault(value={})
    protected BundleContext bundleContext;
    private final Logger logger = LoggerFactory.getLogger(BaseThingHandlerFactory.class);
    private final Map<String, @Nullable ServiceRegistration<ConfigStatusProvider>> configStatusProviders = new ConcurrentHashMap<String, ServiceRegistration<ConfigStatusProvider>>();
    private final Map<String, @Nullable ServiceRegistration<FirmwareUpdateHandler>> firmwareUpdateHandlers = new ConcurrentHashMap<String, ServiceRegistration<FirmwareUpdateHandler>>();
    private final Map<ThingUID, Set<ServiceRegistration<?>>> thingHandlerServices = new ConcurrentHashMap();
    @NonNullByDefault(value={})
    private ServiceTracker<ThingTypeRegistry, ThingTypeRegistry> thingTypeRegistryServiceTracker;
    @NonNullByDefault(value={})
    private ServiceTracker<ConfigDescriptionRegistry, ConfigDescriptionRegistry> configDescriptionRegistryServiceTracker;

    protected void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
        this.thingTypeRegistryServiceTracker = new ServiceTracker(this.bundleContext, ThingTypeRegistry.class.getName(), null);
        this.thingTypeRegistryServiceTracker.open();
        this.configDescriptionRegistryServiceTracker = new ServiceTracker(this.bundleContext, ConfigDescriptionRegistry.class.getName(), null);
        this.configDescriptionRegistryServiceTracker.open();
    }

    protected void deactivate(ComponentContext componentContext) {
        for (ServiceRegistration<ConfigStatusProvider> serviceRegistration : this.configStatusProviders.values()) {
            if (serviceRegistration == null) continue;
            serviceRegistration.unregister();
        }
        for (ServiceRegistration serviceRegistration : this.firmwareUpdateHandlers.values()) {
            if (serviceRegistration == null) continue;
            serviceRegistration.unregister();
        }
        this.thingTypeRegistryServiceTracker.close();
        this.configDescriptionRegistryServiceTracker.close();
        this.configStatusProviders.clear();
        this.firmwareUpdateHandlers.clear();
        this.bundleContext = null;
    }

    protected BundleContext getBundleContext() {
        BundleContext bundleContext = this.bundleContext;
        if (bundleContext != null) {
            return bundleContext;
        }
        throw new IllegalStateException("The bundle context is missing (it seems your thing handler factory is used but not active).");
    }

    @Override
    public ThingHandler registerHandler(Thing thing) {
        ThingHandler thingHandler = this.createHandler(thing);
        if (thingHandler == null) {
            throw new IllegalStateException(String.valueOf(this.getClass().getSimpleName()) + " could not create a handler for the thing '" + (Object)((Object)thing.getUID()) + "'.");
        }
        if (thing instanceof Bridge && !(thingHandler instanceof BridgeHandler)) {
            throw new IllegalStateException("Created handler of bridge '" + (Object)((Object)thing.getUID()) + "' must implement the BridgeHandler interface.");
        }
        this.setHandlerContext(thingHandler);
        this.registerConfigStatusProvider(thing, thingHandler);
        this.registerFirmwareUpdateHandler(thing, thingHandler);
        this.registerServices(thing, thingHandler);
        return thingHandler;
    }

    private void registerServices(Thing thing, ThingHandler thingHandler) {
        ThingUID thingUID = thing.getUID();
        for (Class<? extends ThingHandlerService> c : thingHandler.getServices()) {
            try {
                String[] serviceNamesArray;
                ServiceRegistration serviceReg;
                ThingHandlerService serviceInstance = c.newInstance();
                ThingHandlerService ths = null;
                if (!(serviceInstance instanceof ThingHandlerService)) {
                    this.logger.warn("Should register service={} for thingUID={}, but it does not implement the interface ThingHandlerService.", (Object)c.getCanonicalName(), (Object)thingUID);
                    continue;
                }
                ths = serviceInstance;
                ths.setThingHandler(thingHandler);
                Class<?>[] interfaces = c.getInterfaces();
                LinkedList<String> serviceNames = new LinkedList<String>();
                if (interfaces != null) {
                    Class<?>[] classArray = interfaces;
                    int n = interfaces.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<?> i = classArray[n2];
                        String className = i.getCanonicalName();
                        if (!ThingHandlerService.class.getCanonicalName().equals(className)) {
                            serviceNames.add(className);
                        }
                        ++n2;
                    }
                }
                if (serviceNames.size() <= 0 || (serviceReg = this.bundleContext.registerService(serviceNamesArray = serviceNames.toArray(new String[serviceNames.size()]), (Object)serviceInstance, null)) == null) continue;
                Set<ServiceRegistration<?>> serviceRegs = this.thingHandlerServices.get((Object)thingUID);
                if (serviceRegs == null) {
                    HashSet<ServiceRegistration> set = new HashSet<ServiceRegistration>();
                    set.add(serviceReg);
                    this.thingHandlerServices.put(thingUID, set);
                } else {
                    serviceRegs.add(serviceReg);
                }
                ths.activate();
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.logger.warn("Could not register service for class={}", c, (Object)e);
            }
        }
    }

    private void unregisterServices(Thing thing) {
        ThingUID thingUID = thing.getUID();
        Set<ServiceRegistration<?>> serviceRegs = this.thingHandlerServices.remove((Object)thingUID);
        if (serviceRegs != null) {
            for (ServiceRegistration<?> serviceReg : serviceRegs) {
                ThingHandlerService service = (ThingHandlerService)this.getBundleContext().getService(serviceReg.getReference());
                serviceReg.unregister();
                if (service == null) continue;
                service.deactivate();
            }
        }
    }

    protected abstract @Nullable ThingHandler createHandler(Thing var1);

    private void setHandlerContext(ThingHandler thingHandler) {
        if (thingHandler instanceof BaseThingHandler) {
            if (this.bundleContext == null) {
                throw new IllegalStateException("Base thing handler factory has not been properly initialized. Did you forget to call super.activate()?");
            }
            ((BaseThingHandler)thingHandler).setBundleContext(this.bundleContext);
        }
    }

    private void registerConfigStatusProvider(Thing thing, ThingHandler thingHandler) {
        if (thingHandler instanceof ConfigStatusProvider) {
            ServiceRegistration<ConfigStatusProvider> serviceRegistration = this.registerAsService(thingHandler, ConfigStatusProvider.class);
            this.configStatusProviders.put(thing.getUID().getAsString(), serviceRegistration);
        }
    }

    private void registerFirmwareUpdateHandler(Thing thing, ThingHandler thingHandler) {
        if (thingHandler instanceof FirmwareUpdateHandler) {
            ServiceRegistration<FirmwareUpdateHandler> serviceRegistration = this.registerAsService(thingHandler, FirmwareUpdateHandler.class);
            this.firmwareUpdateHandlers.put(thing.getUID().getAsString(), serviceRegistration);
        }
    }

    private <T> ServiceRegistration<T> registerAsService(ThingHandler thingHandler, Class<T> type) {
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(type.getName(), (Object)thingHandler, null);
        return serviceRegistration;
    }

    @Override
    public void unregisterHandler(Thing thing) {
        ThingHandler thingHandler = thing.getHandler();
        if (thingHandler != null) {
            this.removeHandler(thingHandler);
            this.unsetBundleContext(thingHandler);
        }
        this.unregisterConfigStatusProvider(thing);
        this.unregisterFirmwareUpdateHandler(thing);
        this.unregisterServices(thing);
    }

    protected void removeHandler(ThingHandler thingHandler) {
    }

    private void unsetBundleContext(ThingHandler thingHandler) {
        if (thingHandler instanceof BaseThingHandler) {
            ((BaseThingHandler)thingHandler).unsetBundleContext(this.bundleContext);
        }
    }

    private void unregisterConfigStatusProvider(Thing thing) {
        ServiceRegistration<ConfigStatusProvider> serviceRegistration = this.configStatusProviders.remove(thing.getUID().getAsString());
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private void unregisterFirmwareUpdateHandler(Thing thing) {
        ServiceRegistration<FirmwareUpdateHandler> serviceRegistration = this.firmwareUpdateHandlers.remove(thing.getUID().getAsString());
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    @Override
    public void removeThing(ThingUID thingUID) {
    }

    protected @Nullable ThingType getThingTypeByUID(ThingTypeUID thingTypeUID) {
        if (this.thingTypeRegistryServiceTracker == null) {
            throw new IllegalStateException("Base thing handler factory has not been properly initialized. Did you forget to call super.activate()?");
        }
        ThingTypeRegistry thingTypeRegistry = (ThingTypeRegistry)this.thingTypeRegistryServiceTracker.getService();
        if (thingTypeRegistry != null) {
            return thingTypeRegistry.getThingType(thingTypeUID);
        }
        return null;
    }

    protected @Nullable Thing createThing(ThingTypeUID thingTypeUID, Configuration configuration, ThingUID thingUID) {
        return this.createThing(thingTypeUID, configuration, thingUID, null);
    }

    @Override
    public @Nullable Thing createThing(ThingTypeUID thingTypeUID, Configuration configuration, @Nullable ThingUID thingUID, @Nullable ThingUID bridgeUID) {
        ThingUID effectiveUID = thingUID != null ? thingUID : ThingFactory.generateRandomThingUID(thingTypeUID);
        ThingType thingType = this.getThingTypeByUID(thingTypeUID);
        if (thingType != null) {
            Thing thing = ThingFactory.createThing(thingType, effectiveUID, configuration, bridgeUID, this.getConfigDescriptionRegistry());
            return thing;
        }
        return null;
    }

    protected @Nullable ConfigDescriptionRegistry getConfigDescriptionRegistry() {
        if (this.configDescriptionRegistryServiceTracker == null) {
            throw new IllegalStateException("Config Description Registry has not been properly initialized. Did you forget to call super.activate()?");
        }
        return (ConfigDescriptionRegistry)this.configDescriptionRegistryServiceTracker.getService();
    }
}

