/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding;

import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.core.status.ConfigStatusCallback;
import org.eclipse.smarthome.config.core.status.ConfigStatusProvider;
import org.eclipse.smarthome.config.core.status.ConfigStatusSource;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.binding.BaseBridgeHandler;
import org.eclipse.smarthome.core.thing.binding.ThingConfigStatusSource;

@NonNullByDefault
public abstract class ConfigStatusBridgeHandler
extends BaseBridgeHandler
implements ConfigStatusProvider {
    private @Nullable ConfigStatusCallback configStatusCallback;

    public ConfigStatusBridgeHandler(Bridge bridge) {
        super(bridge);
    }

    public boolean supportsEntity(String entityId) {
        return this.getThing().getUID().getAsString().equals(entityId);
    }

    public void setConfigStatusCallback(@Nullable ConfigStatusCallback configStatusCallback) {
        this.configStatusCallback = configStatusCallback;
    }

    @Override
    public void handleConfigurationUpdate(Map<String, Object> configurationParameters) {
        super.handleConfigurationUpdate(configurationParameters);
        if (this.configStatusCallback != null) {
            this.configStatusCallback.configUpdated((ConfigStatusSource)new ThingConfigStatusSource(this.getThing().getUID().getAsString()));
        }
    }

    @Override
    protected void updateConfiguration(Configuration configuration) {
        super.updateConfiguration(configuration);
        if (this.configStatusCallback != null) {
            this.configStatusCallback.configUpdated((ConfigStatusSource)new ThingConfigStatusSource(this.getThing().getUID().getAsString()));
        }
    }
}

