/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.firmware.FirmwareStatus;

@NonNullByDefault
public final class FirmwareStatusInfo {
    private final ThingUID thingUID;
    private final FirmwareStatus firmwareStatus;
    private final @Nullable String firmwareVersion;

    private FirmwareStatusInfo(ThingUID thingUID, FirmwareStatus firmwareStatus, @Nullable String firmwareVersion) {
        Objects.requireNonNull(thingUID, "Thing UID must not be null.");
        this.thingUID = thingUID;
        Objects.requireNonNull(firmwareStatus, "Firmware status must not be null.");
        this.firmwareStatus = firmwareStatus;
        this.firmwareVersion = firmwareVersion;
    }

    public static FirmwareStatusInfo createUnknownInfo(ThingUID thingUID) {
        return new FirmwareStatusInfo(thingUID, FirmwareStatus.UNKNOWN, null);
    }

    public static FirmwareStatusInfo createUpToDateInfo(ThingUID thingUID) {
        return new FirmwareStatusInfo(thingUID, FirmwareStatus.UP_TO_DATE, null);
    }

    public static FirmwareStatusInfo createUpdateAvailableInfo(ThingUID thingUID) {
        return new FirmwareStatusInfo(thingUID, FirmwareStatus.UPDATE_AVAILABLE, null);
    }

    public static FirmwareStatusInfo createUpdateExecutableInfo(ThingUID thingUID, @Nullable String firmwareVersion) {
        return new FirmwareStatusInfo(thingUID, FirmwareStatus.UPDATE_EXECUTABLE, firmwareVersion);
    }

    public FirmwareStatus getFirmwareStatus() {
        return this.firmwareStatus;
    }

    public @Nullable String getUpdatableFirmwareVersion() {
        return this.firmwareVersion;
    }

    public ThingUID getThingUID() {
        return this.thingUID;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.thingUID == null ? 0 : this.thingUID.hashCode());
        result = 31 * result + (this.firmwareStatus == null ? 0 : this.firmwareStatus.hashCode());
        result = 31 * result + (this.firmwareVersion == null ? 0 : this.firmwareVersion.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FirmwareStatusInfo other = (FirmwareStatusInfo)obj;
        if (this.firmwareStatus != other.firmwareStatus) {
            return false;
        }
        if (this.thingUID == null ? other.thingUID != null : !this.thingUID.equals((Object)other.thingUID)) {
            return false;
        }
        return !(this.firmwareVersion == null ? other.firmwareVersion != null : !this.firmwareVersion.equals(other.firmwareVersion));
    }

    public String toString() {
        return "FirmwareStatusInfo [firmwareStatus=" + (Object)((Object)this.firmwareStatus) + ", firmwareVersion=" + this.firmwareVersion + ", thingUID=" + (Object)((Object)this.thingUID) + "]";
    }
}

