/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.i18n;

import java.util.List;
import java.util.Locale;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.thing.i18n.ChannelTypeI18nLocalizationService;
import org.eclipse.smarthome.core.thing.i18n.ThingTypeI18nUtil;
import org.eclipse.smarthome.core.thing.internal.i18n.ChannelI18nUtil;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelTypeRegistry;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ChannelGroupTypeI18nLocalizationService.class})
@NonNullByDefault
public class ChannelGroupTypeI18nLocalizationService {
    @NonNullByDefault(value={})
    private ChannelI18nUtil channelI18nUtil;
    @NonNullByDefault(value={})
    private ThingTypeI18nUtil thingTypeI18nUtil;
    @NonNullByDefault(value={})
    private ChannelTypeI18nLocalizationService channelTypeI18nLocalizationService;
    @NonNullByDefault(value={})
    private ChannelTypeRegistry channelTypeRegistry;

    @Reference
    protected void setChannelTypeI18nLocalizationService(ChannelTypeI18nLocalizationService channelTypeI18nLocalizationService) {
        this.channelTypeI18nLocalizationService = channelTypeI18nLocalizationService;
    }

    protected void unsetChannelTypeI18nLocalizationService(ChannelTypeI18nLocalizationService channelTypeI18nLocalizationService) {
        this.channelTypeI18nLocalizationService = null;
    }

    @Reference
    protected void setChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = channelTypeRegistry;
    }

    protected void unsetChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = null;
    }

    @Reference
    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        this.thingTypeI18nUtil = new ThingTypeI18nUtil(i18nProvider);
    }

    protected void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.thingTypeI18nUtil = null;
    }

    @Activate
    protected void activate() {
        this.channelI18nUtil = new ChannelI18nUtil(this.channelTypeI18nLocalizationService, this.channelTypeRegistry);
    }

    @Deactivate
    protected void deactivate() {
        this.channelI18nUtil = null;
    }

    public ChannelGroupType createLocalizedChannelGroupType(Bundle bundle, ChannelGroupType channelGroupType, @Nullable Locale locale) {
        ChannelGroupTypeUID channelGroupTypeUID = channelGroupType.getUID();
        String defaultLabel = channelGroupType.getLabel();
        String label = this.thingTypeI18nUtil.getChannelGroupLabel(bundle, channelGroupTypeUID, defaultLabel, locale);
        String description = this.thingTypeI18nUtil.getChannelGroupDescription(bundle, channelGroupTypeUID, channelGroupType.getDescription(), locale);
        List<ChannelDefinition> localizedChannelDefinitions = this.channelI18nUtil.createLocalizedChannelDefinitions(bundle, channelGroupType.getChannelDefinitions(), channelDefinition -> this.thingTypeI18nUtil.getChannelLabel(bundle, channelGroupTypeUID, (ChannelDefinition)channelDefinition, channelDefinition.getLabel(), locale), channelDefinition -> this.thingTypeI18nUtil.getChannelDescription(bundle, channelGroupTypeUID, (ChannelDefinition)channelDefinition, channelDefinition.getDescription(), locale), locale);
        ChannelGroupTypeBuilder builder = ChannelGroupTypeBuilder.instance(channelGroupTypeUID, label == null ? defaultLabel : label).isAdvanced(channelGroupType.isAdvanced()).withCategory(channelGroupType.getCategory()).withChannelDefinitions(localizedChannelDefinitions);
        if (description != null) {
            builder.withDescription(description);
        }
        return builder.build();
    }
}

