/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.i18n.ChannelTypeI18nLocalizationService;
import org.eclipse.smarthome.core.thing.i18n.ThingTypeI18nUtil;
import org.eclipse.smarthome.core.thing.internal.i18n.ChannelI18nUtil;
import org.eclipse.smarthome.core.thing.type.BridgeType;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeRegistry;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelTypeRegistry;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeBuilder;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ThingTypeI18nLocalizationService.class})
@NonNullByDefault
public class ThingTypeI18nLocalizationService {
    @NonNullByDefault(value={})
    private ThingTypeI18nUtil thingTypeI18nUtil;
    @NonNullByDefault(value={})
    private ChannelI18nUtil channelI18nUtil;
    @NonNullByDefault(value={})
    private ChannelGroupTypeRegistry channelGroupTypeRegistry;
    @NonNullByDefault(value={})
    private ChannelTypeI18nLocalizationService channelTypeI18nLocalizationService;
    @NonNullByDefault(value={})
    private ChannelTypeRegistry channelTypeRegistry;

    @Reference
    protected void setChannelTypeI18nLocalizationService(ChannelTypeI18nLocalizationService channelTypeI18nLocalizationService) {
        this.channelTypeI18nLocalizationService = channelTypeI18nLocalizationService;
    }

    protected void unsetChannelTypeI18nLocalizationService(ChannelTypeI18nLocalizationService channelTypeI18nLocalizationService) {
        this.channelTypeI18nLocalizationService = null;
    }

    @Reference
    protected void setChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = channelTypeRegistry;
    }

    protected void unsetChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = null;
    }

    @Reference
    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        this.thingTypeI18nUtil = new ThingTypeI18nUtil(i18nProvider);
    }

    protected void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.thingTypeI18nUtil = null;
    }

    @Reference
    protected void setChannelGroupTypeRegistry(ChannelGroupTypeRegistry channelGroupTypeRegistry) {
        this.channelGroupTypeRegistry = channelGroupTypeRegistry;
    }

    protected void unsetChannelGroupTypeRegistry(ChannelGroupTypeRegistry channelGroupTypeRegistry) {
        this.channelGroupTypeRegistry = null;
    }

    @Activate
    protected void activate() {
        this.channelI18nUtil = new ChannelI18nUtil(this.channelTypeI18nLocalizationService, this.channelTypeRegistry);
    }

    @Deactivate
    protected void deactivate() {
        this.channelI18nUtil = null;
    }

    private List<ChannelGroupDefinition> createLocalizedChannelGroupDefinitions(Bundle bundle, List<ChannelGroupDefinition> channelGroupDefinitions, Function<ChannelGroupDefinition, @Nullable String> channelGroupLabelResolver, Function<ChannelGroupDefinition, @Nullable String> channelGroupDescriptionResolver, @Nullable Locale locale) {
        ArrayList<ChannelGroupDefinition> localizedChannelGroupDefinitions = new ArrayList<ChannelGroupDefinition>(channelGroupDefinitions.size());
        for (ChannelGroupDefinition channelGroupDefinition : channelGroupDefinitions) {
            ChannelGroupTypeUID channelGroupTypeUID;
            ChannelGroupType channelGroupType;
            String channelGroupLabel = channelGroupLabelResolver.apply(channelGroupDefinition);
            String channelGroupDescription = channelGroupDescriptionResolver.apply(channelGroupDefinition);
            if ((channelGroupLabel == null || channelGroupDescription == null) && (channelGroupType = this.channelGroupTypeRegistry.getChannelGroupType(channelGroupTypeUID = channelGroupDefinition.getTypeUID(), locale)) != null) {
                if (channelGroupLabel == null) {
                    channelGroupLabel = this.thingTypeI18nUtil.getChannelGroupLabel(bundle, channelGroupTypeUID, channelGroupType.getLabel(), locale);
                }
                if (channelGroupDescription == null) {
                    channelGroupDescription = this.thingTypeI18nUtil.getChannelGroupDescription(bundle, channelGroupTypeUID, channelGroupType.getDescription(), locale);
                }
            }
            localizedChannelGroupDefinitions.add(new ChannelGroupDefinition(channelGroupDefinition.getId(), channelGroupDefinition.getTypeUID(), channelGroupLabel, channelGroupDescription));
        }
        return localizedChannelGroupDefinitions;
    }

    public ThingType createLocalizedThingType(Bundle bundle, ThingType thingType, @Nullable Locale locale) {
        ThingTypeUID thingTypeUID = thingType.getUID();
        String label = this.thingTypeI18nUtil.getLabel(bundle, thingTypeUID, thingType.getLabel(), locale);
        String description = this.thingTypeI18nUtil.getDescription(bundle, thingTypeUID, thingType.getDescription(), locale);
        List<ChannelDefinition> localizedChannelDefinitions = this.channelI18nUtil.createLocalizedChannelDefinitions(bundle, thingType.getChannelDefinitions(), channelDefinition -> this.thingTypeI18nUtil.getChannelLabel(bundle, thingTypeUID, (ChannelDefinition)channelDefinition, channelDefinition.getLabel(), locale), channelDefinition -> this.thingTypeI18nUtil.getChannelDescription(bundle, thingTypeUID, (ChannelDefinition)channelDefinition, channelDefinition.getDescription(), locale), locale);
        List<ChannelGroupDefinition> localizedChannelGroupDefinitions = this.createLocalizedChannelGroupDefinitions(bundle, thingType.getChannelGroupDefinitions(), channelGroupDefinition -> this.thingTypeI18nUtil.getChannelGroupLabel(bundle, thingTypeUID, (ChannelGroupDefinition)channelGroupDefinition, channelGroupDefinition.getLabel(), locale), channelGroupDefinition -> this.thingTypeI18nUtil.getChannelGroupDescription(bundle, thingTypeUID, (ChannelGroupDefinition)channelGroupDefinition, channelGroupDefinition.getDescription(), locale), locale);
        ThingTypeBuilder builder = ThingTypeBuilder.instance(thingType);
        if (label != null) {
            builder.withLabel(label);
        }
        if (description != null) {
            builder.withDescription(description);
        }
        builder.withChannelDefinitions(localizedChannelDefinitions).withChannelGroupDefinitions(localizedChannelGroupDefinitions);
        if (thingType instanceof BridgeType) {
            return builder.buildBridge();
        }
        return builder.build();
    }
}

