/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.builder.ChannelBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeRegistry;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeRegistry;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThingFactoryHelper {
    private static Logger logger = LoggerFactory.getLogger(ThingFactoryHelper.class);

    public static List<Channel> createChannels(ThingType thingType, ThingUID thingUID, ConfigDescriptionRegistry configDescriptionRegistry) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        List<ChannelDefinition> channelDefinitions = thingType.getChannelDefinitions();
        for (ChannelDefinition channelDefinition : channelDefinitions) {
            Channel channel = ThingFactoryHelper.createChannel(channelDefinition, thingUID, null, configDescriptionRegistry);
            if (channel == null) continue;
            channels.add(channel);
        }
        List<ChannelGroupDefinition> channelGroupDefinitions = thingType.getChannelGroupDefinitions();
        ThingFactoryHelper.withChannelGroupTypeRegistry(channelGroupTypeRegistry -> {
            for (ChannelGroupDefinition channelGroupDefinition : channelGroupDefinitions) {
                ChannelGroupType channelGroupType = null;
                if (channelGroupTypeRegistry != null) {
                    channelGroupType = channelGroupTypeRegistry.getChannelGroupType(channelGroupDefinition.getTypeUID());
                }
                if (channelGroupType != null) {
                    List<ChannelDefinition> channelGroupChannelDefinitions = channelGroupType.getChannelDefinitions();
                    for (ChannelDefinition channelDefinition : channelGroupChannelDefinitions) {
                        Channel channel = ThingFactoryHelper.createChannel(channelDefinition, thingUID, channelGroupDefinition.getId(), configDescriptionRegistry);
                        if (channel == null) continue;
                        channels.add(channel);
                    }
                    continue;
                }
                logger.warn("Could not create channels for channel group '{}' for thing type '{}', because channel group type '{}' could not be found.", new Object[]{channelGroupDefinition.getId(), thingUID, channelGroupDefinition.getTypeUID()});
            }
            return null;
        });
        return channels;
    }

    private static <T> T withChannelGroupTypeRegistry(Function<ChannelGroupTypeRegistry, T> consumer) {
        BundleContext bundleContext = FrameworkUtil.getBundle(ThingFactoryHelper.class).getBundleContext();
        ServiceReference ref = bundleContext.getServiceReference(ChannelGroupTypeRegistry.class.getName());
        try {
            ChannelGroupTypeRegistry channelGroupTypeRegistry = null;
            if (ref != null) {
                channelGroupTypeRegistry = (ChannelGroupTypeRegistry)bundleContext.getService(ref);
            }
            T t = consumer.apply(channelGroupTypeRegistry);
            return t;
        }
        finally {
            if (ref != null) {
                bundleContext.ungetService(ref);
            }
        }
    }

    private static <T> T withChannelTypeRegistry(Function<ChannelTypeRegistry, T> consumer) {
        BundleContext bundleContext = FrameworkUtil.getBundle(ThingFactoryHelper.class).getBundleContext();
        ServiceReference ref = bundleContext.getServiceReference(ChannelTypeRegistry.class.getName());
        try {
            ChannelTypeRegistry channelTypeRegistry = null;
            if (ref != null) {
                channelTypeRegistry = (ChannelTypeRegistry)bundleContext.getService(ref);
            }
            T t = consumer.apply(channelTypeRegistry);
            return t;
        }
        finally {
            if (ref != null) {
                bundleContext.ungetService(ref);
            }
        }
    }

    private static Channel createChannel(ChannelDefinition channelDefinition, ThingUID thingUID, String groupId, ConfigDescriptionRegistry configDescriptionRegistry) {
        String description;
        ChannelType type = ThingFactoryHelper.withChannelTypeRegistry(channelTypeRegistry -> channelTypeRegistry != null ? channelTypeRegistry.getChannelType(channelDefinition.getChannelTypeUID()) : null);
        if (type == null) {
            logger.warn("Could not create channel '{}' for thing type '{}', because channel type '{}' could not be found.", new Object[]{channelDefinition.getId(), thingUID, channelDefinition.getChannelTypeUID()});
            return null;
        }
        ChannelUID channelUID = new ChannelUID(thingUID, groupId, channelDefinition.getId());
        ChannelBuilder channelBuilder = ThingFactoryHelper.createChannelBuilder(channelUID, type, configDescriptionRegistry);
        String label = channelDefinition.getLabel();
        if (label != null) {
            channelBuilder = channelBuilder.withLabel(label);
        }
        if ((description = channelDefinition.getDescription()) != null) {
            channelBuilder = channelBuilder.withDescription(description);
        }
        channelBuilder = channelBuilder.withProperties(channelDefinition.getProperties());
        return channelBuilder.build();
    }

    static ChannelBuilder createChannelBuilder(ChannelUID channelUID, ChannelType channelType, ConfigDescriptionRegistry configDescriptionRegistry) {
        ConfigDescription cd;
        ChannelBuilder channelBuilder = ChannelBuilder.create(channelUID, channelType.getItemType()).withType(channelType.getUID()).withDefaultTags(channelType.getTags()).withKind(channelType.getKind()).withLabel(channelType.getLabel()).withAutoUpdatePolicy(channelType.getAutoUpdatePolicy());
        String description = channelType.getDescription();
        if (description != null) {
            channelBuilder = channelBuilder.withDescription(description);
        }
        URI channelConfigDescriptionURI = channelType.getConfigDescriptionURI();
        if (configDescriptionRegistry != null && channelConfigDescriptionURI != null && (cd = configDescriptionRegistry.getConfigDescription(channelConfigDescriptionURI)) != null) {
            Configuration config = new Configuration();
            for (ConfigDescriptionParameter param : cd.getParameters()) {
                Object value;
                String defaultValue = param.getDefault();
                if (defaultValue == null || (value = ThingFactoryHelper.getDefaultValueAsCorrectType(param.getType(), defaultValue)) == null) continue;
                config.put(param.getName(), value);
            }
            channelBuilder = channelBuilder.withConfiguration(config);
        }
        return channelBuilder;
    }

    public static Object getDefaultValueAsCorrectType(ConfigDescriptionParameter.Type parameterType, String defaultValue) {
        try {
            switch (parameterType) {
                case TEXT: {
                    return defaultValue;
                }
                case BOOLEAN: {
                    return Boolean.parseBoolean(defaultValue);
                }
                case INTEGER: {
                    return new BigDecimal(defaultValue);
                }
                case DECIMAL: {
                    return new BigDecimal(defaultValue);
                }
            }
            return null;
        }
        catch (NumberFormatException ex) {
            LoggerFactory.getLogger(ThingFactoryHelper.class).warn("Could not parse default value '{}' as type '{}': {}", new Object[]{defaultValue, parameterType, ex.getMessage(), ex});
            return null;
        }
    }

    public static void applyDefaultConfiguration(Configuration configuration, ThingType thingType, ConfigDescriptionRegistry configDescriptionRegistry) {
        ConfigDescription thingConfigDescription;
        if (configDescriptionRegistry != null && configuration != null && thingType.getConfigDescriptionURI() != null && (thingConfigDescription = configDescriptionRegistry.getConfigDescription(thingType.getConfigDescriptionURI())) != null) {
            for (ConfigDescriptionParameter parameter : thingConfigDescription.getParameters()) {
                Object value;
                String defaultValue = parameter.getDefault();
                if (defaultValue == null || configuration.get(parameter.getName()) != null || (value = ThingFactoryHelper.getDefaultValueAsCorrectType(parameter.getType(), defaultValue)) == null) continue;
                configuration.put(parameter.getName(), value);
            }
        }
    }
}

