/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.profiles;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.thing.profiles.ProfileCallback;
import org.eclipse.smarthome.core.thing.profiles.ProfileContext;
import org.eclipse.smarthome.core.thing.profiles.ProfileTypeUID;
import org.eclipse.smarthome.core.thing.profiles.SystemProfiles;
import org.eclipse.smarthome.core.thing.profiles.TriggerProfile;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;

@NonNullByDefault
public class RawRockerDimmerProfile
implements TriggerProfile {
    private final ProfileCallback callback;
    private final ProfileContext context;
    private @Nullable ScheduledFuture<?> dimmFuture;
    private @Nullable ScheduledFuture<?> timeoutFuture;
    private long pressedTime = 0L;

    RawRockerDimmerProfile(ProfileCallback callback, ProfileContext context) {
        this.callback = callback;
        this.context = context;
    }

    @Override
    public ProfileTypeUID getProfileTypeUID() {
        return SystemProfiles.RAWROCKER_DIMMER;
    }

    @Override
    public void onStateUpdateFromItem(State state) {
    }

    @Override
    public void onTriggerFromHandler(String event) {
        if ("DIR1_PRESSED".equals(event)) {
            this.buttonPressed((Command)IncreaseDecreaseType.INCREASE);
        } else if ("DIR1_RELEASED".equals(event)) {
            this.buttonReleased((Command)OnOffType.ON);
        } else if ("DIR2_PRESSED".equals(event)) {
            this.buttonPressed((Command)IncreaseDecreaseType.DECREASE);
        } else if ("DIR2_RELEASED".equals(event)) {
            this.buttonReleased((Command)OnOffType.OFF);
        }
    }

    private synchronized void buttonPressed(Command commandToSend) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        this.cancelDimmFuture();
        this.dimmFuture = this.context.getExecutorService().scheduleWithFixedDelay(() -> this.callback.sendCommand(commandToSend), 550L, 200L, TimeUnit.MILLISECONDS);
        this.timeoutFuture = this.context.getExecutorService().schedule(() -> this.cancelDimmFuture(), 10L, TimeUnit.SECONDS);
        this.pressedTime = System.currentTimeMillis();
    }

    private synchronized void buttonReleased(Command commandToSend) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        this.cancelDimmFuture();
        if (System.currentTimeMillis() - this.pressedTime <= 500L) {
            this.callback.sendCommand(commandToSend);
        }
    }

    private synchronized void cancelDimmFuture() {
        if (this.dimmFuture != null) {
            this.dimmFuture.cancel(false);
        }
    }
}

